/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.TextOptions;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.editor.FragmentData;
import net.sf.okapi.lib.ui.editor.FragmentDataTransfer;
import net.sf.okapi.lib.ui.editor.OptionsDialog;
import net.sf.okapi.lib.ui.editor.PairEditorPanel;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class TextContainerEditorPanel {
    private static final String SEGTYPECHAR = "\ufff9";
    private String codedText;
    private List<Code> codes;
    private TextContainer textCont;
    private TextFragment textFrag;
    private StyledText edit;
    private TextStyle codeStyle;
    private TextStyle markStyle;
    private int mode = 0;
    private Menu contextMenu;
    private TextOptions textOptions;
    private ArrayList<StyleRange> ranges;
    private boolean updateCodeRanges = false;
    private int prevPos = 0;
    private int selAnchor = -1;
    private boolean targetMode = false;
    private TextContainerEditorPanel source;
    private PairEditorPanel parentPanel;
    private int nextCodeForCopy = -1;
    private boolean modified;
    private final int frontChars = 6;
    private final int tailChars = 3;
    private final int maxChars = 12;

    public TextContainerEditorPanel(Composite parent, int flag, boolean paramTargetMode) {
        this.targetMode = paramTargetMode;
        if (flag < 0) {
            flag = 2624;
        }
        this.edit = new StyledText(parent, flag);
        GridData gdTmp = new GridData(1808);
        this.edit.setLayoutData(gdTmp);
        this.codeStyle = new TextStyle();
        this.codeStyle.foreground = parent.getDisplay().getSystemColor(3);
        this.markStyle = new TextStyle();
        this.markStyle.foreground = parent.getDisplay().getSystemColor(15);
        this.createContextMenu();
        this.edit.setMenu(this.contextMenu);
        this.edit.addCaretListener(new CaretListener(){

            @Override
            public void caretMoved(CaretEvent e) {
                for (StyleRange range : TextContainerEditorPanel.this.ranges) {
                    if (e.caretOffset <= range.start || e.caretOffset >= range.start + range.length) continue;
                    if (TextContainerEditorPanel.this.prevPos < e.caretOffset) {
                        TextContainerEditorPanel.this.prevPos = range.start + range.length;
                    } else {
                        TextContainerEditorPanel.this.prevPos = range.start;
                    }
                    if (TextContainerEditorPanel.this.selAnchor != -1) {
                        Point pt = TextContainerEditorPanel.this.edit.getSelection();
                        if (TextContainerEditorPanel.this.selAnchor < e.caretOffset) {
                            pt.x = TextContainerEditorPanel.this.selAnchor;
                            pt.y = TextContainerEditorPanel.this.prevPos;
                            TextContainerEditorPanel.this.edit.setSelection(pt);
                        } else {
                            pt.x = TextContainerEditorPanel.this.selAnchor;
                            pt.y = TextContainerEditorPanel.this.prevPos;
                            TextContainerEditorPanel.this.edit.setSelection(pt);
                        }
                    } else {
                        TextContainerEditorPanel.this.edit.setCaretOffset(TextContainerEditorPanel.this.prevPos);
                    }
                    return;
                }
                TextContainerEditorPanel.this.prevPos = e.caretOffset;
            }
        });
        this.edit.addMouseListener(new MouseListener(){

            @Override
            public void mouseUp(MouseEvent e) {
                TextContainerEditorPanel.this.selAnchor = -1;
            }

            @Override
            public void mouseDown(MouseEvent e) {
                Point pt = TextContainerEditorPanel.this.edit.getSelection();
                if (pt.y == TextContainerEditorPanel.this.edit.getCaretOffset()) {
                    TextContainerEditorPanel.this.selAnchor = pt.x;
                } else {
                    TextContainerEditorPanel.this.selAnchor = pt.y;
                }
            }

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                int pos = TextContainerEditorPanel.this.edit.getCaretOffset();
                StyleRange sr = TextContainerEditorPanel.this.getCodeRangeIfInside(pos);
                if (sr != null) {
                    TextContainerEditorPanel.this.edit.setSelection(sr.start, sr.start + sr.length);
                }
            }
        });
        this.edit.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 131072) {
                    TextContainerEditorPanel.this.selAnchor = -1;
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 131072) {
                    Point pt = TextContainerEditorPanel.this.edit.getSelection();
                    if (pt.y == TextContainerEditorPanel.this.edit.getCaretOffset()) {
                        TextContainerEditorPanel.this.selAnchor = pt.x;
                    } else {
                        TextContainerEditorPanel.this.selAnchor = pt.y;
                    }
                }
            }
        });
        this.edit.addVerifyKeyListener(new VerifyKeyListener(){

            @Override
            public void verifyKey(VerifyEvent e) {
                if (e.stateMask == 65536) {
                    switch (e.keyCode) {
                        case 0x1000004: {
                            TextContainerEditorPanel.this.selectNextCode(TextContainerEditorPanel.this.edit.getCaretOffset(), true);
                            e.doit = false;
                            break;
                        }
                        case 0x1000003: {
                            TextContainerEditorPanel.this.selectPreviousCode(TextContainerEditorPanel.this.edit.getCaretOffset(), true);
                            e.doit = false;
                            break;
                        }
                        case 0x1000002: {
                            TextContainerEditorPanel.this.setNextSourceCode();
                            e.doit = false;
                            break;
                        }
                        case 0x1000001: {
                            TextContainerEditorPanel.this.setPreviousSourceCode();
                            e.doit = false;
                        }
                    }
                } else if (e.stateMask == 262144) {
                    switch (e.keyCode) {
                        case 100: {
                            TextContainerEditorPanel.this.cycleDisplayMode();
                            e.doit = false;
                            break;
                        }
                        case 99: {
                            TextContainerEditorPanel.this.copyToClipboard(TextContainerEditorPanel.this.edit.getSelection());
                            e.doit = false;
                            break;
                        }
                        case 118: {
                            TextContainerEditorPanel.this.pasteFromClipboard();
                            e.doit = false;
                            break;
                        }
                        case 32: {
                            TextContainerEditorPanel.this.placeText("\u00a0");
                            e.doit = false;
                        }
                    }
                } else if (e.stateMask == 131072) {
                    switch (e.keyCode) {
                        case 127: {
                            TextContainerEditorPanel.this.cutToClipboard(TextContainerEditorPanel.this.edit.getSelection());
                            e.doit = false;
                            break;
                        }
                        case 0x1000009: {
                            TextContainerEditorPanel.this.pasteFromClipboard();
                            e.doit = false;
                        }
                    }
                }
            }
        });
        this.edit.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent e) {
                if (!TextContainerEditorPanel.this.updateCodeRanges) {
                    return;
                }
                if (e.start == TextContainerEditorPanel.this.edit.getCharCount()) {
                    TextContainerEditorPanel.this.modified = true;
                    return;
                }
                int len = e.end - e.start;
                if (len == 0) {
                    int n;
                    if (e.start > 0 && (n = TextContainerEditorPanel.this.isOnCodeRange(e.start)) != -1 && n != e.start) {
                        e.doit = false;
                        return;
                    }
                } else if (TextContainerEditorPanel.this.breakRange(e.start, e.end)) {
                    e.doit = false;
                    return;
                }
                TextContainerEditorPanel.this.modified = true;
                TextContainerEditorPanel.this.updateRanges(e.start, e.end, e.text.length());
            }
        });
        this.edit.setMargins(2, 2, 2, 2);
        this.edit.setKeyBinding(262241, 262209);
        this.edit.setKeyBinding(262243, 0);
        this.edit.setKeyBinding(262262, 0);
        this.edit.setKeyBinding(131199, 0);
        this.edit.setKeyBinding(16908297, 0);
        this.textOptions = new TextOptions(parent.getDisplay(), this.edit, 3);
        this.textOptions.applyTo(this.edit);
    }

    protected void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.textOptions != null) {
            this.textOptions.dispose();
            this.textOptions = null;
        }
        UIUtil.disposeTextStyle(this.codeStyle);
        UIUtil.disposeTextStyle(this.markStyle);
    }

    public boolean setFocus() {
        return this.edit.setFocus();
    }

    public void setTargetRelations(TextContainerEditorPanel source, PairEditorPanel parentPanel) {
        this.source = source;
        this.parentPanel = parentPanel;
    }

    public void setEnabled(boolean enabled) {
        this.edit.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.edit.setEditable(editable);
    }

    private void placeText(String text) {
        Point pt = this.edit.getSelection();
        this.edit.replaceTextRange(pt.x, pt.y - pt.x, text);
        this.edit.setCaretOffset(pt.x + text.length());
    }

    private void createContextMenu() {
        this.contextMenu = new Menu(this.edit.getShell(), 8);
        MenuItem item = new MenuItem(this.contextMenu, 8);
        item.setText("Change Code Display Mode");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TextContainerEditorPanel.this.cycleDisplayMode();
            }
        });
        if (this.targetMode) {
            new MenuItem(this.contextMenu, 2);
            item = new MenuItem(this.contextMenu, 8);
            item.setText("Edit Code");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    TextContainerEditorPanel.this.editCode();
                }
            });
            item = new MenuItem(this.contextMenu, 8);
            item.setText("Remove All Codes");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    TextContainerEditorPanel.this.clearCodes();
                }
            });
            item = new MenuItem(this.contextMenu, 8);
            item.setText("Copy Source Into Target");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    TextContainerEditorPanel.this.pasteSource();
                }
            });
            item = new MenuItem(this.contextMenu, 8);
            item.setText("Copy Source Codes Into Target");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    TextContainerEditorPanel.this.pasteAllSourceCodes();
                }
            });
            new MenuItem(this.contextMenu, 2);
            item = new MenuItem(this.contextMenu, 8);
            item.setText("Switch Panel Orientation");
            item.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    TextContainerEditorPanel.this.parentPanel.setOrientation(TextContainerEditorPanel.this.parentPanel.getOrientation() == 512 ? 256 : 512);
                }
            });
        }
        new MenuItem(this.contextMenu, 2);
        item = new MenuItem(this.contextMenu, 8);
        item.setText("Options...");
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TextContainerEditorPanel.this.editOptions();
            }
        });
    }

    private void cycleDisplayMode() {
        Point pt = this.cacheContent(this.edit.getSelection());
        if (pt == null) {
            return;
        }
        this.mode = this.mode == 0 ? 1 : (this.mode == 2 ? 0 : 2);
        this.updateText(pt);
    }

    private void refresh() {
        Point pt = this.cacheContent(this.edit.getSelection());
        if (pt == null) {
            return;
        }
        this.updateText(pt);
    }

    private void createContainerFromFragment() {
        try {
            this.textCont.clear();
            ISegments segs = this.textCont.getSegments();
            Segment seg = null;
            ArrayList<Code> tmpCodes = new ArrayList<Code>();
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < this.codedText.length(); ++i) {
                if (TextFragment.isMarker((char)this.codedText.charAt(i))) {
                    Code code;
                    if ((code = this.codes.get(TextFragment.toIndex((char)this.codedText.charAt(++i)))).getType().equals(SEGTYPECHAR)) {
                        if (code.getTagType() == TextFragment.TagType.OPENING) {
                            if (seg != null) {
                                throw new RuntimeException("Invalid opening segment marker: " + code.getOuterData());
                            }
                            if (tmp.length() > 0) {
                                this.textCont.append(new TextFragment(tmp.toString(), tmpCodes));
                            }
                            seg = new Segment();
                            seg.id = code.getOuterData().substring(1, code.getOuterData().length() - 1);
                        } else {
                            if (seg == null) {
                                throw new RuntimeException("Invalid closing segment marker: " + code.getOuterData());
                            }
                            seg.text = new TextFragment(tmp.toString(), tmpCodes);
                            segs.append(seg);
                            seg = null;
                        }
                        tmp = new StringBuilder();
                        tmpCodes = new ArrayList();
                        continue;
                    }
                    tmpCodes.add(code);
                    tmp.append(String.format("%c%c", Character.valueOf(this.codedText.charAt(i - 1)), Character.valueOf(TextFragment.toChar((int)(tmpCodes.size() - 1)))));
                    continue;
                }
                tmp.append(this.codedText.charAt(i));
            }
            if (seg != null) {
                throw new RuntimeException("Missing closing segment marker.");
            }
            if (tmp.length() > 0) {
                this.textCont.append(new TextFragment(tmp.toString(), tmpCodes));
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error creating fragment.\n" + e.getLocalizedMessage(), null);
        }
    }

    private void createFragmentFromContainer() {
        try {
            StringBuilder tmp = new StringBuilder();
            this.codes = new ArrayList<Code>();
            StringBuilder tmpPart = new StringBuilder();
            for (TextPart part : this.textCont) {
                Code segCode;
                if (part.isSegment()) {
                    segCode = new Code(TextFragment.TagType.OPENING, SEGTYPECHAR);
                    segCode.setOuterData("{" + ((Segment)part).getId() + ">");
                    this.codes.add(segCode);
                    tmp.append(String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar((int)(this.codes.size() - 1)))));
                }
                tmpPart.setLength(0);
                tmpPart.append(part.text.getCodedText());
                int newIndex = this.codes.size();
                for (int j = 0; j < tmpPart.length(); ++j) {
                    if (!TextFragment.isMarker((char)tmpPart.charAt(j))) continue;
                    tmpPart.setCharAt(++j, TextFragment.toChar((int)newIndex++));
                }
                tmp.append((CharSequence)tmpPart);
                this.codes.addAll(part.text.getCodes());
                if (!part.isSegment()) continue;
                segCode = new Code(TextFragment.TagType.CLOSING, SEGTYPECHAR);
                segCode.setOuterData("<" + ((Segment)part).getId() + "}");
                this.codes.add(segCode);
                tmp.append(String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar((int)(this.codes.size() - 1)))));
            }
            this.codedText = tmp.toString();
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error creating container back.\n" + e.getLocalizedMessage(), null);
        }
    }

    public void setText(TextFragment oriFrag) {
        this.modified = false;
        this.textCont = null;
        this.textFrag = oriFrag;
        this.edit.setEnabled(oriFrag != null);
        if (oriFrag == null) {
            this.edit.setText("");
        } else {
            this.codedText = this.textFrag.getCodedText();
            this.codes = new ArrayList<Code>(this.textFrag.getCodes());
            this.updateText(null);
        }
    }

    public void setText(TextContainer oriCont) {
        this.modified = false;
        this.textFrag = null;
        this.textCont = oriCont;
        this.edit.setEnabled(oriCont != null);
        if (oriCont == null) {
            this.edit.setText("");
            return;
        }
        this.createFragmentFromContainer();
        this.updateText(null);
    }

    public void clear() {
        this.textFrag = null;
        this.textCont = null;
        this.edit.setText("");
        this.codedText = null;
        this.modified = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean applyChanges() {
        try {
            if (!this.modified) {
                return true;
            }
            this.cacheContent(null);
            if (this.textFrag != null) {
                this.textFrag.setCodedText(this.codedText, this.codes, true);
            } else {
                this.createContainerFromFragment();
            }
            this.modified = false;
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error when applying changes.\n" + e.getLocalizedMessage(), null);
            this.edit.setFocus();
            return false;
        }
        return true;
    }

    private Point cacheContent(Point sel) {
        try {
            Point pt = new Point(0, 0);
            if (sel != null) {
                pt.x = sel.x;
                pt.y = sel.y;
            }
            if (sel == null && !this.modified || this.codedText == null) {
                return pt;
            }
            Code code = null;
            StringBuilder tmp = new StringBuilder(this.edit.getText());
            int diff = 0;
            for (StyleRange range : this.ranges) {
                code = (Code)range.data;
                int index = this.getCodeObjectIndex(code);
                switch (code.getTagType()) {
                    case OPENING: {
                        tmp.replace(diff + range.start, diff + (range.start + range.length), String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar((int)index))));
                        break;
                    }
                    case CLOSING: {
                        tmp.replace(diff + range.start, diff + (range.start + range.length), String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar((int)index))));
                        break;
                    }
                    case PLACEHOLDER: {
                        tmp.replace(diff + range.start, diff + (range.start + range.length), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar((int)index))));
                    }
                }
                diff += 2 - range.length;
                if (sel == null) continue;
                if (sel.x >= range.start + range.length) {
                    pt.x += 2 - range.length;
                }
                if (sel.y < range.start + range.length) continue;
                pt.y += 2 - range.length;
            }
            this.codedText = tmp.toString();
            return pt;
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error when retrieving edited text.\n" + e.getLocalizedMessage(), null);
            this.edit.setFocus();
            return null;
        }
    }

    private int getCodeObjectIndex(Code codeToSearch) {
        for (int i = 0; i < this.codes.size(); ++i) {
            if (codeToSearch != this.codes.get(i)) continue;
            return i;
        }
        return -1;
    }

    private void updateRanges(int start, int end, int length) {
        if (!this.updateCodeRanges) {
            return;
        }
        length -= end - start;
        Iterator<StyleRange> iter = this.ranges.iterator();
        while (iter.hasNext()) {
            StyleRange range = iter.next();
            if (end <= range.start) {
                range.start += length;
                continue;
            }
            if (start > range.start || end < range.start + range.length) continue;
            this.codes.remove((Code)range.data);
            iter.remove();
        }
    }

    public FragmentData getNextCode() {
        if (this.codes.isEmpty()) {
            return null;
        }
        ++this.nextCodeForCopy;
        if (this.nextCodeForCopy >= this.codes.size()) {
            this.nextCodeForCopy = 0;
        }
        return this.getCode(this.nextCodeForCopy);
    }

    public FragmentData getPreviousCode() {
        if (this.codes.isEmpty()) {
            return null;
        }
        --this.nextCodeForCopy;
        if (this.nextCodeForCopy < 0) {
            this.nextCodeForCopy = this.codes.size() - 1;
        }
        return this.getCode(this.nextCodeForCopy);
    }

    public FragmentData getAllContent() {
        FragmentData data = new FragmentData();
        this.cacheContent(null);
        data.codedText = this.codedText;
        data.codes = new ArrayList<Code>(this.codes);
        return data;
    }

    public FragmentData getAllCodes() {
        FragmentData data = new FragmentData();
        data.codes = new ArrayList<Code>();
        StringBuilder tmp = new StringBuilder();
        for (Code code : this.codes) {
            data.codes.add(code.clone());
            switch (code.getTagType()) {
                case OPENING: {
                    tmp.append(String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar((int)(data.codes.size() - 1)))));
                    break;
                }
                case CLOSING: {
                    tmp.append(String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar((int)(data.codes.size() - 1)))));
                    break;
                }
                case PLACEHOLDER: {
                    tmp.append(String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar((int)(data.codes.size() - 1)))));
                }
            }
        }
        data.codedText = tmp.toString();
        return data;
    }

    private FragmentData getCode(int index) {
        FragmentData data = new FragmentData();
        data.codes = new ArrayList<Code>();
        Code code = this.codes.get(index);
        data.codes.add(code.clone());
        switch (code.getTagType()) {
            case OPENING: {
                data.codedText = String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar((int)0)));
                break;
            }
            case CLOSING: {
                data.codedText = String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar((int)0)));
                break;
            }
            case PLACEHOLDER: {
                data.codedText = String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar((int)0)));
            }
        }
        for (StyleRange range : this.ranges) {
            if (code != (Code)range.data) continue;
            this.edit.setSelection(range.start, range.start + range.length);
            break;
        }
        return data;
    }

    private int isOnCodeRange(int position) {
        for (StyleRange range : this.ranges) {
            if (position < range.start || position >= range.start + range.length) continue;
            return range.start;
        }
        return -1;
    }

    private StyleRange getCodeRangeIfInside(int position) {
        for (StyleRange range : this.ranges) {
            if (position < range.start || position >= range.start + range.length) continue;
            return range;
        }
        return null;
    }

    private boolean breakRange(int start, int end) {
        for (StyleRange range : this.ranges) {
            if (start > range.start && start < range.start + range.length) {
                return true;
            }
            if (end <= range.start || end >= range.start + range.length) continue;
            return true;
        }
        return false;
    }

    private String makeDisplayCode(Code code) {
        String data;
        if (this.mode == 0) {
            if (code.getData().isEmpty()) {
                if (code.getType().equals(SEGTYPECHAR)) {
                    return code.getOuterData();
                }
                switch (code.getTagType()) {
                    case OPENING: {
                        return String.format("{%d}", code.getId());
                    }
                    case CLOSING: {
                        return String.format("{/%d}", code.getId());
                    }
                    case PLACEHOLDER: {
                        return String.format("{%d/}", code.getId());
                    }
                }
            } else {
                switch (code.getTagType()) {
                    case OPENING: {
                        return String.format("<%d>", code.getId());
                    }
                    case CLOSING: {
                        return String.format("</%d>", code.getId());
                    }
                    case PLACEHOLDER: {
                        return String.format("<%d/>", code.getId());
                    }
                }
                return "</OTHER/>";
            }
        }
        if ((data = code.getData()).isEmpty() && (data = code.getOuterData()).isEmpty()) {
            data = "<>";
        }
        if (this.mode == 1) {
            return data;
        }
        int len = data.length();
        if (len > 12) {
            return String.format("%s...%s", data.subSequence(0, 6), data.subSequence(len - 3, len));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateText(Point sel) {
        try {
            if (this.codedText == null) {
                return;
            }
            this.updateCodeRanges = false;
            StringBuilder tmp = new StringBuilder();
            this.ranges = new ArrayList();
            int pos = 0;
            String disp = null;
            Point pt = new Point(0, 0);
            if (sel != null) {
                pt.x = sel.x;
                pt.y = sel.y;
            }
            for (int i = 0; i < this.codedText.length(); ++i) {
                if (TextFragment.isMarker((char)this.codedText.charAt(i))) {
                    Code code = this.codes.get(TextFragment.toIndex((char)this.codedText.charAt(++i)));
                    disp = this.makeDisplayCode(code);
                    tmp.append(disp);
                    StyleRange sr = new StyleRange(code.getData().isEmpty() ? this.markStyle : this.codeStyle);
                    sr.start = pos;
                    sr.length = disp.length();
                    sr.data = code;
                    this.ranges.add(sr);
                    pos += disp.length();
                    if (sel == null) continue;
                    if (sel.x >= i) {
                        pt.x += disp.length() - 2;
                    }
                    if (sel.y < i) continue;
                    pt.y += disp.length() - 2;
                    continue;
                }
                tmp.append(this.codedText.charAt(i));
                ++pos;
            }
            this.nextCodeForCopy = -1;
            this.edit.setText(tmp.toString());
            for (StyleRange range : this.ranges) {
                this.edit.setStyleRange(range);
            }
            if (sel != null) {
                this.edit.setSelection(pt);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error when updating text.\n" + e.getLocalizedMessage(), null);
            this.edit.setFocus();
        }
        finally {
            this.updateCodeRanges = true;
        }
    }

    private void pasteSource() {
        if (!this.targetMode) {
            return;
        }
        this.setFragmentData(this.source.getAllContent(), 1);
    }

    private void pasteAllSourceCodes() {
        if (!this.targetMode) {
            return;
        }
        this.setFragmentData(this.source.getAllCodes(), 1);
    }

    private void setNextSourceCode() {
        if (!this.targetMode) {
            return;
        }
        this.setFragmentData(this.source.getNextCode(), 0);
    }

    private void setPreviousSourceCode() {
        if (!this.targetMode) {
            return;
        }
        this.setFragmentData(this.source.getPreviousCode(), 0);
    }

    private void setFragmentData(FragmentData data, int positionAfter) {
        try {
            if (data == null) {
                return;
            }
            Point sel = this.edit.getSelection();
            this.remove(sel.x, sel.y);
            int index = 0;
            for (StyleRange range : this.ranges) {
                if (range.start >= sel.x) break;
                ++index;
            }
            StringBuilder tmp = new StringBuilder();
            String disp = null;
            int pos = sel.x;
            ArrayList<StyleRange> newRanges = new ArrayList<StyleRange>();
            int insPos = index;
            for (int i = 0; i < data.codedText.length(); ++i) {
                if (TextFragment.isMarker((char)data.codedText.charAt(i))) {
                    Code code = data.codes.get(TextFragment.toIndex((char)data.codedText.charAt(++i))).clone();
                    disp = this.makeDisplayCode(code);
                    tmp.append(disp);
                    StyleRange sr = new StyleRange(code.getData().isEmpty() ? this.markStyle : this.codeStyle);
                    sr.start = pos;
                    sr.length = disp.length();
                    sr.data = code;
                    pos += disp.length();
                    newRanges.add(sr);
                    this.codes.add(insPos++, code);
                    continue;
                }
                tmp.append(data.codedText.charAt(i));
                ++pos;
            }
            this.edit.replaceTextRange(sel.x, 0, tmp.toString());
            for (StyleRange newRange : newRanges) {
                this.edit.setStyleRange(newRange);
                this.ranges.add(index++, newRange);
            }
            this.modified = true;
            switch (positionAfter) {
                case 1: {
                    this.edit.setCaretOffset(sel.x);
                    break;
                }
                case 2: {
                    this.edit.setCaretOffset(sel.x + tmp.length());
                    break;
                }
                default: {
                    this.edit.setSelection(sel.x, sel.x + tmp.length());
                    break;
                }
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error when placing fragment data.\n" + e.getLocalizedMessage(), null);
            this.edit.setFocus();
        }
    }

    private void remove(int start, int end) {
        if (start == end) {
            return;
        }
        this.edit.replaceTextRange(start, end - start, "");
    }

    private void selectNextCode(int position, boolean cycle) {
        if (this.ranges.size() == 0) {
            return;
        }
        while (true) {
            for (StyleRange range : this.ranges) {
                if (position > range.start) continue;
                this.edit.setSelection(range.start, range.start + range.length);
                return;
            }
            if (!cycle) {
                return;
            }
            position = 0;
        }
    }

    private void clearCodes() {
        if (!this.edit.getEditable()) {
            return;
        }
        this.cacheContent(null);
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < this.codedText.length(); ++i) {
            if (TextFragment.isMarker((char)this.codedText.charAt(i))) {
                ++i;
                continue;
            }
            tmp.append(this.codedText.charAt(i));
        }
        this.codes.clear();
        this.codedText = tmp.toString();
        this.updateText(null);
        this.edit.setCaretOffset(0);
    }

    private void selectPreviousCode(int position, boolean cycle) {
        if (this.ranges.size() == 0) {
            return;
        }
        while (true) {
            for (int i = this.ranges.size() - 1; i >= 0; --i) {
                StyleRange sr = this.ranges.get(i);
                if (position < sr.start + sr.length) continue;
                Point pt = this.edit.getSelection();
                if (pt.x == sr.start && pt.x != pt.y) continue;
                this.edit.setSelection(sr.start, sr.start + sr.length);
                return;
            }
            if (!cycle) {
                return;
            }
            position = this.edit.getCharCount() - 1;
        }
    }

    private FragmentData getSelection(Point selection) {
        FragmentData data = new FragmentData();
        StringBuilder tmp = new StringBuilder(this.edit.getText(selection.x, selection.y - 1));
        data.codes = new ArrayList<Code>();
        int diff = -1 * selection.x;
        for (StyleRange range : this.ranges) {
            if (range.start >= selection.y) break;
            if (range.start + range.length <= selection.x) continue;
            Code code = (Code)range.data;
            switch (code.getTagType()) {
                case OPENING: {
                    tmp.replace(diff + range.start, diff + (range.start + range.length), String.format("%c%c", Character.valueOf('\ue101'), Character.valueOf(TextFragment.toChar((int)data.codes.size()))));
                    break;
                }
                case CLOSING: {
                    tmp.replace(diff + range.start, diff + (range.start + range.length), String.format("%c%c", Character.valueOf('\ue102'), Character.valueOf(TextFragment.toChar((int)data.codes.size()))));
                    break;
                }
                case PLACEHOLDER: {
                    tmp.replace(diff + range.start, diff + (range.start + range.length), String.format("%c%c", Character.valueOf('\ue103'), Character.valueOf(TextFragment.toChar((int)data.codes.size()))));
                }
            }
            data.codes.add(code.clone());
            diff += 2 - range.length;
        }
        data.codedText = tmp.toString();
        return data;
    }

    private void editCode() {
        Point selection = this.edit.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        FragmentData data = this.getSelection(selection);
        if (data.codedText.length() != 2 || !TextFragment.isMarker((char)data.codedText.charAt(0))) {
            Dialogs.showError(this.edit.getShell(), "The selection must contain one code and one only.", null);
            return;
        }
        Code code = data.codes.get(0);
        InputDialog dlg = new InputDialog(this.edit.getShell(), "Edit Code", "Content of the code", code.getData(), null, 0, 50, 1);
        String res = dlg.showDialog();
        if (res == null) {
            return;
        }
        code.setData(res);
        this.setFragmentData(data, 2);
    }

    private void cutToClipboard(Point selection) {
        FragmentData data = this.getSelection(selection);
        String plainText = this.edit.getText(selection.x, selection.y - 1);
        this.remove(selection.x, selection.y);
        this.placeIntoClipboard(data, plainText);
    }

    private void copyToClipboard(Point selection) {
        this.placeIntoClipboard(this.getSelection(selection), this.edit.getText(selection.x, selection.y - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteFromClipboard() {
        Clipboard clipboard = new Clipboard(this.edit.getDisplay());
        try {
            TransferData[] transferDatas;
            for (TransferData transData : transferDatas = clipboard.getAvailableTypes()) {
                if (!FragmentDataTransfer.getInstance().isSupportedType(transData)) continue;
                FragmentData data = (FragmentData)clipboard.getContents(FragmentDataTransfer.getInstance());
                this.setFragmentData(data, 2);
                break;
            }
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeIntoClipboard(FragmentData data, String plainText) {
        Clipboard clipboard = new Clipboard(this.edit.getDisplay());
        try {
            FragmentDataTransfer dataTrans = FragmentDataTransfer.getInstance();
            TextTransfer textTrans = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{data, plainText}, new Transfer[]{dataTrans, textTrans});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private void editOptions() {
        try {
            OptionsDialog dlg = new OptionsDialog(this.edit.getShell(), null);
            dlg.setData(this.textOptions, this.codeStyle, this.markStyle);
            if (!dlg.showDialog()) {
                return;
            }
            TextOptions tmpTO = this.textOptions;
            this.textOptions = dlg.getTextOptions();
            TextStyle tmpTS1 = this.codeStyle;
            this.codeStyle = dlg.getCodeStyle();
            TextStyle tmpTS2 = this.markStyle;
            this.markStyle = dlg.getMarkStyle();
            this.textOptions.applyTo(this.edit);
            this.refresh();
            tmpTO.dispose();
            UIUtil.disposeTextStyle(tmpTS1);
            UIUtil.disposeTextStyle(tmpTS2);
        }
        catch (Throwable e) {
            Dialogs.showError(this.edit.getShell(), "Error editing options.\n" + e.getMessage(), null);
        }
    }
}

