/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xsltransform.ui;

import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.ConfigurationString;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.NSContextManager;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.xsltransform.Parameters;
import net.sf.okapi.steps.xsltransform.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkUseCustomTransformer;
    private Text edFactoryClass;
    private Text edXpathFactoryClass;
    private Text edXsltPath;
    private Text edParameters;
    private IHelp help;
    private String projectDir;
    private Composite mainComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.projectDir = context.getString("projDir");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText(Res.getString("editor.caption"));
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.createComposite(this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("XSL Transformation Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !ParametersEditor.this.saveData()) {
                    return;
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData(new GridData(1808));
        this.mainComposite.setLayout(new GridLayout(4, false));
        Label label = new Label(this.mainComposite, 0);
        label.setText(Res.getString("editor.stXsltPath"));
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 4;
        label.setLayoutData(gdTmp);
        this.edXsltPath = new Text(this.mainComposite, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.edXsltPath.setLayoutData(gdTmp);
        Button btGetPath = new Button(this.mainComposite, 8);
        btGetPath.setText("...");
        btGetPath.setLayoutData(new GridData(128));
        btGetPath.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] paths = Dialogs.browseFilenames(ParametersEditor.this.shell, Res.getString("editor.captionSelectTemplate"), false, null, Res.getString("editor.filterSelectTemplate"), "*.xsl;*.xslt\t*.*");
                if (paths == null) {
                    return;
                }
                UIUtil.checkProjectFolderAfterPick(paths[0], ParametersEditor.this.edXsltPath, ParametersEditor.this.projectDir);
            }
        });
        label = new Label(this.mainComposite, 0);
        label.setText(Res.getString("editor.stParameters"));
        int wideButtonWidth = Res.getInt("editor.wideButtonWidth");
        Button btGetDefaults = new Button(this.mainComposite, 8);
        btGetDefaults.setText(Res.getString("editor.btGetDefaults"));
        gdTmp = new GridData();
        btGetDefaults.setLayoutData(gdTmp);
        UIUtil.ensureWidth(btGetDefaults, wideButtonWidth);
        btGetDefaults.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.getParametersFromTemplate();
            }
        });
        Button btOpenFile = new Button(this.mainComposite, 8);
        btOpenFile.setText(Res.getString("editor.btOpenTemplate"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        btOpenFile.setLayoutData(gdTmp);
        UIUtil.ensureWidth(btOpenFile, wideButtonWidth);
        btOpenFile.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Program.launch(ParametersEditor.this.edXsltPath.getText());
            }
        });
        this.edParameters = new Text(this.mainComposite, 2562);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 70;
        gdTmp.horizontalSpan = 4;
        this.edParameters.setLayoutData(gdTmp);
        this.chkUseCustomTransformer = new Button(this.mainComposite, 32);
        this.chkUseCustomTransformer.setText(Res.getString("editor.useCustomTransformer"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 4;
        this.chkUseCustomTransformer.setLayoutData(gdTmp);
        this.chkUseCustomTransformer.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.edFactoryClass.setEnabled(ParametersEditor.this.chkUseCustomTransformer.getSelection());
                ParametersEditor.this.edFactoryClass.setText("net.sf.saxon.TransformerFactoryImpl");
                ParametersEditor.this.edXpathFactoryClass.setEnabled(ParametersEditor.this.chkUseCustomTransformer.getSelection());
                ParametersEditor.this.edXpathFactoryClass.setText("net.sf.saxon.xpath.XPathFactoryImpl");
            }
        });
        this.edFactoryClass = new Text(this.mainComposite, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.edFactoryClass.setLayoutData(gdTmp);
        this.edXpathFactoryClass = new Text(this.mainComposite, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.edXpathFactoryClass.setLayoutData(gdTmp);
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkUseCustomTransformer.setSelection(this.params.getUseCustomTransformer());
        this.edFactoryClass.setText(this.params.getFactoryClass());
        this.edXpathFactoryClass.setText(this.params.getXpathClass());
        this.edXsltPath.setText(this.params.getXsltPath());
        ConfigurationString tmp = new ConfigurationString(this.params.getParamList());
        this.edParameters.setText(tmp.toString());
        this.edFactoryClass.setEnabled(this.chkUseCustomTransformer.getSelection());
        this.edXpathFactoryClass.setEnabled(this.chkUseCustomTransformer.getSelection());
    }

    private boolean saveData() {
        if (this.edXsltPath.getText().length() == 0) {
            Dialogs.showError(this.shell, "You must specify a path for the XSLT file.", null);
            this.edXsltPath.setFocus();
            return false;
        }
        if (this.chkUseCustomTransformer.getSelection() && this.edFactoryClass.getText().length() == 0) {
            Dialogs.showError(this.shell, "You must specify a factory class.", null);
            this.edFactoryClass.setFocus();
            return false;
        }
        this.params.setUseCustomTransformer(this.chkUseCustomTransformer.getSelection());
        if (this.params.getUseCustomTransformer()) {
            this.params.setFactoryClass(this.edFactoryClass.getText());
            this.params.setXpathClass(this.edXpathFactoryClass.getText());
        }
        this.params.setXsltPath(this.edXsltPath.getText());
        ConfigurationString tmp = new ConfigurationString(this.edParameters.getText());
        this.params.setParamList(tmp.toString());
        this.result = true;
        return this.result;
    }

    private void getParametersFromTemplate() {
        try {
            String path = this.edXsltPath.getText();
            if (path.length() == 0) {
                return;
            }
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(path);
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext((NamespaceContext)new NSContextManager());
            XPathExpression expr = xpath.compile("//xsl:param");
            Object result = expr.evaluate(doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            ConfigurationString paramList = new ConfigurationString();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem = (Element)nodes.item(i);
                paramList.add(elem.getAttribute("name"), Util.getTextContent((Node)elem));
            }
            this.edParameters.setText(paramList.toString());
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }
}

