/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFFMergingStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFilter filter;
    private IFilterWriter writer;
    private IFilterConfigurationMapper fcMapper;
    private XLIFFFilter xlfReader;
    private String xliffPath;
    private String outputPath;
    private String outputEncoding;
    private LocaleId trgLoc;

    public XLIFFMergingStep(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getXliffPath() {
        return this.xliffPath;
    }

    public void setXliffPath(String xliffPath) {
        this.xliffPath = xliffPath;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRawDocument(RawDocument skelRawDoc) {
        try {
            this.trgLoc = skelRawDoc.getTargetLocale();
            this.xlfReader = new XLIFFFilter();
            File f = new File(this.xliffPath);
            RawDocument xlfRawDoc = new RawDocument(f.toURI(), "UTF-8", skelRawDoc.getSourceLocale(), this.trgLoc);
            this.xlfReader.open(xlfRawDoc);
            this.filter = this.fcMapper.createFilter(skelRawDoc.getFilterConfigId(), this.filter);
            if (this.filter == null) {
                throw new OkapiFilterCreationException(String.format("Cannot create the filter or load the configuration for '%s'", skelRawDoc.getFilterConfigId()));
            }
            this.filter.open(skelRawDoc);
            this.writer = this.filter.createFilterWriter();
            this.writer.setOptions(this.trgLoc, this.outputEncoding);
            this.writer.setOutput(this.outputPath);
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    this.processTextUnit(event.getTextUnit());
                }
                this.writer.handleEvent(event);
            }
        }
        finally {
            if (this.xlfReader != null) {
                this.xlfReader.close();
            }
            if (this.filter != null) {
                this.filter.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }

    private ITextUnit getTextUnitFromXLIFF() {
        while (this.xlfReader.hasNext()) {
            Event event = this.xlfReader.next();
            if (event.getEventType() != EventType.TEXT_UNIT) continue;
            return event.getTextUnit();
        }
        return null;
    }

    private void processTextUnit(ITextUnit tu) {
        TextContainer srcCont;
        ITextUnit tuFromTrans;
        if (!tu.isTranslatable()) {
            return;
        }
        do {
            if ((tuFromTrans = this.getTextUnitFromXLIFF()) != null) continue;
            this.logger.warn("There is no more items in the package to merge with id=\"{}\".", (Object)tu.getId());
            return;
        } while (!tu.getId().equals(tuFromTrans.getId()));
        if (!tuFromTrans.hasTarget(this.trgLoc) && !tu.getSource().isEmpty()) {
            this.logger.warn("Item id=\"{}\": No translation provided; using source instead.", (Object)tu.getId());
            return;
        }
        TextContainer fromTrans = tuFromTrans.getTarget(this.trgLoc);
        if (fromTrans == null) {
            if (tuFromTrans.getSource().isEmpty()) {
                return;
            }
            this.logger.warn("Item id='{}': No target in XLIFF; using source instead.", (Object)tu.getId());
            return;
        }
        boolean mergeAsSegments = false;
        if (tu.getMimeType() != null && (tu.getMimeType().equals("application/x-ttx+xml") || tu.getMimeType().equals("application/x-xliff+xml"))) {
            mergeAsSegments = true;
        }
        ArrayList<Range> trgRanges = null;
        List<Range> srcRanges = null;
        if (mergeAsSegments) {
            trgRanges = new ArrayList<Range>();
            srcRanges = tuFromTrans.getSourceSegments().getRanges();
        }
        if (!fromTrans.contentIsOneSegment()) {
            fromTrans.getSegments().joinAll(trgRanges);
        }
        if (!tu.getSource().contentIsOneSegment()) {
            srcCont = tu.getSource().clone();
            srcCont.getSegments().joinAll();
        } else {
            srcCont = tu.getSource();
        }
        List<Code> transCodes = this.transferCodes(fromTrans, srcCont, tu);
        TextContainer trgCont = tu.createTarget(this.trgLoc, false, 7);
        if (!trgCont.contentIsOneSegment()) {
            trgCont.getSegments().joinAll();
        }
        try {
            trgCont.getFirstContent().setCodedText(fromTrans.getCodedText(), transCodes, false);
            if (mergeAsSegments) {
                trgCont.getSegments().create(trgRanges);
                tu.getSource().getSegments().create(srcRanges);
            }
        }
        catch (RuntimeException e) {
            this.logger.error("Inline code error with item id=\"{}\".\n{}", (Object)e.getLocalizedMessage(), (Object)tu.getId());
            tu.setTarget(this.trgLoc, tu.getSource());
        }
    }

    private List<Code> transferCodes(TextContainer fromTrans, TextContainer srcCont, ITextUnit tu) {
        int i;
        List<Code> transCodes = fromTrans.getFirstContent().getCodes();
        List<Code> oriCodes = srcCont.getFirstContent().getCodes();
        if (transCodes.size() == 0 && oriCodes.size() == 0) {
            return transCodes;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i2 = 0; i2 < oriIndices.length; ++i2) {
            oriIndices[i2] = i2;
        }
        int done = 0;
        for (i = 0; i < transCodes.size(); ++i) {
            Code transCode = transCodes.get(i);
            transCode.setOuterData(null);
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriIndices[j] == -1 || oriCodes.get(oriIndices[j]).getId() != transCode.getId()) continue;
                oriCode = oriCodes.get(oriIndices[j]);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (transCode.hasData()) continue;
                this.logger.warn("The extra target code id='{}' does not have corresponding data (item id='{}', name='{}')", new Object[]{transCode.getId(), tu.getId(), tu.getName() == null ? "" : tu.getName()});
                continue;
            }
            if (oriCode.hasOuterData()) {
                transCode.setOuterData(oriCode.getOuterData());
            } else if (!transCode.hasData()) {
                transCode.setData(oriCode.getData());
            }
            transCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            for (i = 0; i < oriIndices.length; ++i) {
                Code code;
                if (oriIndices[i] == -1 || (code = oriCodes.get(oriIndices[i])).isDeleteable()) continue;
                this.logger.warn("The code id='{}' ({}) is missing in target (item id='{}', name='{}')", new Object[]{code.getId(), code.getData(), tu.getId(), tu.getName() == null ? "" : tu.getName()});
                this.logger.info("Source='{}'", (Object)tu.getSource().toString());
            }
        }
        return transCodes;
    }
}

