/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal.logger;

import java.io.PrintStream;
import net.sf.okapi.applications.tikal.logger.ILogHandler;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

class LogHandlerLog4j
extends AppenderSkeleton
implements ILogHandler {
    private PrintStream ps;

    protected LogHandlerLog4j() {
    }

    @Override
    public void initialize(PrintStream ps) {
        if (ps == null) {
            return;
        }
        this.ps = ps;
        this.setThreshold((Priority)Level.INFO);
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)this);
    }

    @Override
    public void setLogLevel(int level) {
        switch (level) {
            case 2: {
                this.setThreshold((Priority)Level.DEBUG);
                Logger.getRootLogger().setLevel(Level.DEBUG);
                break;
            }
            case 1: {
                this.setThreshold((Priority)Level.TRACE);
                Logger.getRootLogger().setLevel(Level.TRACE);
                break;
            }
            default: {
                this.setThreshold((Priority)Level.INFO);
                Logger.getRootLogger().setLevel(Level.INFO);
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent record) {
        if (this.ps == null) {
            return;
        }
        Level lev = record.getLevel();
        if (lev == Level.ERROR || lev == Level.FATAL) {
            this.ps.println("Error: " + record.getRenderedMessage());
            ThrowableInformation e = record.getThrowableInformation();
            if (e != null) {
                this.ps.println(" @ " + e.toString());
            }
        } else if (lev == Level.WARN) {
            if ("org.apache.axis.utils.JavaUtils".equals(record.getLoggerName())) {
                return;
            }
            this.ps.println("Warning: " + record.getRenderedMessage());
        } else if (lev == Level.INFO) {
            this.ps.println(record.getRenderedMessage());
        } else {
            this.ps.println("Trace: " + record.getRenderedMessage());
        }
    }
}

