/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff2.core.BaseMarker;
import net.sf.okapi.lib.xliff2.core.CMarker;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.IWithStore;
import net.sf.okapi.lib.xliff2.core.Markers;
import net.sf.okapi.lib.xliff2.core.TagType;

public class Store {
    private final IWithStore parent;
    private Markers srcMarkers;
    private Markers trgMarkers;
    private int lastSuggested;
    private int lastSegSuggested;
    private transient Map<String, String> map;

    public Store(IWithStore parent) {
        if (parent == null) {
            throw new InvalidParameterException("Parent parameter must not be null.");
        }
        this.parent = parent;
    }

    public boolean hasCodeWithOriginalData() {
        if (this.srcMarkers != null && this.srcMarkers.hasCodeWithOriginalData()) {
            return true;
        }
        return this.trgMarkers != null && this.trgMarkers.hasCodeWithOriginalData();
    }

    public boolean hasSourceMarker() {
        return this.srcMarkers != null && this.srcMarkers.size() > 0;
    }

    public boolean hasTargetMarker() {
        return this.trgMarkers != null && this.trgMarkers.size() > 0;
    }

    public Markers getSourceMarkers() {
        if (this.srcMarkers == null) {
            this.srcMarkers = new Markers(this);
        }
        return this.srcMarkers;
    }

    public Markers getTargetMarkers() {
        if (this.trgMarkers == null) {
            this.trgMarkers = new Markers(this);
        }
        return this.trgMarkers;
    }

    public void calculateOriginalDataToIdsMap() {
        CMarker code;
        String tmp;
        this.map = new LinkedHashMap<String, String>();
        int mapId = 0;
        if (this.srcMarkers != null) {
            for (BaseMarker bm : this.srcMarkers) {
                if (bm.isAnnotation() || (tmp = (code = (CMarker)bm).getOriginalData()) == null || tmp.isEmpty() || this.map.containsKey(tmp = tmp + code.getDataDir().getPrefix())) continue;
                this.map.put(tmp, "d" + String.valueOf(++mapId));
            }
        }
        if (this.trgMarkers != null) {
            for (BaseMarker bm : this.trgMarkers) {
                if (bm.isAnnotation() || (tmp = (code = (CMarker)bm).getOriginalData()) == null || tmp.isEmpty() || this.map.containsKey(tmp = tmp + code.getDataDir().getPrefix())) continue;
                this.map.put(tmp, "d" + String.valueOf(++mapId));
            }
        }
    }

    public void setOutsideRepresentationMap(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, String> getOutsideRepresentationMap() {
        return this.map;
    }

    public String getIdForOriginalData(CMarker code) {
        String key;
        if (this.map == null) {
            this.calculateOriginalDataToIdsMap();
        }
        if (!this.map.containsKey(key = (code.getOriginalData() == null ? "" : code.getOriginalData()) + code.getDataDir().getPrefix())) {
            this.calculateOriginalDataToIdsMap();
            if (!this.map.containsKey(key)) {
                throw new RuntimeException(String.format("No id found for the original data '%s'.", code.getOriginalData()));
            }
        }
        return this.map.get(key);
    }

    public BaseMarker getMarker(String id, TagType markerType) {
        if (this.srcMarkers != null) {
            for (BaseMarker marker : this.srcMarkers) {
                if (!id.equals(marker.getId()) || marker.getTagType() != markerType) continue;
                return marker;
            }
        }
        if (this.trgMarkers != null) {
            for (BaseMarker marker : this.trgMarkers) {
                if (!id.equals(marker.getId()) || marker.getTagType() != markerType) continue;
                return marker;
            }
        }
        return null;
    }

    public boolean isIdUsedInMarkers(String id) {
        return this.getMarker(id) != null;
    }

    public BaseMarker getMarker(String id) {
        if (this.srcMarkers != null) {
            for (BaseMarker marker : this.srcMarkers) {
                if (!id.equals(marker.getId())) continue;
                return marker;
            }
        }
        if (this.trgMarkers != null) {
            for (BaseMarker marker : this.trgMarkers) {
                if (!id.equals(marker.getId())) continue;
                return marker;
            }
        }
        return null;
    }

    public String suggestId(boolean forSegment) {
        String id;
        while (this.parent.isIdUsed(id = forSegment ? "s" + String.valueOf(++this.lastSegSuggested) : String.valueOf(++this.lastSuggested))) {
        }
        return id;
    }

    public Directionality getSourceDir() {
        return this.parent.getSourceDir();
    }

    public void setSourceDir(Directionality dir) {
        this.parent.setSourceDir(dir);
    }

    public Directionality getTargetDir() {
        return this.parent.getTargetDir();
    }

    public void setTargetDir(Directionality dir) {
        this.parent.setTargetDir(dir);
    }

    public IWithStore getParent() {
        return this.parent;
    }
}

