/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;

public class AnnotatorsRef {
    private Map<String, String> map = new LinkedHashMap<String, String>();

    public AnnotatorsRef() {
    }

    public AnnotatorsRef(AnnotatorsRef original) {
        if (original == null) {
            return;
        }
        this.map.putAll(original.map);
    }

    public void read(String data) {
        String[] list;
        for (String tmp : list = data.split(" ", 0)) {
            int n = tmp.indexOf(124);
            if (n == -1) {
                throw new InvalidParameterException(String.format("Invalid annotatorsRef value '%s'", tmp));
            }
            String ident = tmp.substring(0, n);
            Util.checkValueList(";translate;localization-note;terminology;directionality;language-information;elements-within-text;domain;text-analysis;locale-filter;provenance;external-resource;target-pointer;id-value;preserve-space;localization-quality-issue;localization-quality-rating;mt-confidence;allowed-characters;storage-size;", ident, "annotatorsRef");
            String value = tmp.substring(n + 1);
            try {
                new URI(value);
            }
            catch (URISyntaxException e) {
                throw new InvalidParameterException(String.format("Invalid IRI value '%s'", value));
            }
            this.map.put(ident, value);
        }
    }

    public void set(IITSItem item) {
        if (item.isGroup()) {
            return;
        }
        String value = item.getAnnotatorRef();
        if (value == null) {
            return;
        }
        String dc = item.getDataCategoryName();
        try {
            new URI(value);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException(String.format("Invalid IRI value '%s'", value));
        }
        this.map.put(dc, value);
    }

    public void set(String dc, String value) {
        if (value == null) {
            return;
        }
        this.map.put(dc, value);
    }

    public String printDifferences(AnnotatorsRef parentAR) {
        if (parentAR == null) {
            return this.print();
        }
        StringBuilder sb = new StringBuilder();
        for (String dc : this.map.keySet()) {
            String parentValue;
            String value = this.map.get(dc);
            if (value != null && (parentValue = parentAR.get(dc)) != null && value.equals(parentValue)) {
                value = null;
            }
            if (value == null) continue;
            sb.append(" " + dc + "|" + value);
        }
        if (sb.length() == 0) {
            return "";
        }
        return " its:annotatorsRef=\"" + sb.toString().trim() + "\"";
    }

    public static String printDCIfDifferent(String dcIdentifier, String value, AnnotatorsRef parentAR) {
        String parentValue;
        if (value == null) {
            return "";
        }
        if (parentAR != null && (parentValue = parentAR.get(dcIdentifier)).equals(value)) {
            return "";
        }
        return " its:annotatorsRef=\"" + dcIdentifier + "|" + value + "\"";
    }

    public static void update(AnnotatorsRef ar, IWithITSAttributes object) {
        if (ar == null) {
            return;
        }
        if (!object.hasITSItem()) {
            return;
        }
        for (IITSItem item : object.getITSItems()) {
            ar.set(item);
        }
    }

    public String print() {
        StringBuilder sb = new StringBuilder();
        for (String dc : this.map.keySet()) {
            String value = this.map.get(dc);
            if (value == null) continue;
            sb.append(" " + dc + "|" + value);
        }
        if (sb.length() == 0) {
            return "";
        }
        return " its:annotatorsRef=\"" + sb.toString().trim() + "\"";
    }

    public String get(String name) {
        return this.map.get(name);
    }

    protected void buildDCValue(StringBuilder out, String dc, String value) {
        if (value == null) {
            return;
        }
        String ccValue = this.map.get(dc);
        if (!value.equals(ccValue)) {
            out.append(" " + dc + "|" + value);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

