/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.AMarker;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSItems;

public class TermMarker
extends AMarker {
    public static final String TYPE_TERM = "term";
    public static final String TYPE_ITSTERMNO = "its:term-no";
    private String annotatorRef;
    private Double termConfidence;

    public TermMarker(TermMarker original) {
        super(original);
        this.annotatorRef = original.annotatorRef;
        this.termConfidence = original.termConfidence;
    }

    public TermMarker(String id, boolean opening) {
        super(id, opening, TYPE_TERM);
    }

    public TermMarker(AMarker marker, String type, AnnotatorsRef ar) {
        super(marker.getId(), marker.getTagType() == TagType.OPENING, type);
        this.setRef(marker.getRef());
        this.setValue(marker.getValue());
        this.setTranslate(marker.getTranslate());
        this.setAnnotatorRef(ar);
        if (marker.hasExtAttribute()) {
            this.setExtAttributes(marker.getExtAttributes());
        }
    }

    public String getDataCategoryName() {
        return "terminology";
    }

    public void validate() {
        if (this.termConfidence != null && this.getAnnotatorRef() == null) {
            throw new RuntimeException("An annotator reference must be defined when termConfidence is defined.");
        }
    }

    @Override
    public void setType(String type) {
        if (type == null) {
            this.type = TYPE_TERM;
        } else {
            if (!type.equals(TYPE_TERM) && !type.equals(TYPE_ITSTERMNO)) {
                throw new InvalidParameterException("Type must be 'term' or 'its:term-no'");
            }
            this.type = type;
        }
    }

    public boolean isTerm() {
        return this.type.equals(TYPE_TERM);
    }

    public void setTerm(boolean term) {
        this.type = term ? TYPE_TERM : TYPE_ITSTERMNO;
    }

    public Double getTermConfidence() {
        return this.termConfidence;
    }

    public void setTermConfidence(Double termConfidence) {
        if (termConfidence != null && (termConfidence < 0.0 || termConfidence > 1.0)) {
            throw new InvalidParameterException(String.format("The termConfidence value '%f' is out of the [0.0 to 1.0] range.", termConfidence));
        }
        this.termConfidence = termConfidence;
    }

    @Override
    public boolean hasITSItem() {
        return false;
    }

    @Override
    public ITSItems getITSItems() {
        return null;
    }

    @Override
    public void setITSItems(ITSItems itsItems) {
        throw new UnsupportedOperationException("Only the Terminology data category can be used on a term annotation.");
    }

    public void setAnnotatorRef(String annotatorRef) {
        this.annotatorRef = annotatorRef;
    }

    public void setAnnotatorRef(AnnotatorsRef ar) {
        if (ar == null) {
            return;
        }
        String ref = ar.get(this.getDataCategoryName());
        if (ref != null) {
            this.annotatorRef = ref;
        }
    }

    public String getAnnotatorRef() {
        return this.annotatorRef;
    }

    public String getTermInfo() {
        return this.getValue();
    }

    public void setTermInfo(String termInfo) {
        this.setValue(termInfo);
        this.setRef(null);
    }

    public String getTermInfoRef() {
        return this.getRef();
    }

    public void setTermInfoRef(String termInfoRef) {
        this.setRef(termInfoRef);
        this.setValue(null);
    }
}

