/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.batchconfig;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.pipeline.PipelineStorage;
import net.sf.okapi.applications.rainbow.pipeline.PipelineWrapper;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.plugins.PluginsManager;

public class BatchConfiguration {
    private static final int MAXBUFFERSIZE = 8192;
    private static final int MAXBLOCKLEN = 65000;
    private static final String SIGNATURE = "batchConf";
    private static final int VERSION = 2;

    public void exportConfiguration(String configPath, PipelineWrapper pipelineWrapper, IFilterConfigurationMapper fcMapper, List<Input> inputFiles) {
        FilterOutputStream dos = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(configPath));
            ((DataOutputStream)dos).writeUTF(SIGNATURE);
            ((DataOutputStream)dos).writeInt(2);
            PluginsManager pm = pipelineWrapper.getPluginsManager();
            int numPlugins = pm.getURLs() == null ? 0 : pm.getURLs().size();
            ((DataOutputStream)dos).writeInt(numPlugins);
            if (numPlugins > 0) {
                for (URL url : pm.getURLs()) {
                    String path = URLDecoder.decode(url.getPath(), "UTF-8");
                    String jarPath = new File(path).getPath();
                    String root = Util.longestCommonDir(true, pm.getPluginsDir().getPath(), jarPath);
                    String relPath = "";
                    relPath = !Util.isEmpty(root) ? jarPath.substring(root.length()) : Util.getFilename(jarPath, true);
                    ((DataOutputStream)dos).writeUTF(relPath);
                    this.harvestReferencedFile((DataOutputStream)dos, 0, jarPath);
                }
            }
            IPipeline pipeline = pipelineWrapper.getPipeline();
            for (IPipelineStep step : pipeline.getSteps()) {
                IParameters params = step.getParameters();
                if (params == null) continue;
                Method[] methods = params.getClass().getMethods();
                int id = 0;
                for (Method m : methods) {
                    if (!Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(ReferenceParameter.class)) continue;
                    String refPath = (String)m.invoke((Object)params, new Object[0]);
                    this.harvestReferencedFile((DataOutputStream)dos, ++id, refPath);
                }
            }
            ((DataOutputStream)dos).writeInt(-1);
            PipelineStorage store = new PipelineStorage(null);
            store.write(pipeline);
            this.writeLongString((DataOutputStream)dos, store.getStringOutput());
            Iterator<FilterConfiguration> iter = fcMapper.getAllConfigurations();
            int count = 0;
            while (iter.hasNext()) {
                if (!iter.next().custom) continue;
                ++count;
            }
            ((DataOutputStream)dos).writeInt(count);
            iter = fcMapper.getAllConfigurations();
            while (iter.hasNext()) {
                FilterConfiguration fc = iter.next();
                if (!fc.custom) continue;
                ((DataOutputStream)dos).writeUTF(fc.configId);
                IParameters params = fcMapper.getCustomParameters(fc);
                ((DataOutputStream)dos).writeUTF(params.toString());
            }
            if (inputFiles != null) {
                HashMap<String, String> extMap = new HashMap<String, String>();
                for (Input input : inputFiles) {
                    String ext = Util.getExtension(input.relativePath);
                    if (extMap.containsKey(ext) || Util.isEmpty(input.filterConfigId)) continue;
                    extMap.put(ext, input.filterConfigId);
                }
                iter = fcMapper.getAllConfigurations();
                while (iter.hasNext()) {
                    FilterConfiguration fc = iter.next();
                    String ext = fc.extensions;
                    if (Util.isEmpty(ext)) continue;
                    int n = ext.indexOf(59);
                    if (n > 0) {
                        ext = ext.substring(0, n);
                    }
                    if (extMap.containsKey(ext)) continue;
                    extMap.put(ext, fc.configId);
                }
                ((DataOutputStream)dos).writeInt(extMap.size());
                for (String ext : extMap.keySet()) {
                    ((DataOutputStream)dos).writeUTF(ext);
                    ((DataOutputStream)dos).writeUTF((String)extMap.get(ext));
                }
            } else {
                ((DataOutputStream)dos).writeInt(0);
            }
        }
        catch (IllegalArgumentException e) {
            throw new OkapiIOException("Error when calling getter method.", e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiIOException("Error when calling getter method.", e);
        }
        catch (InvocationTargetException e) {
            throw new OkapiIOException("Error when calling getter method.", e);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createReferencedFile(RandomAccessFile raf, long size, String path) throws IOException {
        if (raf == null) {
            return false;
        }
        if (Util.isEmpty(path)) {
            return false;
        }
        byte[] buffer = new byte[8192];
        Util.createDirectories(path);
        try (FileOutputStream fos = new FileOutputStream(path);){
            int toRead = (int)Math.min(size, 8192L);
            int bytesRead = raf.read(buffer, 0, toRead);
            while (bytesRead > 0) {
                fos.write(buffer, 0, bytesRead);
                if ((size -= (long)bytesRead) <= 0L) {
                    break;
                }
                toRead = (int)Math.min(size, 8192L);
                bytesRead = raf.read(buffer, 0, toRead);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installConfiguration(String configPath, String outputDir, PipelineWrapper pipelineWrapper) {
        RandomAccessFile raf = null;
        PrintWriter pw = null;
        try {
            long size;
            raf = new RandomAccessFile(configPath, "r");
            String tmp = raf.readUTF();
            if (!SIGNATURE.equals(tmp)) {
                throw new OkapiIOException("Invalid file format.");
            }
            int version = raf.readInt();
            if (version < 1 || version > 2) {
                throw new OkapiIOException("Invalid version.");
            }
            Util.createDirectories(outputDir + File.separator);
            if (version > 1) {
                String pluginsDir = outputDir;
                int numPlugins = raf.readInt();
                for (int i = 0; i < numPlugins; ++i) {
                    String relPath = raf.readUTF();
                    raf.readInt();
                    raf.readUTF();
                    size = raf.readLong();
                    String path = Util.fixPath(outputDir + relPath);
                    this.createReferencedFile(raf, size, path);
                }
                PluginsManager pm = new PluginsManager();
                try {
                    pm.discover(new File(pluginsDir), true);
                    pipelineWrapper.addFromPlugins(pm);
                }
                finally {
                    pm.releaseClassLoader();
                }
            }
            HashMap<Integer, Long> refMap = new HashMap<Integer, Long>();
            int id = raf.readInt();
            long pos = raf.getFilePointer();
            while (id != -1) {
                raf.readUTF();
                refMap.put(id, pos);
                size = raf.readLong();
                if (size > 0L) {
                    raf.seek(raf.getFilePointer() + size);
                }
                id = raf.readInt();
                pos = raf.getFilePointer();
            }
            tmp = this.readLongString(raf);
            long startFilterConfigs = raf.getFilePointer();
            PipelineStorage store = new PipelineStorage(pipelineWrapper.getAvailableSteps(), (CharSequence)tmp);
            IPipeline pipeline = store.read();
            for (IPipelineStep step : pipeline.getSteps()) {
                IParameters params = step.getParameters();
                if (params == null) continue;
                Method[] methods = params.getClass().getMethods();
                id = 0;
                for (Method m : methods) {
                    if (!Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(ReferenceParameter.class)) continue;
                    pos = (Long)refMap.get(++id);
                    raf.seek(pos);
                    String filename = raf.readUTF();
                    long size2 = raf.readLong();
                    String path = outputDir + File.separator + filename;
                    if (Util.isEmpty(filename) || !this.createReferencedFile(raf, size2, path)) continue;
                    String setMethodName = "set" + m.getName().substring(3);
                    Method setMethod = params.getClass().getMethod(setMethodName, String.class);
                    setMethod.invoke((Object)params, path);
                }
            }
            String path = outputDir + File.separator + "pipeline.pln";
            pw = new PrintWriter(path, "UTF-8");
            store.write(pipeline);
            pw.write(store.getStringOutput());
            pw.close();
            raf.seek(startFilterConfigs);
            int count = raf.readInt();
            for (int i = 0; i < count; ++i) {
                String configId = raf.readUTF();
                String data = raf.readUTF();
                path = outputDir + File.separator + configId + ".fprm";
                pw = new PrintWriter(path, "UTF-8");
                pw.write(data);
                pw.close();
            }
            path = outputDir + File.separator + "extensions-mapping.txt";
            pw = new PrintWriter(path, "UTF-8");
            String lb = System.getProperty("line.separator");
            count = raf.readInt();
            for (int i = 0; i < count; ++i) {
                String ext = raf.readUTF();
                String configId = raf.readUTF();
                pw.write(ext + "\t" + configId + lb);
            }
            pw.close();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error when installing the batch configuration.\n" + e.getMessage(), e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void harvestReferencedFile(DataOutputStream dos, int id, String refPath) throws IOException {
        try (FileInputStream fis = null;){
            dos.writeInt(id);
            String filename = Util.getFilename(refPath, true);
            dos.writeUTF(filename);
            if (Util.isEmpty(refPath)) {
                dos.writeLong(0L);
                return;
            }
            File file = new File(refPath);
            long size = file.length();
            dos.writeLong(size);
            if (size > 0L) {
                fis = new FileInputStream(refPath);
                int bufferSize = Math.min(fis.available(), 8192);
                byte[] buffer = new byte[bufferSize];
                int bytesRead = fis.read(buffer, 0, bufferSize);
                while (bytesRead > 0) {
                    dos.write(buffer, 0, bufferSize);
                    bufferSize = Math.min(fis.available(), 8192);
                    bytesRead = fis.read(buffer, 0, bufferSize);
                }
            }
        }
    }

    private void writeLongString(DataOutputStream dos, String data) throws IOException {
        int r = data.length() % 65000;
        int n = data.length() / 65000;
        int count = n + (r > 0 ? 1 : 0);
        dos.writeInt(count);
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            dos.writeUTF(data.substring(pos, pos + 65000));
            pos += 65000;
        }
        if (r > 0) {
            dos.writeUTF(data.substring(pos));
        }
    }

    private String readLongString(RandomAccessFile raf) throws IOException {
        StringBuilder tmp = new StringBuilder();
        int count = raf.readInt();
        for (int i = 0; i < count; ++i) {
            tmp.append(raf.readUTF());
        }
        return tmp.toString();
    }
}

