/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import java.security.InvalidParameterException;
import java.util.Hashtable;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncoderManager
implements IEncoder {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Hashtable<String, String> mimeMap = new Hashtable();
    private Hashtable<String, IEncoder> encoders = new Hashtable();
    private String mimeType = "";
    private IEncoder encoder;
    private String defEncoding;
    private String defLineBreak;
    private IParameters defParams;

    public void setAllKnownMappings() {
        this.mimeMap.put("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("application/x-xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("text/x-odf", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("text/x-properties", "net.sf.okapi.common.encoder.PropertiesEncoder");
        this.mimeMap.put("text/html", "net.sf.okapi.common.encoder.HtmlEncoder");
        this.mimeMap.put("text/xhtml", "net.sf.okapi.common.encoder.HtmlEncoder");
        this.mimeMap.put("application/x-gettext", "net.sf.okapi.common.encoder.POEncoder");
        this.mimeMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.mimeMap.put("application/xml+dtd", "net.sf.okapi.common.encoder.DTDEncoder");
        this.mimeMap.put("application/x-ts", "net.sf.okapi.common.encoder.TSEncoder");
        this.mimeMap.put("application/x-php", "net.sf.okapi.common.encoder.PHPContentEncoder");
        this.mimeMap.put("application/x-ttx+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("application/json", "net.sf.okapi.common.encoder.JSONEncoder");
    }

    public void clearMap() {
        this.mimeMap.clear();
        this.encoders.clear();
    }

    public void setMapping(String mimeType, String className) {
        if (this.mimeType.equals(mimeType)) {
            this.mimeType = "";
        }
        this.mimeMap.put(mimeType, className);
        IEncoder encoder = this.encoders.get(mimeType);
        if (encoder != null && !className.equals(encoder.getClass().getName())) {
            this.encoders.remove(mimeType);
        }
    }

    public void setMapping(String mimeType, IEncoder encoder) {
        if (encoder == null) {
            throw new InvalidParameterException("encoder cannot be null");
        }
        if (this.mimeType.equals(mimeType)) {
            this.mimeType = "";
        }
        this.mimeMap.put(mimeType, encoder.getClass().getName());
        this.encoders.put(mimeType, encoder);
    }

    public void removeMapping(String mimeType) {
        this.mimeMap.remove(mimeType);
        this.encoders.remove(mimeType);
    }

    public void mergeMappings(EncoderManager otherManager) {
        for (Map.Entry<String, String> entry : otherManager.mimeMap.entrySet()) {
            if (this.mimeMap.containsKey(entry.getKey())) {
                if (this.mimeMap.get(entry.getKey()).equals(entry.getValue())) continue;
                this.LOGGER.warn(String.format("The MIME type '%s' is currently mapped to '%s', but conflicts with another mapping ('%s').", entry.getKey(), this.mimeMap.get(entry.getKey()), entry.getValue()));
                continue;
            }
            this.setMapping(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : otherManager.encoders.entrySet()) {
            if (this.encoders.containsKey(entry.getKey())) {
                if (this.encoders.get(entry.getKey()).equals(entry.getValue())) continue;
                this.LOGGER.warn(String.format("The MIME type '%s' is currently mapped to '%s', but conflicts with another mapping ('%s').", entry.getKey(), this.mimeMap.get(entry.getKey().getClass().getName()), ((IEncoder)entry.getValue()).getClass().getName()));
                continue;
            }
            this.setMapping(entry.getKey(), (IEncoder)entry.getValue());
        }
    }

    public void updateEncoder(String newMimeType) {
        try {
            if (newMimeType == null) {
                return;
            }
            if (this.mimeType.equals(newMimeType)) {
                return;
            }
            this.mimeType = newMimeType;
            String name = this.mimeMap.get(this.mimeType);
            if (name == null) {
                this.encoder = new DefaultEncoder();
            } else if (this.encoders.containsKey(this.mimeType)) {
                this.encoder = this.encoders.get(this.mimeType);
            } else {
                this.encoder = (IEncoder)Class.forName(name).newInstance();
                this.encoders.put(this.mimeType, this.encoder);
            }
            this.encoder.setOptions(this.defParams, this.defEncoding, this.defLineBreak);
        }
        catch (InstantiationException e) {
            throw new OkapiException(e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OkapiException(e);
        }
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (this.encoder != null) {
            return this.encoder.encode(text, context);
        }
        return text;
    }

    @Override
    public String encode(char value, EncoderContext context) {
        if (this.encoder != null) {
            return this.encoder.encode(value, context);
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int codePoint, EncoderContext context) {
        if (this.encoder != null) {
            return this.encoder.encode(codePoint, context);
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return new String(Character.toChars(codePoint));
        }
        return String.valueOf((char)codePoint);
    }

    public IEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        if (this.encoder != null) {
            this.encoder.setOptions(params, encoding, lineBreak);
        }
    }

    @Override
    public String toNative(String propertyName, String value) {
        if (this.encoder != null) {
            return this.encoder.toNative(propertyName, value);
        }
        return value;
    }

    public void setDefaultOptions(IParameters params, String encoding, String lineBreak) {
        this.defParams = params;
        this.defEncoding = encoding;
        if (lineBreak == null) {
            throw new InvalidParameterException("lineBreak parameter is null");
        }
        this.defLineBreak = lineBreak;
    }

    @Override
    public String getLineBreak() {
        if (this.encoder != null) {
            return this.encoder.getLineBreak();
        }
        return this.defLineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        if (this.encoder != null) {
            return this.encoder.getCharsetEncoder();
        }
        return null;
    }

    public final Hashtable<String, String> getMimeMap() {
        return this.mimeMap;
    }

    public final Hashtable<String, IEncoder> getEncoders() {
        return this.encoders;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    @Override
    public final String getEncoding() {
        return this.defEncoding;
    }

    public final String getDefLineBreak() {
        return this.defLineBreak;
    }

    @Override
    public IParameters getParameters() {
        return this.defParams;
    }

    protected String getDefEncoding() {
        return this.defEncoding;
    }

    protected void setDefEncoding(String defEncoding) {
        this.defEncoding = defEncoding;
    }

    protected IParameters getDefParams() {
        return this.defParams;
    }

    protected void setDefParams(IParameters defParams) {
        this.defParams = defParams;
    }

    protected void setMimeMap(Hashtable<String, String> mimeMap) {
        this.mimeMap = mimeMap;
    }

    protected void setEncoders(Hashtable<String, IEncoder> encoders) {
        this.encoders = encoders;
    }

    protected void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    protected void setEncoder(IEncoder encoder) {
        this.encoder = encoder;
    }

    protected void setDefLineBreak(String defLineBreak) {
        this.defLineBreak = defLineBreak;
    }
}

