/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;

public class XLIFFWriterParameters
extends StringParameters {
    private static final String USESOURCEFORTRANSLATED = "useSourceForTranslated";
    private static final String ESCAPEGT = "escapeGt";
    private static final String PLACEHOLDERMODE = "placeholderMode";
    private static final String INCLUDENOTRANSLATE = "includeNoTranslate";
    private static final String SETAPPROVEDASNOTRANSLATE = "setApprovedAsNoTranslate";
    private static final String COPYSOURCE = "copySource";
    private static final String INCLUDEALTTRANS = "includeAltTrans";
    private static final String INCLUDECODEATTRS = "includeCodeAttrs";
    private static final String INCLUDEITS = "includeIts";

    public boolean getUseSourceForTranslated() {
        return this.getBoolean(USESOURCEFORTRANSLATED);
    }

    public void setUseSourceForTranslated(boolean useSourceForTranslated) {
        this.setBoolean(USESOURCEFORTRANSLATED, useSourceForTranslated);
    }

    public boolean getEscapeGt() {
        return this.getBoolean(ESCAPEGT);
    }

    public void setEscapeGt(boolean escapeGt) {
        this.setBoolean(ESCAPEGT, escapeGt);
    }

    public boolean getPlaceholderMode() {
        return this.getBoolean(PLACEHOLDERMODE);
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.setBoolean(PLACEHOLDERMODE, placeholderMode);
    }

    public boolean getIncludeNoTranslate() {
        return this.getBoolean(INCLUDENOTRANSLATE);
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.setBoolean(INCLUDENOTRANSLATE, includeNoTranslate);
    }

    public boolean getSetApprovedAsNoTranslate() {
        return this.getBoolean(SETAPPROVEDASNOTRANSLATE);
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setBoolean(SETAPPROVEDASNOTRANSLATE, setApprovedAsNoTranslate);
    }

    public boolean getCopySource() {
        return this.getBoolean(COPYSOURCE);
    }

    public void setCopySource(boolean copySource) {
        this.setBoolean(COPYSOURCE, copySource);
    }

    public boolean getIncludeAltTrans() {
        return this.getBoolean(INCLUDEALTTRANS);
    }

    public void setIncludeAltTrans(boolean includeAltTrans) {
        this.setBoolean(INCLUDEALTTRANS, includeAltTrans);
    }

    public boolean getIncludeCodeAttrs() {
        return this.getBoolean(INCLUDECODEATTRS);
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.setBoolean(INCLUDECODEATTRS, includeCodeAttrs);
    }

    public boolean getIncludeIts() {
        return this.getBoolean(INCLUDEITS);
    }

    public void setIncludeIts(boolean includeIts) {
        this.setBoolean(INCLUDEITS, includeIts);
    }

    @Override
    public void reset() {
        super.reset();
        this.setUseSourceForTranslated(false);
        this.setEscapeGt(false);
        this.setPlaceholderMode(true);
        this.setIncludeNoTranslate(true);
        this.setSetApprovedAsNoTranslate(false);
        this.setCopySource(true);
        this.setIncludeAltTrans(true);
        this.setIncludeCodeAttrs(false);
        this.setIncludeIts(true);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(USESOURCEFORTRANSLATED, "Use the source text in the target, even if a target is available", null);
        desc.add(ESCAPEGT, "Escape the greater-than characters as &gt;", null);
        desc.add(PLACEHOLDERMODE, "Inline code should use the place-holder notation (g and x elements)", null);
        desc.add(INCLUDENOTRANSLATE, "Output non-translatable text units", null);
        desc.add(SETAPPROVEDASNOTRANSLATE, "Mark as not translatable all entries that are approved", null);
        desc.add(COPYSOURCE, "Copy the source as target if there is no target defined", null);
        desc.add(INCLUDEALTTRANS, "Output alt-trans elements", null);
        desc.add(INCLUDECODEATTRS, "Output extended code attributes", null);
        desc.add(INCLUDEITS, "Output ITS markup", null);
        return desc;
    }
}

