/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Iterator;
import java.util.TreeSet;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeAnomalies;
import net.sf.okapi.common.resource.CodeComparatorOnData;
import net.sf.okapi.common.resource.TextFragment;

public final class TextFragmentUtil {
    public static CodeAnomalies catalogCodeAnomalies(TextFragment source, TextFragment target) {
        return TextFragmentUtil.catalogCodeAnomalies(source, target, true);
    }

    public static CodeAnomalies catalogCodeAnomalies(TextFragment source, TextFragment target, boolean includeDeletable) {
        Iterator<Code> i$;
        CodeAnomalies anomalies = new CodeAnomalies();
        if (source == null && target == null) {
            return null;
        }
        if (source == null) {
            if (!target.hasCode()) {
                return null;
            }
            i$ = target.getCodes().iterator();
            if (i$.hasNext()) {
                Code c = i$.next();
                anomalies.addAddedCode(c);
                return anomalies;
            }
        }
        if (target == null) {
            if (!source.hasCode()) {
                return null;
            }
            i$ = source.getCodes().iterator();
            if (i$.hasNext()) {
                Code c = i$.next();
                anomalies.addMissingCode(c);
                return anomalies;
            }
        }
        TreeSet<Code> sourceCodeSet = new TreeSet<Code>(new CodeComparatorOnData());
        TreeSet<Code> targetCodeSet = new TreeSet<Code>(new CodeComparatorOnData());
        if (source != null) {
            sourceCodeSet.addAll(source.getCodes());
        }
        if (target != null) {
            targetCodeSet.addAll(target.getCodes());
        }
        targetCodeSet.removeAll(sourceCodeSet);
        for (Code c : targetCodeSet) {
            if (c.isDeleteable() && !includeDeletable) continue;
            anomalies.addAddedCode(c);
        }
        if (target != null) {
            targetCodeSet.addAll(target.getCodes());
        }
        sourceCodeSet.removeAll(targetCodeSet);
        for (Code c : sourceCodeSet) {
            if (c.isDeleteable() && !includeDeletable) continue;
            anomalies.addMissingCode(c);
        }
        if (anomalies.hasAddedCodes() || anomalies.hasMissingCodes()) {
            return anomalies;
        }
        return null;
    }
}

