/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class ApacheHttpClientForMT {
    private static final boolean USEHTTPCLIENT = true;

    public static String getAzureAccessToken(String sUral, String sClientID, String sEcret) {
        return ApacheHttpClientForMT.getExpensiveAzureAccessToken(sUral, sClientID, sEcret);
    }

    public static String getExpensiveAzureAccessToken(String sUral, String sClientID, String sEcret) {
        String sResult = null;
        DefaultHttpClient client = null;
        try {
            client = new DefaultHttpClient();
            HttpPost post = new HttpPost(sUral);
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(4);
            nameValuePairs.add(new BasicNameValuePair("grant_type", "client_credentials"));
            nameValuePairs.add(new BasicNameValuePair("client_id", sClientID));
            nameValuePairs.add(new BasicNameValuePair("client_secret", sEcret));
            nameValuePairs.add(new BasicNameValuePair("scope", "http://api.microsofttranslator.com"));
            UrlEncodedFormEntity uefe = new UrlEncodedFormEntity((List<? extends NameValuePair>)nameValuePairs);
            sResult = ApacheHttpClientForMT.fromInputStreamToString(uefe.getContent(), "UTF-8");
            sResult = "";
            post.setEntity(uefe);
            HttpResponse response = client.execute(post);
            if (response != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String line = "";
                while ((line = rd.readLine()) != null) {
                    sResult = sResult + line;
                }
            }
        }
        catch (Exception e) {
            int i = 1;
            ++i;
        }
        return sResult;
    }

    public static String getCheapAzureAccessToken(String sUral, String sClientID, String sEcret) {
        String sResult = null;
        try {
            String sContent = String.format("grant_type=client_credentials&client_id=%s&client_secret=%s&scope=%s", sClientID, URLEncoder.encode(sEcret, "UTF-8"), "http://api.microsofttranslator.com");
            URL url = new URL(sUral);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStreamWriter osw = null;
            osw = new OutputStreamWriter(conn.getOutputStream());
            osw.write(sContent);
            int code = conn.getResponseCode();
            if (code == 200) {
                sResult = ApacheHttpClientForMT.fromInputStreamToString(conn.getInputStream(), "UTF-8");
            }
        }
        catch (MalformedURLException e) {
            return sResult;
        }
        catch (UnsupportedEncodingException e) {
            return sResult;
        }
        catch (IOException e) {
            return sResult;
        }
        return sResult;
    }

    private static String fromInputStreamToString(InputStream stream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }
}

