/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final String DOMAINVAR = "${domain}";
    private static final String CLIENTID = "clientId";
    private static final String SECRET = "secret";
    private static final String CATEGORY = "category";

    public String getClientId() {
        return this.getString(CLIENTID);
    }

    public void setClientId(String clientId) {
        this.setString(CLIENTID, clientId);
    }

    public String getSecret() {
        return this.getString(SECRET);
    }

    public void setSecret(String secret) {
        this.setString(SECRET, secret);
    }

    public String getCategory() {
        return this.getString(CATEGORY);
    }

    public void setCategory(String category) {
        this.setString(CATEGORY, category == null ? "" : category);
    }

    @Override
    public void reset() {
        super.reset();
        this.setClientId("");
        this.setSecret("");
        this.setCategory("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CLIENTID, "Client ID (See http://msdn.microsoft.com/en-us/library/hh454950.aspx)", "The ClientID to identify the user");
        desc.add(SECRET, "Secret (See http://msdn.microsoft.com/en-us/library/hh454950.aspx)", "A code obtained from Microsoft Azure");
        desc.add(CATEGORY, "Category (See http://hub.microsofttranslator.com", "A category code for an MT system trained by user data, if any");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft MT Connector Settings", true, false);
        desc.addTextInputPart(paramsDesc.get(CLIENTID));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(SECRET));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        return desc;
    }
}

