/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.filters.doxygen.DoxygenParameter;

public class ParameterExtractor {
    private DoxygenParameter paramData;
    private String param = "";
    private String remainder = "";
    private String frontWhitespace = "";
    private boolean hasParameter = false;
    private static final String NEXT_WORD = "^[^\\s\\[\\(]*[^\\s.,|/\\[\\]\\(\\)\\{\\}]+(?:\\([^\\s\\)]*\\))?";
    private static final Pattern NEXT_WORD_PATTERN = Pattern.compile("^[^\\s\\[\\(]*[^\\s.,|/\\[\\]\\(\\)\\{\\}]+(?:\\([^\\s\\)]*\\))?");
    private static final String NEXT_LINE = "^.*?(?:\\r?\\n|\\z)";
    private static final Pattern NEXT_LINE_PATTERN = Pattern.compile("^.*?(?:\\r?\\n|\\z)");
    private static final String NEXT_PHRASE = "\"[^\"]*\"";
    private static final Pattern NEXT_PHRASE_PATTERN = Pattern.compile("\"[^\"]*\"");
    private static final String NEXT_PARAGRAPH = "^.*?(?=(?:\\s*?\\n\\s*){2,}|\\z)";
    private static final Pattern NEXT_PARAGRAPH_PATTERN = Pattern.compile("^.*?(?=(?:\\s*?\\n\\s*){2,}|\\z)", 32);
    private static final String FRONT_WHITESPACE = "^\\s*";
    public static final Pattern FRONT_WHITESPACE_PATTERN = Pattern.compile("^\\s*");

    public ParameterExtractor(DoxygenParameter paramData, String text) {
        this.paramData = paramData;
        this.extract(text);
    }

    private void extract(String text) {
        Matcher m = FRONT_WHITESPACE_PATTERN.matcher(text);
        m.find();
        this.frontWhitespace = m.group();
        String body = text.substring(m.end());
        if (this.frontWhitespace.contains("\n") && !this.paramData.isRequired()) {
            this.remainder = body;
            return;
        }
        switch (this.paramData.length()) {
            case WORD: {
                m = NEXT_WORD_PATTERN.matcher(body);
                break;
            }
            case LINE: {
                m = NEXT_LINE_PATTERN.matcher(body);
                break;
            }
            case PHRASE: {
                m = NEXT_PHRASE_PATTERN.matcher(body);
                break;
            }
            case PARAGRAPH: {
                m = NEXT_PARAGRAPH_PATTERN.matcher(body);
            }
        }
        if (!m.find()) {
            this.remainder = text;
            return;
        }
        this.hasParameter = true;
        this.param = this.frontWhitespace + m.group();
        this.remainder = body.substring(m.end());
    }

    public String parameter() {
        return this.param;
    }

    public String remainder() {
        return this.remainder;
    }

    public boolean hasParameter() {
        return this.hasParameter;
    }

    public String frontWhitespace() {
        return this.frontWhitespace;
    }
}

