/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String EXTRACTNOTES = "extractNotes";
    private static final String SIMPLIFYCODES = "simplifyCodes";
    private static final String EXTRACTMASTERSPREADS = "extractMasterSpreads";
    private static final String SKIPTHRESHOLD = "skipThreshold";
    private static final String STOPWHENOVERTHRESHOLD = "stopWhenOverThreshold";
    private static final String NEWTUONBR = "newTuOnBr";
    private static final String EXTRACTHIDDENLAYERS = "extractHiddenLayers";

    @Override
    public void reset() {
        super.reset();
        this.setExtractNotes(false);
        this.setSimplifyCodes(true);
        this.setExtractMasterSpreads(true);
        this.setSkipThreshold(2000);
        this.setStopWhenOverThreshold(true);
        this.setNewTuOnBr(false);
        this.setExtractHiddenLayers(false);
    }

    public boolean getExtractNotes() {
        return this.getBoolean(EXTRACTNOTES);
    }

    public void setExtractNotes(boolean extractNotes) {
        this.setBoolean(EXTRACTNOTES, extractNotes);
    }

    public boolean getSimplifyCodes() {
        return this.getBoolean(SIMPLIFYCODES);
    }

    public void setSimplifyCodes(boolean simplifyCodes) {
        this.setBoolean(SIMPLIFYCODES, simplifyCodes);
    }

    public boolean getExtractMasterSpreads() {
        return this.getBoolean(EXTRACTMASTERSPREADS);
    }

    public void setExtractMasterSpreads(boolean extractMasterSpreads) {
        this.setBoolean(EXTRACTMASTERSPREADS, extractMasterSpreads);
    }

    public int getSkipThreshold() {
        return this.getInteger(SKIPTHRESHOLD);
    }

    public void setSkipThreshold(int skipThreshold) {
        this.setInteger(SKIPTHRESHOLD, skipThreshold);
    }

    public boolean getStopWhenOverThreshold() {
        return this.getBoolean(STOPWHENOVERTHRESHOLD);
    }

    public void setStopWhenOverThreshold(boolean stopWhenOverThreshold) {
        this.setBoolean(STOPWHENOVERTHRESHOLD, stopWhenOverThreshold);
    }

    public boolean getNewTuOnBr() {
        return this.getBoolean(NEWTUONBR);
    }

    public void setNewTuOnBr(boolean newTuOnBr) {
        this.setBoolean(NEWTUONBR, newTuOnBr);
    }

    public boolean getExtractHiddenLayers() {
        return this.getBoolean(EXTRACTHIDDENLAYERS);
    }

    public void setExtractHiddenLayers(boolean extractHiddenLayers) {
        this.setBoolean(EXTRACTHIDDENLAYERS, extractHiddenLayers);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(EXTRACTNOTES, "Extract notes", null);
        desc.add(EXTRACTMASTERSPREADS, "Extract master spreads", null);
        desc.add(EXTRACTHIDDENLAYERS, "Extract hidden layers", null);
        desc.add(SIMPLIFYCODES, "Simplify inline codes when possible", null);
        desc.add(NEWTUONBR, "Create new text units on hard returns [IMPORTANT: STILL BETA! MAY PREVENT MERGING BACK!]", "Option is BETA and may prevent you to merge back. Make sure to test round-trip!");
        desc.add(SKIPTHRESHOLD, "Maximum spread size", "Skip (or stop for) any spread larger than the given value (in Kbytes)");
        desc.add(STOPWHENOVERTHRESHOLD, "Generate an error when a spread is larger than the specified value", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("IDML Filter", true, false);
        desc.addCheckboxPart(paramsDesc.get(EXTRACTNOTES));
        desc.addCheckboxPart(paramsDesc.get(EXTRACTMASTERSPREADS));
        desc.addCheckboxPart(paramsDesc.get(EXTRACTHIDDENLAYERS));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(SIMPLIFYCODES));
        desc.addCheckboxPart(paramsDesc.get(NEWTUONBR));
        desc.addSeparatorPart();
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(SKIPTHRESHOLD));
        sip.setRange(1, 32000);
        desc.addCheckboxPart(paramsDesc.get(STOPWHENOVERTHRESHOLD));
        return desc;
    }
}

