/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Relationships {
    private XMLInputFactory factory;
    private Map<String, Rel> relsById = new HashMap<String, Rel>();
    private String targetBase;
    static final String RELS_NS = "http://schemas.openxmlformats.org/package/2006/relationships";
    static final QName RELATIONSHIP = new QName("http://schemas.openxmlformats.org/package/2006/relationships", "Relationship");
    static final QName ID_ATTR = new QName("Id");
    static final QName TARGET_ATTR = new QName("Target");
    static final QName TYPE_ATTR = new QName("Type");

    public Relationships(XMLInputFactory factory) {
        this.factory = factory;
    }

    private void addRelationship(String id, String type, String target) {
        Rel rel = new Rel();
        rel.id = id;
        rel.type = type;
        rel.target = this.normalizeTarget(target);
        this.relsById.put(id, rel);
    }

    public Rel getRelById(String id) {
        return this.relsById.get(id);
    }

    public void parseFromXML(String relsPartName, Reader reader) throws XMLStreamException {
        this.targetBase = this.findTargetBase(relsPartName);
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            StartElement el;
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement() || !(el = e.asStartElement()).getName().equals(RELATIONSHIP)) continue;
            Attribute target = el.getAttributeByName(TARGET_ATTR);
            Attribute id = el.getAttributeByName(ID_ATTR);
            Attribute type = el.getAttributeByName(TYPE_ATTR);
            if (target == null || id == null || type == null) continue;
            this.addRelationship(id.getValue(), type.getValue(), target.getValue());
        }
    }

    private String findTargetBase(String relsPartName) {
        int i = relsPartName.lastIndexOf("/_rels/");
        if (i == -1) {
            throw new IllegalStateException("Unexpected relationships part path: " + relsPartName);
        }
        return relsPartName.substring(0, i);
    }

    private String normalizeTarget(String target) {
        String base = this.targetBase;
        while (target.startsWith("../")) {
            int i = base.lastIndexOf("/");
            if (i == -1) {
                if (base.isEmpty()) {
                    throw new IllegalStateException(String.format("Unable to resolve '%s' against path '%s'.", target, this.targetBase));
                }
                base = "";
            } else {
                base = base.substring(0, i);
            }
            target = target.substring(3);
        }
        return base + (base.isEmpty() ? "" : "/") + target;
    }

    public class Rel {
        String target;
        String id;
        String type;
    }
}

