/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.railsyaml;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class RailsYamlSkeletonWriter
extends GenericSkeletonWriter {
    private Yaml yamlWriter;
    private DumperOptions options;
    private boolean escapeNonAscii;
    private Property quote;

    public RailsYamlSkeletonWriter(boolean escapeNonAscii) {
        this.escapeNonAscii = escapeNonAscii;
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        this.quote = resource.getProperty("Quote Char");
        return super.processTextUnit(resource);
    }

    @Override
    public String getContent(TextFragment tf, LocaleId locToUse, EncoderContext context) {
        String unencoded = super.getContent(tf, locToUse, context);
        this.options = new DumperOptions();
        this.options.setAllowUnicode(!this.escapeNonAscii);
        this.options.setPrettyFlow(false);
        this.options.setWidth(Integer.MAX_VALUE);
        String q = this.quote.getValue();
        if (q.equals("\"")) {
            this.options.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        } else if (q.equals("'")) {
            this.options.setDefaultScalarStyle(DumperOptions.ScalarStyle.SINGLE_QUOTED);
        } else {
            this.options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        }
        this.yamlWriter = new Yaml(this.options);
        String encodedString = this.yamlWriter.dump(unencoded);
        return encodedString;
    }
}

