/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.regex;

import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.LocalizationDirectives;
import net.sf.okapi.filters.regex.Rule;

public class Parameters
extends StringParameters {
    private static final String EXTRACTOUTERSTRINGS = "extractOuterStrings";
    private static final String STARTSTRING = "startString";
    private static final String ENDSTRING = "endString";
    private static final String USEBSLASHESCAPE = "useBSlashEscape";
    private static final String USEDOUBLECHARESCAPE = "useDoubleCharEscape";
    private static final String ONELEVELGROUP = "oneLevelGroups";
    private static final String USELD = "useLd";
    private static final String LOCALIZEOUTSIDE = "localizeOutside";
    private static final String REGEXOPTIONS = "regexOptions";
    private static final String MIMETYPE = "mimeType";
    private LocalizationDirectives localizationDirectives;
    private ArrayList<Rule> rules;

    @Override
    public void reset() {
        super.reset();
        this.setRegexOptions(40);
        this.setStartString("\"");
        this.setEndString("\"");
        this.setExtractOuterStrings(false);
        this.setUseBSlashEscape(true);
        this.setUseDoubleCharEscape(false);
        this.setMimeType("text/plain");
        this.setOneLevelGroups(false);
        this.rules = new ArrayList();
        this.localizationDirectives = new LocalizationDirectives();
    }

    public boolean getExtractOuterStrings() {
        return this.getBoolean(EXTRACTOUTERSTRINGS);
    }

    public void setExtractOuterStrings(boolean extractOuterStrings) {
        this.setBoolean(EXTRACTOUTERSTRINGS, extractOuterStrings);
    }

    public String getStartString() {
        return this.getString(STARTSTRING);
    }

    public void setStartString(String startString) {
        this.setString(STARTSTRING, startString);
    }

    public String getEndString() {
        return this.getString(ENDSTRING);
    }

    public void setEndString(String endString) {
        this.setString(ENDSTRING, endString);
    }

    public boolean getUseBSlashEscape() {
        return this.getBoolean(USEBSLASHESCAPE);
    }

    public void setUseBSlashEscape(boolean useBSlashEscape) {
        this.setBoolean(USEBSLASHESCAPE, useBSlashEscape);
    }

    public boolean getUseDoubleCharEscape() {
        return this.getBoolean(USEDOUBLECHARESCAPE);
    }

    public void setUseDoubleCharEscape(boolean useDoubleCharEscape) {
        this.setBoolean(USEDOUBLECHARESCAPE, useDoubleCharEscape);
    }

    public int getRegexOptions() {
        return this.getInteger(REGEXOPTIONS);
    }

    public void setRegexOptions(int regexOptions) {
        this.setInteger(REGEXOPTIONS, regexOptions);
    }

    public LocalizationDirectives getLocalizationDirectives() {
        return this.localizationDirectives;
    }

    public void setLocalizationDirectives(LocalizationDirectives localizationDirectives) {
        this.localizationDirectives = localizationDirectives;
    }

    public String getMimeType() {
        return this.getString(MIMETYPE);
    }

    public void setMimeType(String mimeType) {
        this.setString(MIMETYPE, mimeType);
    }

    public boolean getOneLevelGroups() {
        return this.getBoolean(ONELEVELGROUP);
    }

    public void setOneLevelGroups(boolean oneLevelGroups) {
        this.setBoolean(ONELEVELGROUP, oneLevelGroups);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        boolean tmpBool1 = this.buffer.getBoolean(USELD, this.localizationDirectives.useLD());
        boolean tmpBool2 = this.buffer.getBoolean(LOCALIZEOUTSIDE, this.localizationDirectives.localizeOutside());
        this.localizationDirectives.setOptions(tmpBool1, tmpBool2);
        int count = this.buffer.getInteger("ruleCount", 0);
        for (int i = 0; i < count; ++i) {
            Rule rule = new Rule();
            rule.fromString(this.buffer.getGroup(String.format("rule%d", i), null));
            this.rules.add(rule);
        }
    }

    @Override
    public String toString() {
        this.buffer.setBoolean(USELD, this.localizationDirectives.useLD());
        this.buffer.setBoolean(LOCALIZEOUTSIDE, this.localizationDirectives.localizeOutside());
        this.buffer.setInteger("ruleCount", this.rules.size());
        for (int i = 0; i < this.rules.size(); ++i) {
            this.buffer.setGroup(String.format("rule%d", i), this.rules.get(i).toString());
        }
        return super.toString();
    }

    public void compileRules() {
        for (Rule rule : this.rules) {
            rule.pattern = Pattern.compile(rule.expr, this.getRegexOptions());
            if (!rule.useCodeFinder) continue;
            rule.codeFinder.compile();
        }
    }

    public ArrayList<Rule> getRules() {
        return this.rules;
    }
}

