/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.ts.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TsFilter
implements IFilter {
    TS ts = new TS();
    Stack<String> elementStack = new Stack();
    ArrayList<XMLEvent> eventList = new ArrayList();
    GenericSkeleton skel;
    XMLEventReader eventReader;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private boolean hasNext;
    private String docName;
    private boolean canceled;
    private LinkedList<Event> queue;
    private String lineBreak;
    private String encoding;
    private boolean hasUTF8BOM;
    private Parameters params;
    private EncoderManager encoderManager;
    private String contextName;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RawDocument input;

    public TsFilter() {
        this.params = new Parameters();
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        try {
            if (this.eventReader != null) {
                this.eventReader.close();
                this.eventReader = null;
                this.docName = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-ts", this.getClass().getName(), "TS", "Configuration for Qt TS files.", null, ".ts;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-ts", "net.sf.okapi.common.encoder.TSEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getMimeType() {
        return "application/x-ts";
    }

    @Override
    public String getName() {
        return "okf_ts";
    }

    @Override
    public String getDisplayName() {
        return "TS Filter";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.ts.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            XMLStreamReader reader;
            this.input = input;
            this.canceled = false;
            XMLInputFactory fact = null;
            Class<?> factClass = ClassUtil.getClass("com.ctc.wstx.stax.WstxInputFactory");
            fact = (XMLInputFactory)factClass.newInstance();
            fact.setProperty("javax.xml.stream.supportDTD", false);
            fact.setProperty("javax.xml.stream.isCoalescing", false);
            fact.setProperty("org.codehaus.stax2.reportPrologWhitespace", true);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            if (detector.isAutodetected()) {
                input.setEncoding(detector.getEncoding());
                reader = fact.createXMLStreamReader(input.getStream(), detector.getEncoding());
            } else {
                reader = fact.createXMLStreamReader(input.getStream());
            }
            String realEnc = reader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            this.eventReader = fact.createXMLEventReader(reader);
            this.srcLang = input.getSourceLocale();
            if (this.srcLang == null) {
                throw new NullPointerException("Source language not set.");
            }
            this.trgLang = input.getTargetLocale();
            if (this.trgLang == null) {
                throw new NullPointerException("Target language not set.");
            }
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.ts.resetAll();
            this.contextName = null;
            this.hasNext = true;
            this.queue = new LinkedList();
            if (this.params.getUseCodeFinder()) {
                this.params.getCodeFinder().compile();
            }
            net.sf.okapi.common.resource.StartDocument startDoc = new net.sf.okapi.common.resource.StartDocument(this.ts.otherId.createId());
            startDoc.setName(this.docName);
            startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            startDoc.setLocale(this.srcLang);
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType("application/x-ts");
            startDoc.setMimeType("application/x-ts");
            startDoc.setMultilingual(true);
            startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
            this.skel = new GenericSkeleton();
            startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>");
            startDoc.setSkeleton(this.skel);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private boolean read() throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            IResource resource;
            XMLEvent event = this.eventReader.nextEvent();
            this.eventList.add(event);
            if (event.getEventType() == 1) {
                StartElement startElem = event.asStartElement();
                String startElemName = startElem.getName().getLocalPart();
                if (!startElemName.equals("byte")) {
                    this.elementStack.push(startElemName);
                }
                if (this.tsPartReady(startElemName)) {
                    this.eventList.remove(this.eventList.size() - 1);
                    resource = this.generateTsPart(true);
                    this.eventList.clear();
                    this.eventList.add(event);
                    this.queue.add(new Event(EventType.DOCUMENT_PART, resource));
                } else if (this.contextPartReady(startElemName)) {
                    this.eventList.remove(this.eventList.size() - 1);
                    resource = this.generateContextPart(true);
                    this.eventList.clear();
                    this.eventList.add(event);
                    this.queue.add(new Event(EventType.START_GROUP, resource));
                }
                if (startElemName.equals("name")) {
                    this.readContextName();
                }
                if (startElemName.equals("context")) {
                    this.ts.currentDocumentLocation = DocumentLocation.CONTEXT;
                    continue;
                }
                if (!startElemName.equals("message")) continue;
                this.ts.currentDocumentLocation = DocumentLocation.MESSAGE;
                continue;
            }
            if (event.getEventType() != 2) continue;
            EndElement endElem = event.asEndElement();
            String endElemName = endElem.getName().getLocalPart();
            if (!endElemName.equals("byte")) {
                this.elementStack.pop();
            }
            if (endElemName.equals("message")) {
                this.ts.analyzeMessage();
                if (this.ts.msgIsObsolete() || this.ts.noSource()) {
                    StartElement se = this.getStartElement("message");
                    if (this.ts.noSource()) {
                        this.logger.warn("Message (Line {} contains no <source>. Message will be ignored.", (Object)se.getLocation().getLineNumber());
                    }
                    DocumentPart dp = this.generateObsoleteTu();
                    this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                    this.eventList.clear();
                    this.ts.reset();
                    this.skel = new GenericSkeleton();
                    continue;
                }
                if (this.ts.numerusFormCount > 0) {
                    this.generateNumerusFormTu();
                    this.eventList.clear();
                    this.ts.reset();
                    this.skel = new GenericSkeleton();
                    return true;
                }
                ITextUnit tu = this.generateTu();
                this.queue.add(new Event(EventType.TEXT_UNIT, tu));
                this.eventList.clear();
                this.ts.reset();
                this.skel = new GenericSkeleton();
                return true;
            }
            if (!endElemName.equals("context")) continue;
            resource = this.generateContextPart(false);
            this.eventList.clear();
            this.queue.add(new Event(EventType.END_GROUP, resource));
        }
        IResource resource = this.generateTsPart(false);
        this.queue.add(new Event(EventType.DOCUMENT_PART, resource));
        this.eventList.clear();
        this.skel = new GenericSkeleton("");
        return false;
    }

    private void readContextName() throws XMLStreamException {
        block4: while (true) {
            XMLEvent event = this.eventReader.nextEvent();
            this.eventList.add(event);
            switch (event.getEventType()) {
                case 4: {
                    this.contextName = event.asCharacters().getData();
                    continue block4;
                }
                case 6: {
                    continue block4;
                }
            }
            break;
        }
    }

    private StartElement getStartElement(String pElemName, int n) {
        int count = 0;
        for (XMLEvent event : this.eventList) {
            StartElement startElement;
            if (event.getEventType() != 1 || !(startElement = event.asStartElement()).getName().getLocalPart().equals(pElemName) || ++count != n) continue;
            return startElement;
        }
        return null;
    }

    private StartElement getStartElement(String pElemName) {
        return this.getStartElement(pElemName, 1);
    }

    private boolean tsPartReady(String elemName) {
        return this.ts.currentDocumentLocation == DocumentLocation.TS && (elemName.equals("context") || elemName.equals("message"));
    }

    private boolean contextPartReady(String elemName) {
        return this.ts.currentDocumentLocation == DocumentLocation.CONTEXT && (elemName.equals("context") || elemName.equals("message"));
    }

    IResource generateTsPart(boolean start) {
        boolean nextIsSkippableEmpty = false;
        DocumentPart resource = new DocumentPart(this.ts.otherId.createId(), false);
        this.skel = new GenericSkeleton();
        for (XMLEvent event : this.eventList) {
            if (nextIsSkippableEmpty) {
                nextIsSkippableEmpty = false;
                continue;
            }
            if (event.getEventType() == 7) {
                this.procStartDoc(event);
                continue;
            }
            if (event.getEventType() == 8) continue;
            if (event.getEventType() == 11) {
                this.procDTD(event);
                continue;
            }
            if (event.getEventType() == 12) {
                this.procCDATA(event);
                continue;
            }
            if (event.getEventType() == 5) {
                this.procComment(event);
                continue;
            }
            if (event.getEventType() == 1) {
                StartElement startElem = event.asStartElement();
                String startElemName = startElem.getName().getLocalPart();
                nextIsSkippableEmpty = this.nextIsSkippableEmpty(startElem);
                if (start && startElemName.equals("TS")) {
                    this.procStartElemTS(startElem, resource);
                    continue;
                }
                if (startElemName.equals("byte")) {
                    this.procStartElemByte(startElem);
                    continue;
                }
                this.procStartElemGeneric(startElem, nextIsSkippableEmpty);
                continue;
            }
            if (event.getEventType() == 2) {
                EndElement endElem = event.asEndElement();
                this.procEndElem(endElem);
                continue;
            }
            if (event.getEventType() != 4) continue;
            Characters chars = event.asCharacters();
            this.procCharacters(chars);
        }
        resource.setSkeleton(this.skel);
        return resource;
    }

    IResource generateContextPart(boolean start) {
        IResource resource;
        boolean nextIsSkippableEmpty = false;
        this.skel = new GenericSkeleton();
        String otherId = this.ts.otherId.createId();
        if (start) {
            this.ts.contextStack.push(otherId);
            resource = new StartGroup(null, String.valueOf(otherId));
            if (this.contextName != null) {
                ((StartGroup)resource).setName(this.contextName);
                this.contextName = null;
            }
        } else {
            this.ts.contextStack.pop();
            resource = new Ending(String.valueOf(otherId));
        }
        for (XMLEvent event : this.eventList) {
            if (nextIsSkippableEmpty) {
                nextIsSkippableEmpty = false;
                continue;
            }
            if (event.getEventType() == 11) {
                this.procDTD(event);
                continue;
            }
            if (event.getEventType() == 5) {
                this.procComment(event);
                continue;
            }
            if (event.getEventType() == 1) {
                StartElement startElem = event.asStartElement();
                String startElemName = startElem.getName().getLocalPart();
                nextIsSkippableEmpty = this.nextIsSkippableEmpty(startElem);
                if (start && startElemName.equals("context")) {
                    this.procStartElemContext(startElem, resource);
                    continue;
                }
                if (startElemName.equals("byte")) {
                    this.procStartElemByte(startElem);
                    continue;
                }
                this.procStartElemGeneric(startElem, nextIsSkippableEmpty);
                continue;
            }
            if (event.getEventType() == 2) {
                EndElement endElem = event.asEndElement();
                this.procEndElem(endElem);
                continue;
            }
            if (event.getEventType() == 4) {
                Characters chars = event.asCharacters();
                this.procCharacters(chars);
                continue;
            }
            if (event.getEventType() != 12) continue;
            this.procCDATA(event);
        }
        resource.setSkeleton(this.skel);
        return resource;
    }

    ITextUnit generateTu() {
        boolean nextIsSkippableEmpty = false;
        this.skel = new GenericSkeleton();
        TextUnit tu = new TextUnit(String.valueOf(++this.ts.tuId));
        for (XMLEvent event : this.eventList) {
            if (nextIsSkippableEmpty) {
                nextIsSkippableEmpty = false;
                continue;
            }
            if (event.getEventType() == 1) {
                StartElement startElem = event.asStartElement();
                String startElemName = startElem.getName().getLocalPart();
                nextIsSkippableEmpty = this.nextIsSkippableEmpty(startElem);
                if (startElemName.equals("translatorcomment")) {
                    this.ts.procTransComment = true;
                }
                if (startElemName.equals("message")) {
                    this.procStartElemMessage(startElem, tu);
                    Attribute msgId = startElem.getAttributeByName(new QName("id"));
                    if (msgId == null) continue;
                    this.ts.messageId = msgId.getValue();
                    continue;
                }
                if (startElemName.equals("source")) {
                    this.ts.currentMessageLocation = MessageLocation.SOURCE;
                    this.procStartElemSource(startElem, tu);
                    continue;
                }
                if (startElemName.equals("translation")) {
                    this.ts.currentMessageLocation = MessageLocation.TARGET;
                    this.procStartElemTarget(startElem, tu);
                    continue;
                }
                if (startElemName.equals("numerusform")) {
                    this.procStartElemAddToTuContent(startElem, tu);
                    continue;
                }
                if (startElemName.equals("lengthvariant")) {
                    this.procStartElemAddToTuContent(startElem, tu);
                    continue;
                }
                if (startElemName.equals("byte")) {
                    this.procStartElemByte(startElem, tu);
                    continue;
                }
                this.procStartElemGeneric(startElem, nextIsSkippableEmpty);
                continue;
            }
            if (event.getEventType() == 2) {
                EndElement endElem = event.asEndElement();
                String endElemName = endElem.getName().getLocalPart();
                if (endElemName.equals("translatorcomment")) {
                    this.ts.procTransComment = false;
                }
                if (endElemName.equals("source")) {
                    this.ts.currentMessageLocation = MessageLocation.RESOURCE;
                    this.procEndElem(endElem);
                } else if (endElemName.equals("translation")) {
                    this.ts.currentMessageLocation = MessageLocation.RESOURCE;
                    if (this.ts.targetIsEmpty()) {
                        this.skel.addContentPlaceholder(tu, this.trgLang);
                        Property approvedProp = tu.getTargetProperty(this.trgLang, "approved");
                        if (approvedProp.getValue().equals("yes")) {
                            approvedProp.setValue("no");
                            tu.setTargetProperty(this.trgLang, approvedProp);
                            this.logger.warn("Translation (Line {}) is empty. type attribute was updated to unfinished.", (Object)endElem.getLocation().getLineNumber());
                        }
                    }
                    this.procEndElem(endElem);
                } else if (endElemName.equals("numerusform")) {
                    this.procEndElemAddToTuContent(endElem, tu);
                } else if (endElemName.equals("lengthvariant")) {
                    this.procEndElemAddToTuContent(endElem, tu);
                } else {
                    this.procEndElem(endElem);
                }
                if (!this.needTargetSection() || !this.insertTargetAfterElem(endElemName)) continue;
                this.addTargetSection(tu);
                continue;
            }
            if (event.getEventType() != 4) continue;
            Characters chars = event.asCharacters();
            this.procCharacters(chars, tu);
        }
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().process(tu.getSource().getFirstContent());
            this.params.getCodeFinder().process(tu.getTarget(this.trgLang).getFirstContent());
        }
        tu.setSkeleton(this.skel);
        tu.setMimeType("application/x-ts");
        if (this.ts.messageId != null) {
            tu.setName(this.ts.messageId);
        }
        return tu;
    }

    void generateNumerusFormTu() {
        boolean nextIsSkippableEmpty = false;
        TextFragment source = new TextFragment();
        StartGroup sg = new StartGroup(null, this.ts.otherId.createId());
        Ending end = new Ending(this.ts.otherId.createId());
        ITextUnit tf_target = null;
        int numerus_counter = 0;
        for (XMLEvent event : this.eventList) {
            if (nextIsSkippableEmpty) {
                nextIsSkippableEmpty = false;
                continue;
            }
            if (event.getEventType() == 1) {
                StartElement startElem = event.asStartElement();
                String startElemName = startElem.getName().getLocalPart();
                nextIsSkippableEmpty = this.nextIsSkippableEmpty(startElem);
                if (startElemName.equals("message")) {
                    this.procStartElemMessage(startElem, sg);
                    Attribute msgId = startElem.getAttributeByName(new QName("id"));
                    if (msgId == null) continue;
                    this.ts.messageId = msgId.getValue();
                    continue;
                }
                if (startElemName.equals("source")) {
                    this.ts.currentMessageLocation = MessageLocation.SOURCE;
                    this.addStartElemToSkel(startElem);
                    continue;
                }
                if (startElemName.equals("translation")) {
                    this.procStartElemTarget(startElem, sg);
                    continue;
                }
                if (startElemName.equals("numerusform")) {
                    this.ts.currentMessageLocation = MessageLocation.TARGET;
                    if (numerus_counter == 0) {
                        sg.setSkeleton(this.skel);
                        if (this.ts.messageId != null) {
                            sg.setName(this.ts.messageId);
                        }
                        this.queue.add(new Event(EventType.START_GROUP, sg));
                        this.skel = new GenericSkeleton();
                    }
                    ++numerus_counter;
                    this.addStartElemToSkel(startElem);
                    tf_target = new TextUnit(String.valueOf(++this.ts.tuId));
                    tf_target.setSourceContent(source);
                    tf_target.createTarget(this.trgLang, false, 0);
                    continue;
                }
                if (startElemName.equals("lengthvariant")) {
                    if (this.ts.currentMessageLocation == MessageLocation.RESOURCE) {
                        this.addStartElemToSkel(startElem);
                        continue;
                    }
                    if (this.ts.currentMessageLocation != MessageLocation.TARGET) continue;
                    this.procStartElemAddToTuContent(startElem, tf_target);
                    continue;
                }
                if (startElemName.equals("byte")) {
                    Attribute attr = startElem.getAttributeByName(new QName("value"));
                    if (this.ts.currentMessageLocation == MessageLocation.RESOURCE) {
                        this.procStartElemByte(startElem);
                        continue;
                    }
                    if (this.ts.currentMessageLocation == MessageLocation.SOURCE) {
                        this.procStartElemByte(startElem);
                        if (this.params.getDecodeByteValues()) {
                            source.append(this.decodeByteValue(attr.getValue()));
                            continue;
                        }
                        source.append(TextFragment.TagType.PLACEHOLDER, "byte", "<byte value=\"" + attr.getValue() + "\"/>");
                        continue;
                    }
                    if (this.ts.currentMessageLocation != MessageLocation.TARGET) continue;
                    this.procStartElemByte(startElem, tf_target);
                    continue;
                }
                this.procStartElemGeneric(startElem, nextIsSkippableEmpty);
                continue;
            }
            if (event.getEventType() == 2) {
                EndElement endElem = event.asEndElement();
                String endElemName = endElem.getName().getLocalPart();
                if (endElemName.equals("source")) {
                    this.ts.currentMessageLocation = MessageLocation.RESOURCE;
                    this.procEndElem(endElem);
                    continue;
                }
                if (endElemName.equals("numerusform")) {
                    this.ts.currentMessageLocation = MessageLocation.RESOURCE;
                    this.procEndElem(endElem);
                    if (this.params.getUseCodeFinder()) {
                        this.params.getCodeFinder().process(tf_target.getSource().getFirstContent());
                        this.params.getCodeFinder().process(tf_target.getTarget(this.trgLang).getFirstContent());
                    }
                    tf_target.setSkeleton(this.skel);
                    tf_target.setMimeType("application/x-ts");
                    this.queue.add(new Event(EventType.TEXT_UNIT, tf_target));
                    this.skel = new GenericSkeleton();
                    continue;
                }
                if (endElemName.equals("lengthvariant")) {
                    if (this.ts.currentMessageLocation == MessageLocation.RESOURCE) {
                        this.procEndElem(endElem);
                        continue;
                    }
                    if (this.ts.currentMessageLocation != MessageLocation.TARGET) continue;
                    this.procEndElemAddToTuContent(endElem, tf_target);
                    continue;
                }
                this.procEndElem(endElem);
                continue;
            }
            if (event.getEventType() != 4) continue;
            Characters chars = event.asCharacters();
            if (this.ts.currentMessageLocation == MessageLocation.RESOURCE) {
                this.procCharacters(chars);
                continue;
            }
            if (this.ts.currentMessageLocation == MessageLocation.SOURCE) {
                source.append(chars.getData());
                this.procCharacters(chars);
                continue;
            }
            if (this.ts.currentMessageLocation != MessageLocation.TARGET) continue;
            TextContainer tc = tf_target.getTarget(this.trgLang);
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tf_target, this.trgLang);
            }
            tc.getFirstContent().append(chars.getData());
        }
        end.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, end));
        this.skel = new GenericSkeleton();
    }

    private void addTargetSection(ITextUnit tu) {
        this.skel.append(this.lineBreak);
        this.skel.append("<translation");
        this.skel.addValuePlaceholder(tu, "approved", this.trgLang);
        tu.setTargetProperty(this.trgLang, new Property("approved", "no", false));
        tu.setTargetProperty(this.trgLang, new Property("variants", "no"));
        this.skel.append(" variants=\"no\">");
        this.skel.addContentPlaceholder(tu, this.trgLang);
        this.skel.append("</translation>");
    }

    private boolean insertTargetAfterElem(String endElemName) {
        return endElemName.equals(this.ts.elemBeforeTrg);
    }

    private boolean needTargetSection() {
        return !this.ts.noSource() && !this.ts.targetExists;
    }

    DocumentPart generateObsoleteTu() {
        boolean nextIsSkippableEmpty = false;
        this.skel = new GenericSkeleton();
        DocumentPart dp = new DocumentPart(this.ts.otherId.createId(), false);
        for (XMLEvent event : this.eventList) {
            if (nextIsSkippableEmpty) {
                nextIsSkippableEmpty = false;
                continue;
            }
            if (event.getEventType() == 1) {
                StartElement startElem = event.asStartElement();
                nextIsSkippableEmpty = this.nextIsSkippableEmpty(startElem);
                if (startElem.getName().getLocalPart().equals("byte")) {
                    this.procStartElemByte(startElem);
                    continue;
                }
                this.procStartElemGeneric(startElem, nextIsSkippableEmpty);
                continue;
            }
            if (event.getEventType() == 2) {
                EndElement endElement = event.asEndElement();
                this.procEndElem(endElement);
                continue;
            }
            if (event.getEventType() != 4) continue;
            Characters chars = event.asCharacters();
            this.procCharacters(chars);
        }
        dp.setSkeleton(this.skel);
        return dp;
    }

    private void procCharacters(Characters chars, ITextUnit tu) {
        if (this.ts.procTransComment) {
            tu.setProperty(new Property("transNote", chars.getData()));
        }
        if (this.ts.currentMessageLocation == MessageLocation.RESOURCE) {
            this.procCharacters(chars);
        } else if (this.ts.currentMessageLocation == MessageLocation.SOURCE) {
            TextContainer tc = tu.getSource();
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu);
            }
            tc.getFirstContent().append(chars.getData());
        } else if (this.ts.currentMessageLocation == MessageLocation.TARGET) {
            TextContainer tc = tu.getTarget(this.trgLang);
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu, this.trgLang);
            }
            tc.getFirstContent().append(chars.getData());
        }
    }

    private void procCharacters(Characters chars) {
        String escaped = Util.escapeToXML(chars.getData().replace("\n", this.lineBreak), 0, true, null);
        this.skel.append(escaped);
    }

    private void procDTD(XMLEvent event) {
        DTD dtd = (DTD)event;
        this.skel.append(dtd.getDocumentTypeDeclaration().replace("\n", this.lineBreak));
    }

    private void procCDATA(XMLEvent event) {
        Characters chars = event.asCharacters();
        this.skel.append(chars.getData().replace("\n", this.lineBreak));
    }

    private void procComment(XMLEvent event) {
        Comment comment = (Comment)event;
        this.skel.append("<!--" + comment.getText().replace("\n", this.lineBreak) + "-->");
    }

    private void procStartDoc(XMLEvent event) {
        String xmlEnc;
        StartDocument startDoc = (StartDocument)event;
        String xmlVersion = startDoc.getVersion();
        if (xmlVersion != null && !xmlVersion.equals("1.0")) {
            this.logger.warn("Filter will use xml version 1.0");
        }
        if ((xmlEnc = startDoc.getCharacterEncodingScheme()) != null && !xmlEnc.equalsIgnoreCase(this.encoding)) {
            this.logger.warn("The xml encoding attribute value {} is different from what was detected or specified in the settings. Encoding {} will be used.", (Object)xmlEnc, (Object)this.encoding);
        }
    }

    private void procStartElemTS(StartElement startElement, IResource resource) {
        this.addStartElemToSkelAddProps(startElement, resource);
    }

    private void procStartElemContext(StartElement startElement, IResource resource) {
        this.addStartElemToSkelAddProps(startElement, resource);
    }

    private void procStartElemMessage(StartElement startElement, IResource resource) {
        this.addStartElemToSkelAddProps(startElement, resource);
    }

    private void procStartElemSource(StartElement startElement, ITextUnit tu) {
        this.addStartElemToSkel(startElement);
    }

    private void procStartElemTarget(StartElement startElement, IResource resource) {
        INameable nameable = (INameable)resource;
        boolean typeFound = false;
        this.skel.append("<" + startElement.getName().getLocalPart());
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Property prop;
            Attribute attribute = attributes.next();
            if (attribute.getName().getLocalPart().equals("type")) {
                typeFound = true;
                if (attribute.getValue().equals("unfinished")) {
                    this.skel.addValuePlaceholder(nameable, "approved", this.trgLang);
                    nameable.setTargetProperty(this.trgLang, new Property("approved", "no", false));
                    continue;
                }
                this.skel.append(String.format(" %s=\"%s\"", attribute.getName().getLocalPart(), attribute.getValue()));
                prop = new Property(attribute.getName().getLocalPart(), attribute.getValue());
                nameable.setTargetProperty(this.trgLang, prop);
                continue;
            }
            this.skel.append(String.format(" %s=\"%s\"", attribute.getName().getLocalPart(), attribute.getValue()));
            prop = new Property(attribute.getName().getLocalPart(), attribute.getValue());
            nameable.setTargetProperty(this.trgLang, prop);
        }
        if (!typeFound) {
            this.skel.addValuePlaceholder(nameable, "approved", this.trgLang);
            nameable.setTargetProperty(this.trgLang, new Property("approved", "yes", false));
        }
        this.skel.append(">");
    }

    private void addStartElemToSkelAddProps(StartElement startElement, IResource resource) {
        this.skel.append("<" + startElement.getName().getLocalPart());
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            this.skel.append(String.format(" %s=\"%s\"", attribute.getName().getLocalPart(), attribute.getValue()));
            Property prop = new Property(attribute.getName().getLocalPart(), attribute.getValue());
            if (resource instanceof DocumentPart) {
                ((DocumentPart)resource).setProperty(prop);
                continue;
            }
            if (resource instanceof StartGroup) {
                ((StartGroup)resource).setProperty(prop);
                continue;
            }
            if (!(resource instanceof ITextUnit)) continue;
            ((ITextUnit)resource).setProperty(prop);
        }
        this.skel.append(">");
    }

    private void addStartElemToSkel(StartElement startElement) {
        this.skel.append("<" + startElement.getName().getLocalPart());
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            this.skel.append(String.format(" %s=\"%s\"", attribute.getName().getLocalPart(), attribute.getValue()));
        }
        this.skel.append(">");
    }

    private void procStartElemAddToTuContent(StartElement startElement, ITextUnit tu) {
        TextContainer tc;
        StringBuilder sb = new StringBuilder();
        sb.append("<" + startElement.getName().getLocalPart());
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            sb.append(String.format(" %s=\"%s\"", attribute.getName().getLocalPart(), attribute.getValue()));
        }
        sb.append(">");
        if (this.ts.currentMessageLocation == MessageLocation.SOURCE) {
            tc = tu.getSource();
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu);
            }
            tc.getFirstContent().append(sb.toString());
        } else if (this.ts.currentMessageLocation == MessageLocation.TARGET) {
            tc = tu.getTarget(this.trgLang);
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu, this.trgLang);
            }
            tc.getFirstContent().append(sb.toString());
        }
    }

    private void procEndElemAddToTuContent(EndElement endElement, ITextUnit tu) {
        StringBuilder sb = new StringBuilder();
        sb.append("</" + endElement.getName().getLocalPart() + ">");
        if (this.ts.currentMessageLocation == MessageLocation.SOURCE) {
            TextContainer tc = tu.getSource();
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu);
            }
            tc.getFirstContent().append(sb.toString());
        } else if (this.ts.currentMessageLocation == MessageLocation.TARGET) {
            TextContainer tc = tu.getTarget(this.trgLang);
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu, this.trgLang);
            }
            tc.getFirstContent().append(sb.toString());
        }
    }

    private void procStartElemGeneric(StartElement elem, boolean nextIsSkippableEmpty) {
        this.skel.append("<" + elem.getName().getLocalPart());
        Iterator<Attribute> attributes = elem.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            this.skel.append(String.format(" %s=\"%s\"", attribute.getName().getLocalPart(), attribute.getValue()));
        }
        if (nextIsSkippableEmpty) {
            this.skel.append("/>");
        } else {
            this.skel.append(">");
        }
    }

    private void procStartElemByte(StartElement elem, ITextUnit tu) {
        Attribute attr = elem.getAttributeByName(new QName("value"));
        if (this.ts.currentMessageLocation == MessageLocation.RESOURCE) {
            this.procStartElemByte(elem);
        } else if (this.ts.currentMessageLocation == MessageLocation.SOURCE) {
            TextContainer tc = tu.getSource();
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu);
            }
            if (this.params.getDecodeByteValues()) {
                tc.getFirstContent().append(this.decodeByteValue(attr.getValue()));
            } else {
                tc.getFirstContent().append(TextFragment.TagType.PLACEHOLDER, "byte", "<byte value=\"" + attr.getValue() + "\"/>");
            }
        } else if (this.ts.currentMessageLocation == MessageLocation.TARGET) {
            TextContainer tc = tu.getTarget(this.trgLang);
            if (!tc.hasText()) {
                this.skel.addContentPlaceholder(tu, this.trgLang);
            }
            if (this.params.getDecodeByteValues()) {
                tc.getFirstContent().append(this.decodeByteValue(attr.getValue()));
            } else {
                tc.getFirstContent().append(TextFragment.TagType.PLACEHOLDER, "byte", "<byte value=\"" + attr.getValue() + "\"/>");
            }
        }
    }

    private void procStartElemByte(StartElement elem) {
        this.skel.append("<byte value=\"" + elem.getAttributeByName(new QName("value")).getValue() + "\"/>");
    }

    private void procEndElem(EndElement elem) {
        this.skel.append("</" + elem.getName().getLocalPart() + ">");
    }

    private boolean elementShouldBeEmpty(String name) {
        return name.equals("byte") || name.equals("location");
    }

    boolean nextIsSkippableEmpty(StartElement elem) {
        String elemName = elem.getName().getLocalPart();
        return this.elementShouldBeEmpty(elemName) && this.nextIsEmpty(elem);
    }

    private boolean nextIsEmpty(StartElement elem) {
        int index = this.eventList.indexOf(elem);
        XMLEvent nextEvent = this.eventList.get(index + 1);
        if (nextEvent != null && nextEvent.isEndElement()) {
            EndElement nextEndElem = nextEvent.asEndElement();
            if (elem.getName().getLocalPart().equals(nextEndElem.getName().getLocalPart())) {
                return true;
            }
        }
        return false;
    }

    private String decodeByteValue(String str) {
        try {
            if (str.startsWith("x")) {
                str = str.substring(1, str.length());
                int i = Integer.parseInt(str, 16);
                char c = (char)i;
                return "" + c;
            }
            int i = Integer.parseInt(str);
            char c = (char)i;
            return "" + c;
        }
        catch (NumberFormatException ne) {
            throw new OkapiBadFilterInputException("Invalid value (" + str + " ) in byte element. ");
        }
    }

    static enum TranslationStatus {
        UNDETERMINED,
        UNFINISHED,
        OBSOLETE,
        APPROVED,
        OTHER;

    }

    static enum MessageLocation {
        RESOURCE,
        SOURCE,
        TARGET,
        NUMERUS;

    }

    static enum DocumentLocation {
        TS,
        CONTEXT,
        MESSAGE;

    }

    class TS {
        DocumentLocation currentDocumentLocation = DocumentLocation.TS;
        MessageLocation currentMessageLocation = MessageLocation.RESOURCE;
        TranslationStatus status = TranslationStatus.UNDETERMINED;
        boolean sourceExists = false;
        boolean targetExists = false;
        boolean sourceIsEmpty = true;
        boolean targetIsEmpty = true;
        String elemBeforeTrg = null;
        int numerusFormCount = 0;
        String messageId = null;
        boolean procTransComment = false;
        int obsoletes = 0;
        int approved = 0;
        int unfinished = 0;
        int other = 0;
        private IdGenerator otherId = new IdGenerator(null, "o");
        int tuId = 0;
        Stack<String> contextStack = new Stack();

        TS() {
        }

        public void resetAll() {
            this.currentDocumentLocation = DocumentLocation.TS;
            this.currentMessageLocation = MessageLocation.RESOURCE;
            this.status = TranslationStatus.UNDETERMINED;
            this.sourceExists = false;
            this.targetExists = false;
            this.elemBeforeTrg = null;
            this.sourceIsEmpty = true;
            this.targetIsEmpty = true;
            this.numerusFormCount = 0;
            this.messageId = null;
            this.obsoletes = 0;
            this.approved = 0;
            this.unfinished = 0;
            this.other = 0;
            this.otherId = new IdGenerator(null, "o");
            this.tuId = 0;
            this.contextStack.clear();
        }

        TranslationStatus getTranslationStatus() {
            return this.status;
        }

        boolean isObsolete() {
            return this.status == TranslationStatus.OBSOLETE;
        }

        boolean isUnfinished() {
            return this.status == TranslationStatus.UNFINISHED;
        }

        boolean sourceIsEmpty() {
            return this.sourceIsEmpty;
        }

        boolean sourceIsMissing() {
            return !this.sourceExists;
        }

        boolean noSource() {
            return this.sourceIsEmpty() || this.sourceIsMissing();
        }

        boolean targetIsEmpty() {
            return this.targetIsEmpty;
        }

        boolean targetIsMissing() {
            return !this.targetExists;
        }

        boolean missingSourceAndTarget() {
            return !this.sourceExists && !this.targetExists;
        }

        boolean missingSourceNotTarget() {
            return !this.sourceExists && this.targetExists;
        }

        public void reset() {
            this.status = TranslationStatus.UNDETERMINED;
            this.sourceExists = false;
            this.targetExists = false;
            this.elemBeforeTrg = null;
            this.sourceIsEmpty = true;
            this.targetIsEmpty = true;
            this.numerusFormCount = 0;
            this.messageId = null;
        }

        boolean isApproved() {
            return this.status == TranslationStatus.APPROVED;
        }

        public void analyzeMessage() {
            String validBefore = ",source,oldsource,comment,oldcomment,extracomment,translatorcomment,";
            boolean hasContent = false;
            for (XMLEvent event : TsFilter.this.eventList) {
                Characters chars;
                if (event.getEventType() == 1) {
                    StartElement startElem = event.asStartElement();
                    String startElemName = event.asStartElement().getName().getLocalPart();
                    if (startElemName.equals("source")) {
                        this.sourceExists = true;
                        hasContent = false;
                        continue;
                    }
                    if (startElemName.equals("translation")) {
                        Attribute attr = startElem.getAttributeByName(new QName("type"));
                        this.status = attr == null ? TranslationStatus.APPROVED : (attr.getValue().equals("obsolete") ? TranslationStatus.OBSOLETE : (attr.getValue().equals("unfinished") ? TranslationStatus.UNFINISHED : TranslationStatus.OTHER));
                        this.targetExists = true;
                        hasContent = false;
                        continue;
                    }
                    if (startElemName.equals("numerusform")) {
                        ++this.numerusFormCount;
                        continue;
                    }
                    if (!startElemName.equals("byte")) continue;
                    hasContent = true;
                    continue;
                }
                if (event.getEventType() == 2) {
                    EndElement endElem = event.asEndElement();
                    String endElemName = endElem.getName().getLocalPart();
                    if (endElemName.equals("source")) {
                        if (hasContent) {
                            this.sourceIsEmpty = false;
                        }
                    } else if (endElemName.equals("translation") && hasContent) {
                        this.targetIsEmpty = false;
                    }
                    if (!validBefore.contains("," + endElemName + ",")) continue;
                    this.elemBeforeTrg = endElemName;
                    continue;
                }
                if (event.getEventType() != 4 || (chars = event.asCharacters()).isWhiteSpace()) continue;
                hasContent = true;
            }
        }

        public boolean msgIsObsolete() {
            return this.status == TranslationStatus.OBSOLETE;
        }
    }
}

