/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttx;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final int MODE_AUTO = 0;
    public static final int MODE_EXISTINGSEGMENTS = 1;
    public static final int MODE_ALL = 2;
    private static final String SEGMENTMODE = "segmentMode";

    public boolean getEscapeGT() {
        return this.getBoolean("escapeGT");
    }

    public void setEscapeGT(boolean escapeGT) {
        this.setBoolean("escapeGT", escapeGT);
    }

    public int getSegmentMode() {
        return this.getInteger(SEGMENTMODE);
    }

    public void setSegmentMode(int segmentMode) {
        this.setInteger(SEGMENTMODE, segmentMode);
    }

    @Override
    public void reset() {
        super.reset();
        this.setEscapeGT(false);
        this.setSegmentMode(0);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("escapeGT", "Escape the greater-than characters in output", null);
        desc.add(SEGMENTMODE, "Extraction mode", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("TTX Filter Parameters", true, false);
        String[] values = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2)};
        String[] labels = new String[]{"Auto-detect existing segments (If found: extract only those, otherwise extract all)", "Extract only existing segments", "Extract all (existing segments and un-segmented text parts)"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(SEGMENTMODE), values);
        lsp.setChoicesLabels(labels);
        desc.addCheckboxPart(paramDesc.get("escapeGT"));
        return desc;
    }
}

