/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.versifiedtxt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class VersifiedTextWriter
implements IFilterWriter {
    private static final String VERSIFIED_ID = "[^:]*:?[^:]+:([0-9]+)$";
    private static final Pattern VERSIFIED_ID_COMPILED = Pattern.compile("[^:]*:?[^:]+:([0-9]+)$");
    private OutputStream output;
    private String outputPath;
    private OutputStreamWriter writer;
    private LocaleId language;
    private String encoding;
    private String linebreak;
    private File tempFile;
    private GenericContent formatter = new GenericContent();

    @Override
    public String getName() {
        return "VersifiedTextWriter";
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.outputPath = null;
        this.output = output;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            default: {
                event = Event.NOOP_EVENT;
            }
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output.close();
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    private void createWriter(StartDocument startDoc) {
        this.linebreak = startDoc.getLineBreak();
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("~okapi-29_vrszwTmp_", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = startDoc.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = false;
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void processStartDocument(Event event) {
        try {
            StartDocument sd = event.getStartDocument();
            this.createWriter(sd);
            this.writer.write("|b" + sd.getName() + this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing the versified text file header.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processStartSubDocument(Event event) {
        try {
            StartSubDocument ssd = (StartSubDocument)event.getResource();
            this.writer.write("|c" + ssd.getName() + this.linebreak);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing subdocument (|cName).", e);
        }
    }

    private void processTextUnit(Event event) {
        try {
            ITextUnit tu = event.getTextUnit();
            if (tu.isEmpty()) {
                return;
            }
            String verseId = tu.getId();
            Matcher m = VERSIFIED_ID_COMPILED.matcher(verseId);
            if (m.matches()) {
                verseId = m.group(1);
            }
            this.writer.write("|v" + verseId + this.linebreak);
            this.writeTextContainer(tu.getSource());
            this.writer.write(this.linebreak + "<TARGET>" + this.linebreak);
            this.writeTextContainer(tu.getTarget(this.language));
            if (tu.getTarget(this.language) == null || tu.getTarget(this.language).isEmpty()) {
                this.writer.write(this.linebreak);
            } else {
                this.writer.write(this.linebreak + this.linebreak);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing a versified text unit.", e);
        }
    }

    private boolean writeTextContainer(TextContainer tc) {
        try {
            if (tc == null) {
                return false;
            }
            String tmp = this.formatter.printSegmentedContent(tc, false, false);
            tmp = tmp.replace("\n", this.linebreak);
            this.writer.write(tmp);
            return tmp.endsWith("\n");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing TextContainer.", e);
        }
    }
}

