/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vignette;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    static final String PARTSCONFIGURATIONS = "partsConfigurations";
    static final String PARTSNAMES = "partsNames";
    static final String SOURCEID = "sourceId";
    static final String LOCALEID = "localeId";
    static final String QUOTEMODEDEFINED = "quoteModeDefined";
    static final String QUOTEMODE = "quoteMode";
    static final String MONOLINGUAL = "monolingual";
    static final String USECDATA = "useCDATA";

    public String getPartsNames() {
        return this.getString(PARTSNAMES);
    }

    public String[] getPartsNamesAsList() {
        return ListUtil.stringAsArray(this.getPartsNames());
    }

    public void setPartsNames(String partsNames) {
        this.setString(PARTSNAMES, partsNames);
    }

    public String getPartsConfigurations() {
        return this.getString(PARTSCONFIGURATIONS);
    }

    public String[] getPartsConfigurationsAsList() {
        return ListUtil.stringAsArray(this.getPartsConfigurations());
    }

    public void setPartsConfigurations(String partsConfigurations) {
        this.setString(PARTSCONFIGURATIONS, partsConfigurations);
    }

    public String getSourceId() {
        return this.getString(SOURCEID);
    }

    public void setSourceId(String sourceId) {
        this.setString(SOURCEID, sourceId);
    }

    public String getLocaleId() {
        return this.getString(LOCALEID);
    }

    public void setLocaleId(String localeId) {
        this.setString(LOCALEID, localeId);
    }

    public boolean getMonolingual() {
        return this.getBoolean(MONOLINGUAL);
    }

    public void setMonolingual(boolean monolingual) {
        this.setBoolean(MONOLINGUAL, monolingual);
    }

    public boolean getUseCDATA() {
        return this.getBoolean(USECDATA);
    }

    public void setUseCDATA(boolean useCDATA) {
        this.setBoolean(USECDATA, useCDATA);
    }

    public boolean checkData() {
        String[] tmp1 = ListUtil.stringAsArray(this.getPartsNames());
        String[] tmp2 = ListUtil.stringAsArray(this.getPartsConfigurations());
        return tmp1.length > 0 && tmp1.length == tmp2.length;
    }

    @Override
    public void reset() {
        super.reset();
        this.setPartsNames("SMCCONTENT-TITLE, SMCCONTENT-ABSTRACT, SMCCONTENT-BODY, SMCCONTENT-ALT, SMCCHANNELDESCRIPTOR-TITLE, SMCCHANNELDESCRIPTOR-ABSTRACT, SMCCHANNELDESCRIPTOR-ALT, SMCLINKCOLLECTIONS-LINKCOLLECTION-TITLE, SMCLINKCOLLECTIONS-LINKCOLLECTION-DESCRIPTION, SMCLINKS-TITLE, SMCLINKS-ABSTRACT, SMCLINKS-BODY, SMCLINKS-ALT");
        this.setPartsConfigurations("default, okf_html, okf_html, default, default, okf_html, default, default, okf_html, default, okf_html, okf_html, default");
        this.setSourceId("SOURCE_ID");
        this.setLocaleId("LOCALE_ID");
        this.setMonolingual(false);
        this.setUseCDATA(true);
    }

    @Override
    public String toString() {
        this.buffer.setBoolean(QUOTEMODEDEFINED, true);
        this.buffer.setInteger(QUOTEMODE, 0);
        return super.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PARTSNAMES, "Names of the <attribute> elements to extract", "Comma-separated list of the names of the <attribute> elements to extract.");
        desc.add(PARTSCONFIGURATIONS, "Corresponding filter configurations (or 'default')", "Comma-separated list of the filter configurations to use, use 'default' for none");
        desc.add(MONOLINGUAL, "Monolingual mode", null);
        desc.add(USECDATA, "Use CDATA", "Create CDATA sections in the output file");
        desc.add(SOURCEID, "Name for source ID element", "Name of the <attribute> element containing the source ID");
        desc.add(LOCALEID, "Name for locale ID element", "Name of the <attribute> element containing the locale ID");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Vignette Filter Parameters", true, false);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(PARTSNAMES));
        tip.setHeight(60);
        tip = desc.addTextInputPart(paramDesc.get(PARTSCONFIGURATIONS));
        tip.setHeight(60);
        desc.addCheckboxPart(paramDesc.get(USECDATA));
        CheckboxPart mono = desc.addCheckboxPart(paramDesc.get(MONOLINGUAL));
        tip = desc.addTextInputPart(paramDesc.get(SOURCEID));
        tip.setVertical(false);
        tip.setMasterPart(mono, false);
        tip = desc.addTextInputPart(paramDesc.get(LOCALEID));
        tip.setVertical(false);
        tip.setMasterPart(mono, false);
        return desc;
    }
}

