/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vignette;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.CDATAEncoder;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.vignette.Parameters;
import net.sf.okapi.filters.vignette.TemporaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@UsingParameters(value=Parameters.class)
public class VignetteFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String STARTBLOCK = "<importContentInstance>";
    private final String ENDBLOCK = "</importContentInstance>";
    private Parameters params = new Parameters();
    private String lineBreak;
    private int tuId;
    private IdGenerator subDocId;
    private int sectionIndex;
    private int otherId;
    private LinkedList<Event> queue;
    private boolean hasNext;
    private EncoderManager encoderManager;
    private BufferedReader reader;
    private SubFilter subFilter;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private DocumentBuilder docBuilder;
    private String[] partsNames;
    private String[] partsConfigurations;
    private Hashtable<String, String[]> docs;
    private String inputText;
    private int current;
    private boolean preprocessing;
    private TemporaryStore store;
    private File storeFile;
    private int counter;
    private IFilterConfigurationMapper fcMapper;
    private String currentVFullPath;
    private List<String> listOfPaths;
    private String rootId;
    private boolean monolingual;
    private IFilter filter;
    private RawDocument input;

    public VignetteFilter() {
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        try {
            this.docBuilder = Fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiException("Error creating document builder.", e);
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.store != null) {
                this.store.close();
                if (!this.preprocessing) {
                    this.store = null;
                    this.storeFile.delete();
                }
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error when closing.", e);
        }
        this.hasNext = false;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/xml", this.getClass().getName(), "Vignette Export/Import Content", "Default Vignette Export/Import Content configuration."));
        list.add(new FilterConfiguration(this.getName() + "-nocdata", "text/xml", this.getClass().getName(), "Vignette Export/Import Content (escaped HTML)", "Vignette files without CDATA sections.", "nocdata.fprm"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public String getDisplayName() {
        return "Vignette Filter";
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public String getName() {
        return "okf_vignette";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            Event event;
            if (!this.hasNext) {
                return null;
            }
            if (this.queue.size() == 0) {
                this.processBlock();
            }
            if ((event = this.queue.poll()).getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
                if (!this.preprocessing) {
                    this.generateListOfPaths();
                }
            }
            return event;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error reading the input.", e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.input = input;
        this.monolingual = this.params.getMonolingual();
        if (this.monolingual) {
            this.logger.info("- Monolingual processing");
        } else {
            this.logger.info("- Pre-processing pass");
        }
        this.partsNames = this.params.getPartsNamesAsList();
        this.partsConfigurations = this.params.getPartsConfigurationsAsList();
        if (!this.params.checkData()) {
            throw new OkapiException("Invalid parts description in the parameters.");
        }
        this.docs = new Hashtable();
        this.trgLoc = input.getTargetLocale();
        if (this.trgLoc == null) {
            throw new OkapiException("You must specify a target locale.");
        }
        this.listOfPaths = new ArrayList<String>();
        if (this.monolingual) {
            this.preprocessing = false;
            this.internalOpen(input);
            return;
        }
        this.store = new TemporaryStore();
        try {
            this.storeFile = File.createTempFile("~okapi-30_vgnflt_", null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating temporary store.", e);
        }
        this.store.create(this.storeFile);
        this.counter = 0;
        this.preprocessing = true;
        this.internalOpen(input);
        while (this.hasNext()) {
            this.next();
        }
        int toExtract = 0;
        for (String sourceId : this.docs.keySet()) {
            String[] data = this.docs.get(sourceId);
            if (Util.isEmpty(data[0])) {
                if (Util.isEmpty(data[1])) continue;
                this.logger.warn("Entry '{}': No corresponding source entry exists for the target '{}'", (Object)data[1], (Object)this.trgLoc.toPOSIXLocaleId());
                continue;
            }
            if (Util.isEmpty(data[1])) {
                this.logger.warn("Entry '{}': No entry exists for the target '{}'", (Object)data[0], (Object)this.trgLoc.toPOSIXLocaleId());
                continue;
            }
            ++toExtract;
        }
        if (toExtract <= 0) {
            this.logger.warn("There are no entries to extract");
        }
        this.logger.info("- Processing pass");
        this.preprocessing = false;
        this.internalOpen(input);
        this.store.openForRead(this.storeFile);
    }

    private void internalOpen(RawDocument input) {
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), "UTF-8");
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        String encoding = input.getEncoding();
        try {
            this.reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", encoding), e);
        }
        this.lineBreak = detector.getNewlineType().toString();
        boolean hasUTF8BOM = detector.hasUtf8Bom();
        String docName = null;
        if (input.getInputURI() != null) {
            docName = input.getInputURI().getPath();
        }
        this.readAllData();
        this.rootId = "noDocName";
        this.tuId = 0;
        this.subDocId = new IdGenerator(this.rootId, "ssd");
        this.sectionIndex = 0;
        this.otherId = 0;
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(String.valueOf(++this.otherId));
        startDoc.setName(docName);
        startDoc.setEncoding(encoding, hasUTF8BOM);
        this.srcLoc = input.getSourceLocale();
        startDoc.setLocale(this.srcLoc);
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterParameters(this.getParameters());
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType("text/xml");
        startDoc.setMimeType("text/xml");
        startDoc.setMultilingual(false);
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        this.hasNext = true;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void readAllData() {
        StringBuilder tmp = new StringBuilder();
        char[] buf = new char[2048];
        int count = 0;
        try {
            while ((count = this.reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
            this.inputText = tmp.toString().replace(this.lineBreak, "\n");
            this.current = 0;
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading the input.", e);
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing the input.", e);
                }
            }
        }
    }

    private void updateDocumentList(String sourceId, boolean isSource) {
        if (!this.docs.containsKey(sourceId)) {
            this.docs.put(sourceId, new String[2]);
        }
        String[] data = this.docs.get(sourceId);
        if (isSource) {
            data[0] = sourceId;
        } else {
            data[1] = sourceId;
        }
    }

    private void processBlock() throws SAXException, IOException {
        int start;
        do {
            if ((start = this.inputText.indexOf("<importContentInstance>", this.current)) == -1) {
                Ending ending = new Ending(String.valueOf(++this.otherId));
                ending.setSkeleton(new GenericSkeleton(this.inputText.substring(this.current).replace("\n", this.lineBreak)));
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                return;
            }
            int end = this.inputText.indexOf("</importContentInstance>", start);
            if (end == -1) {
                throw new OkapiIOException("Cannot find end of block.");
            }
            if (this.preprocessing) {
                ++this.counter;
            } else {
                DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
                dp.setSkeleton(new GenericSkeleton(this.inputText.substring(this.current, start).replace("\n", this.lineBreak)));
                this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            }
            this.current = end + "</importContentInstance>".length();
        } while (!this.processXMLBlock(start, this.current));
    }

    private boolean processXMLBlock(int start, int end) {
        boolean eventFound = false;
        try {
            String content = this.inputText.substring(start, end);
            Document doc = this.docBuilder.parse(new InputSource(new StringReader(content)));
            NodeList nodes = doc.getElementsByTagName("contentInstance");
            Element elem = (Element)nodes.item(0);
            this.currentVFullPath = elem.getAttribute("vcmLogicalPath") + "/" + elem.getAttribute("vcmName");
            if (this.monolingual) {
                if (this.processListForMonolingual(elem, content)) {
                    eventFound = true;
                }
            } else {
                if (!this.preprocessing) {
                    this.logger.info("contentInstance vcmLogicalPath={}", (Object)this.currentVFullPath);
                }
                if (this.processList(elem, content)) {
                    eventFound = true;
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException(String.format("XML parsing error in block starting at character %d.", start), e);
        }
        return eventFound;
    }

    private boolean processListForMonolingual(Element elem, String content) throws SAXException, IOException {
        String tmp = content;
        Document oriDoc = this.docBuilder.parse(new InputSource(new StringReader(tmp)));
        NodeList oriNodes = oriDoc.getElementsByTagName("contentInstance");
        elem = (Element)oriNodes.item(0);
        oriNodes = elem.getElementsByTagName("attribute");
        int last = 0;
        this.listOfPaths.add(this.currentVFullPath);
        StartSubDocument ssd = new StartSubDocument(this.subDocId.createId());
        ssd.setName(this.subDocId.toString());
        this.queue.add(new Event(EventType.START_SUBDOCUMENT, ssd));
        for (int i = 0; i < oriNodes.getLength(); ++i) {
            String data;
            int j;
            Element tmpElem = (Element)oriNodes.item(i);
            String name = tmpElem.getAttribute("name");
            boolean found = false;
            for (j = 0; j < this.partsNames.length; ++j) {
                if (!name.equals(this.partsNames[j])) continue;
                found = true;
                break;
            }
            if (!found || Util.isEmpty(data = (tmpElem = this.getFirstElement(tmpElem)).getTextContent())) continue;
            int[] pos = this.getRange(content, last, this.partsNames[j]);
            DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
            dp.setSkeleton(new GenericSkeleton(content.substring(last, pos[0]).replace("\n", this.lineBreak)));
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            last = pos[1];
            this.processContent(data, this.partsNames[j], this.partsConfigurations[j]);
        }
        Ending ending = new Ending(String.valueOf(++this.otherId));
        ending.setSkeleton(new GenericSkeleton(content.substring(last).replace("\n", this.lineBreak)));
        this.queue.add(new Event(EventType.END_SUBDOCUMENT, ending));
        return true;
    }

    private boolean processList(Element elem, String content) throws SAXException, IOException {
        String sourceId = null;
        String localeId = null;
        NodeList nodes = elem.getElementsByTagName("attribute");
        for (int i = 0; i < nodes.getLength(); ++i) {
            elem = (Element)nodes.item(i);
            String name = elem.getAttribute("name");
            if (name.equals(this.params.getLocaleId())) {
                localeId = this.getValueString(elem);
            } else if (name.equals(this.params.getSourceId())) {
                sourceId = this.getValueString(elem);
            }
            if (sourceId != null && localeId != null) break;
        }
        if (Util.isEmpty(localeId) || Util.isEmpty(sourceId)) {
            if (this.preprocessing) {
                this.logger.warn("Entry with incomplete data at {} number {}\nlocale='{}' sourceId='{}'", "<importContentInstance>", this.counter, localeId, sourceId);
                return false;
            }
            this.logger.warn("Missing data, this section is skipped.");
            DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
            dp.setSkeleton(new GenericSkeleton(content.replace("\n", this.lineBreak)));
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            return true;
        }
        if (this.preprocessing) {
            if (this.srcLoc.toPOSIXLocaleId().equals(localeId)) {
                this.updateDocumentList(sourceId, true);
                this.store.writeBlock(sourceId, content);
                return false;
            }
            if (this.trgLoc.toPOSIXLocaleId().equals(localeId)) {
                this.updateDocumentList(sourceId, false);
                return false;
            }
            return false;
        }
        boolean extract = true;
        if (this.trgLoc.toPOSIXLocaleId().equals(localeId)) {
            String[] data = this.docs.get(sourceId);
            if (data == null) {
                extract = false;
            } else if (Util.isEmpty(data[0])) {
                extract = false;
            }
        } else {
            extract = false;
        }
        this.logger.info("   LocaleId='{}', extract={}, sourceId='{}'", localeId, extract ? "Yes" : "No", sourceId);
        if (!extract) {
            DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
            dp.setSkeleton(new GenericSkeleton(content.replace("\n", this.lineBreak)));
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            return true;
        }
        String tmp = this.findOriginalInStore(sourceId);
        if (tmp == null) {
            throw new OkapiIOException(String.format("The sourceId attribute was not found ('%s').", sourceId));
        }
        Document oriDoc = this.docBuilder.parse(new InputSource(new StringReader(tmp)));
        NodeList oriNodes = oriDoc.getElementsByTagName("contentInstance");
        elem = (Element)oriNodes.item(0);
        oriNodes = elem.getElementsByTagName("attribute");
        int last = 0;
        this.listOfPaths.add(this.currentVFullPath);
        StartSubDocument ssd = new StartSubDocument(this.subDocId.createId());
        ssd.setName(sourceId);
        this.queue.add(new Event(EventType.START_SUBDOCUMENT, ssd));
        for (int i = 0; i < oriNodes.getLength(); ++i) {
            String data;
            int j;
            Element tmpElem = (Element)oriNodes.item(i);
            String name = tmpElem.getAttribute("name");
            boolean found = false;
            for (j = 0; j < this.partsNames.length; ++j) {
                if (!name.equals(this.partsNames[j])) continue;
                found = true;
                break;
            }
            if (!found || Util.isEmpty(data = (tmpElem = this.getFirstElement(tmpElem)).getTextContent())) continue;
            int[] pos = this.getRange(content, last, this.partsNames[j]);
            DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false);
            dp.setSkeleton(new GenericSkeleton(content.substring(last, pos[0]).replace("\n", this.lineBreak)));
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            last = pos[1];
            this.processContent(data, this.partsNames[j], this.partsConfigurations[j]);
        }
        Ending ending = new Ending(String.valueOf(++this.otherId));
        ending.setSkeleton(new GenericSkeleton(content.substring(last).replace("\n", this.lineBreak)));
        this.queue.add(new Event(EventType.END_SUBDOCUMENT, ending));
        return true;
    }

    private String findOriginalInStore(String sourceId) {
        boolean rewund = false;
        String stop = null;
        while (true) {
            String[] tmp;
            if ((tmp = this.store.readNext()) == null) {
                if (rewund) {
                    return null;
                }
                this.store.close();
                this.store.openForRead(this.storeFile);
                rewund = true;
                continue;
            }
            if (tmp[0].equals(sourceId)) {
                return tmp[1];
            }
            if (stop != null) {
                if (!tmp[0].equals(stop)) continue;
                return null;
            }
            stop = tmp[0];
        }
    }

    private int[] getRange(String content, int start, String partName) {
        int[] res = new int[3];
        res[0] = -1;
        String tmp = String.format("<attribute name=\"%s\">", partName);
        int n = content.indexOf(tmp, start);
        if (n == -1) {
            return res;
        }
        n = content.indexOf("<", n + 1);
        res[0] = content.indexOf(">", n) + 1;
        String name = content.substring(n + 1, res[0] - 1);
        res[1] = content.indexOf("</" + name, res[0]);
        return res;
    }

    private String getValueString(Element parent) {
        return this.getFirstElement(parent, "valueString").getTextContent();
    }

    private void processContent(String data, String partName, String partConfiguration) {
        if (partConfiguration.equals("default")) {
            TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
            tu.setSourceContent(new TextFragment(data));
            tu.setMimeType("text/xml");
            tu.setType("x-" + partName);
            this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        } else {
            this.filter = this.fcMapper.createFilter(partConfiguration, this.filter);
            IEncoder encoder = this.params.getUseCDATA() ? new CDATAEncoder("UTF-8", this.lineBreak) : new XMLEncoder("UTF-8", this.lineBreak, true, false, false, 1);
            this.subFilter = new SubFilter(this.filter, encoder, ++this.sectionIndex, partName, partName);
            RawDocument rd = new RawDocument(data, this.srcLoc);
            this.queue.addAll(this.subFilter.getEvents(rd));
            this.queue.add(this.subFilter.createRefEvent());
            rd.close();
        }
    }

    private Element getFirstElement(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagName(name);
        return (Element)nodes.item(0);
    }

    private Element getFirstElement(Element parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private void generateListOfPaths() {
        this.logger.info("\nNumber of parts to localize = {}", (Object)this.listOfPaths.size());
        for (String tmp : this.listOfPaths) {
            this.logger.info(tmp);
        }
    }
}

