/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.NSContextManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.filters.idml.IDMLSkeleton;
import net.sf.okapi.filters.idml.NodeReference;
import net.sf.okapi.lib.beans.v2.NodeReferenceBean;
import net.sf.okapi.lib.persistence.BeanMap;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class IDMLSkeletonBean
extends PersistenceBean<IDMLSkeleton> {
    private static final String LS = "LS";
    private FactoryBean original = new FactoryBean();
    private String entry;
    private String doc;
    private String topNode;
    private String scopeNode;
    private Map<String, NodeReferenceBean> refs = new HashMap<String, NodeReferenceBean>();
    private String[] movedParts;
    private CType cType;
    private boolean forced = false;

    @Override
    protected IDMLSkeleton createObject(IPersistenceSession session) {
        switch (this.cType) {
            case ZF: {
                return new IDMLSkeleton(this.original.get(ZipFile.class, session));
            }
            case ZF_ZE_D: {
                ZipFile zipFile = this.original.get(ZipFile.class, session);
                ZipEntry zipEntry = zipFile.getEntry(this.entry);
                Document document = null;
                try {
                    document = this.strToDoc(this.doc);
                }
                catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | ParserConfigurationException | SAXException e) {
                    throw new OkapiException(e);
                }
                return new IDMLSkeleton(zipFile, zipEntry, document);
            }
            case N_N: {
                Document document;
                try {
                    document = this.strToDoc(this.doc);
                }
                catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | ParserConfigurationException | SAXException e) {
                    throw new OkapiException(e);
                }
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xp = xpf.newXPath();
                try {
                    NamedNodeMap map = document.getFirstChild().getAttributes();
                    NSContextManager ctx = new NSContextManager();
                    for (int i = 0; i < map.getLength(); ++i) {
                        Node node = map.item(i);
                        ctx.add(node.getLocalName(), node.getNodeValue());
                    }
                    xp.setNamespaceContext(ctx);
                    Node tn = (Node)xp.evaluate("//" + this.topNode, document, XPathConstants.NODE);
                    Node sn = (Node)xp.evaluate("//" + this.scopeNode, document, XPathConstants.NODE);
                    return new IDMLSkeleton(tn, sn);
                }
                catch (XPathExpressionException e) {
                    throw new OkapiException(e);
                }
            }
        }
        return null;
    }

    @Override
    protected void setObject(IDMLSkeleton obj, IPersistenceSession session) {
        obj.setForced(this.forced);
        for (String id : this.refs.keySet()) {
            obj.addReferenceNode(id, this.refs.get(id).get(NodeReference.class, session));
        }
        obj.addMovedParts(this.movedParts);
    }

    private String DocToStr(Document doc) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        if (doc == null) {
            return "";
        }
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation(LS));
        LSSerializer serializer = impl.createLSSerializer();
        return serializer.writeToString(doc);
    }

    private Document strToDoc(String xml) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException, ParserConfigurationException, SAXException, IOException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation(LS));
        LSParser builder = impl.createLSParser((short)1, null);
        LSInput in = impl.createLSInput();
        in.setStringData(xml);
        return builder.parse(in);
    }

    public static String getFullXPath(Node n) {
        if (null == n) {
            return null;
        }
        Node parent = null;
        Stack<Node> hierarchy = new Stack<Node>();
        StringBuffer buffer = new StringBuffer();
        hierarchy.push(n);
        switch (n.getNodeType()) {
            case 2: {
                parent = ((Attr)n).getOwnerElement();
                break;
            }
            case 1: {
                parent = n.getParentNode();
                break;
            }
            case 9: {
                parent = n.getParentNode();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected Node type" + n.getNodeType());
            }
        }
        while (null != parent && parent.getNodeType() != 9) {
            hierarchy.push(parent);
            parent = parent.getParentNode();
        }
        Object obj = null;
        while (!hierarchy.isEmpty()) {
            Object e = hierarchy.pop();
            obj = e;
            if (null == e) break;
            Node node = obj;
            boolean handled = false;
            if (node.getNodeType() == 1) {
                Element e2 = (Element)node;
                if (buffer.length() == 0) {
                    buffer.append(node.getNodeName());
                    continue;
                }
                buffer.append("/");
                buffer.append(node.getNodeName());
                if (node.hasAttributes()) {
                    if (e2.hasAttribute("id")) {
                        buffer.append("[@id='" + e2.getAttribute("id") + "']");
                        handled = true;
                    } else if (e2.hasAttribute("name")) {
                        buffer.append("[@name='" + e2.getAttribute("name") + "']");
                        handled = true;
                    }
                }
                if (handled) continue;
                int prev_siblings = 1;
                for (Node prev_sibling = node.getPreviousSibling(); null != prev_sibling; prev_sibling = prev_sibling.getPreviousSibling()) {
                    if (prev_sibling.getNodeType() != node.getNodeType() || !prev_sibling.getNodeName().equalsIgnoreCase(node.getNodeName())) continue;
                    ++prev_siblings;
                }
                buffer.append("[" + prev_siblings + "]");
                continue;
            }
            if (node.getNodeType() != 2) continue;
            buffer.append("/@");
            buffer.append(node.getNodeName());
        }
        return buffer.toString();
    }

    @Override
    protected void fromObject(IDMLSkeleton obj, IPersistenceSession session) {
        this.cType = obj.getTopNode() != null && obj.getScopeNode() != null && obj.getTopNode().getOwnerDocument() == obj.getScopeNode().getOwnerDocument() ? CType.N_N : (obj.getOriginal() != null && obj.getEntry() != null && obj.getDocument() != null ? CType.ZF_ZE_D : CType.ZF);
        switch (this.cType) {
            case ZF: {
                this.original.set(obj.getOriginal(), session);
                break;
            }
            case ZF_ZE_D: {
                this.original.set(obj.getOriginal(), session);
                ZipEntry ze = obj.getEntry();
                if (ze != null) {
                    this.entry = ze.getName();
                }
                try {
                    this.doc = this.DocToStr(obj.getDocument());
                    break;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new OkapiException(e);
                }
            }
            case N_N: {
                this.topNode = IDMLSkeletonBean.getFullXPath(obj.getTopNode());
                this.scopeNode = IDMLSkeletonBean.getFullXPath(obj.getScopeNode());
                try {
                    this.doc = this.DocToStr(obj.getTopNode().getOwnerDocument());
                    break;
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new OkapiException(e);
                }
            }
        }
        BeanMap.set(this.refs, NodeReferenceBean.class, obj.getReferences(), session);
        this.movedParts = obj.getMovedParts();
    }

    public FactoryBean getOriginal() {
        return this.original;
    }

    public void setOriginal(FactoryBean original) {
        this.original = original;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public String getTopNode() {
        return this.topNode;
    }

    public void setTopNode(String topNode) {
        this.topNode = topNode;
    }

    public String getScopeNode() {
        return this.scopeNode;
    }

    public void setScopeNode(String scopeNode) {
        this.scopeNode = scopeNode;
    }

    public CType getCType() {
        return this.cType;
    }

    public void setCType(CType cType) {
        this.cType = cType;
    }

    public Map<String, NodeReferenceBean> getRefs() {
        return this.refs;
    }

    public void setRefs(Map<String, NodeReferenceBean> refs) {
        this.refs = refs;
    }

    public String[] getMovedParts() {
        return this.movedParts;
    }

    public void setMovedParts(String[] movedParts) {
        this.movedParts = movedParts;
    }

    private static enum CType {
        ZF,
        ZF_ZE_D,
        N_N;

    }
}

