/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v2;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.VariantSources;
import net.sf.okapi.lib.beans.v2.TextContainerBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.ReferenceBean;

public class VariantSourcesBean
extends PersistenceBean<VariantSources> {
    private Map<String, TextContainerBean> sources = new ConcurrentHashMap<String, TextContainerBean>();
    private ReferenceBean defaultSource = new ReferenceBean();

    @Override
    protected VariantSources createObject(IPersistenceSession session) {
        return new VariantSources(this.defaultSource.get(TextContainer.class, session));
    }

    @Override
    protected void setObject(VariantSources obj, IPersistenceSession session) {
        for (String locId : this.sources.keySet()) {
            TextContainerBean tcBean = this.sources.get(locId);
            obj.set(new LocaleId(locId), tcBean.get(TextContainer.class, session));
        }
    }

    @Override
    protected void fromObject(VariantSources obj, IPersistenceSession session) {
        for (LocaleId locId : obj.getLocales()) {
            TextContainerBean tcBean = new TextContainerBean();
            tcBean.set(obj.get(locId), session);
            this.sources.put(locId.toString(), tcBean);
        }
        this.defaultSource.set(obj.getDefaultSource(), session);
    }

    public final Map<String, TextContainerBean> getSources() {
        return this.sources;
    }

    public final void setSources(Map<String, TextContainerBean> sources) {
        this.sources = sources;
    }

    public final ReferenceBean getDefaultSource() {
        return this.defaultSource;
    }

    public final void setDefaultSource(ReferenceBean defaultSource) {
        this.defaultSource = defaultSource;
    }
}

