/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.persistence.IVersionDriver;

public class VersionMapper {
    private static Map<String, IVersionDriver> versionMap = new ConcurrentHashMap<String, IVersionDriver>();
    private static Map<String, String> versionIdMap = new ConcurrentHashMap<String, String>();

    public static void registerVersion(Class<? extends IVersionDriver> versionDriverClass) {
        IVersionDriver versionDriver = null;
        try {
            versionDriver = ClassUtil.instantiateClass(versionDriverClass);
        }
        catch (InstantiationException e) {
            throw new OkapiException(String.format("VersionMapper: cannot instantiate version driver %s", ClassUtil.getQualifiedClassName(versionDriverClass)));
        }
        catch (IllegalAccessException e) {
            throw new OkapiException(String.format("VersionMapper: cannot instantiate version driver %s", ClassUtil.getQualifiedClassName(versionDriverClass)));
        }
        versionMap.put(versionDriver.getVersionId(), versionDriver);
    }

    public static IVersionDriver getDriver(String versionId) {
        return versionMap.get(VersionMapper.getMapping(versionId));
    }

    public static void mapVersionId(String previousVersionId, String versionId) {
        versionIdMap.put(previousVersionId, versionId);
    }

    public static String getMapping(String versionId) {
        String vid = versionIdMap.get(versionId);
        return Util.isEmpty(vid) ? versionId : vid;
    }
}

