/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.util.Comparator;
import net.sf.okapi.lib.verification.Issue;

public class IssueComparator
implements Comparator<Issue> {
    public static final int DIR_ASC = 1;
    public static final int DIR_DESC = -1;
    public static final int TYPE_ENABLED = 0;
    public static final int TYPE_SEVERITY = 1;
    public static final int TYPE_TU = 2;
    public static final int TYPE_SEG = 3;
    public static final int TYPE_MESSAGE = 4;
    private int type = 0;
    private int direction = 1;

    public IssueComparator(int type, int direction) {
        this.type = type;
        this.direction = direction;
    }

    @Override
    public int compare(Issue issue1, Issue issue2) {
        switch (this.type) {
            case 0: {
                if (issue1.getEnabled() == issue2.getEnabled()) {
                    return 0;
                }
                if (this.direction == 1) {
                    return issue1.getEnabled() ? 1 : -1;
                }
                return issue1.getEnabled() ? -1 : 1;
            }
            case 1: {
                if (issue1.getSeverity() == issue2.getSeverity()) {
                    return 0;
                }
                if (this.direction == 1) {
                    return issue1.getSeverity() > issue2.getSeverity() ? 1 : -1;
                }
                return issue1.getSeverity() > issue2.getSeverity() ? -1 : 1;
            }
            case 2: {
                String key1 = issue1.getDocumentURI().toString() + issue1.getTuId();
                String key2 = issue2.getDocumentURI().toString() + issue2.getTuId();
                if (key1.equals(key2)) {
                    return 0;
                }
                if (this.direction == 1) {
                    return key1.compareTo(key2);
                }
                return key2.compareTo(key1);
            }
            case 3: {
                String key1 = issue1.getDocumentURI().toString() + issue1.getTuId() + (issue1.getSegId() == null ? "" : issue1.getSegId());
                String key2 = issue2.getDocumentURI().toString() + issue2.getTuId() + (issue2.getSegId() == null ? "" : issue2.getSegId());
                if (key1.equals(key2)) {
                    return 0;
                }
                if (this.direction == 1) {
                    return key1.compareTo(key2);
                }
                return key2.compareTo(key1);
            }
            case 4: {
                if (issue1.getMessage().equals(issue2.getMessage())) {
                    return 0;
                }
                if (this.direction == 1) {
                    return issue1.getMessage().compareTo(issue2.getMessage());
                }
                return issue2.getMessage().compareTo(issue1.getMessage());
            }
        }
        return 0;
    }
}

