/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.categorized;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.steps.wordcount.categorized.CategoryHandler;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;

public class CategoryResolver {
    private List<String> gmxCategories = new LinkedList<String>();
    private List<String> okapiCategories = new LinkedList<String>();
    private Map<String, Long> removedCategories = new HashMap<String, Long>();

    public CategoryResolver(List<IPipelineStep> steps) {
        for (IPipelineStep step : steps) {
            if (!(step instanceof CategoryHandler)) continue;
            CategoryHandler handler = (CategoryHandler)((Object)step);
            switch (handler.getCategoryGroup()) {
                case GMX_WORD_COUNTS: {
                    this.gmxCategories.add(handler.getMetric());
                    break;
                }
                case OKAPI_WORD_COUNTS: {
                    this.okapiCategories.add(handler.getMetric());
                }
            }
        }
    }

    public void reset() {
        this.removedCategories.clear();
    }

    public void resolve(MetricsAnnotation ma, boolean contributesInTotal) {
        if (ma == null) {
            return;
        }
        Metrics metrics = ma.getMetrics();
        LinkedList<String> m = new LinkedList<String>(metrics);
        for (String metric : m) {
            int i;
            int index = this.gmxCategories.indexOf(metric);
            if (index > -1) {
                for (i = index + 1; i < this.gmxCategories.size(); ++i) {
                    this.removeCategory(metrics, this.gmxCategories.get(i), contributesInTotal);
                }
                continue;
            }
            index = this.okapiCategories.indexOf(metric);
            if (index <= -1) continue;
            for (i = index + 1; i < this.okapiCategories.size(); ++i) {
                this.removeCategory(metrics, this.okapiCategories.get(i), contributesInTotal);
            }
        }
    }

    private void removeCategory(Metrics metrics, String name, boolean contributesInTotal) {
        long value = 0L;
        if (contributesInTotal) {
            value = Util.getValue(this.removedCategories, name, 0L);
            if ((value += metrics.getMetric(name)) == 0L) {
                this.removedCategories.remove(name);
            } else {
                this.removedCategories.put(name, value);
            }
        }
        metrics.unregisterMetric(name);
    }

    private void resolveTU(ITextUnit tu) {
        MetricsAnnotation ma = tu.getAnnotation(MetricsAnnotation.class);
        this.resolve(ma, true);
        TextContainer tc = tu.getSource();
        ma = tc.getAnnotation(MetricsAnnotation.class);
        this.resolve(ma, false);
        for (Segment seg : tc.getSegments()) {
            ma = seg.getAnnotation(MetricsAnnotation.class);
            this.resolve(ma, false);
        }
        for (LocaleId trgLoc : tu.getTargetLocales()) {
            tc = tu.getTarget(trgLoc);
            ma = tc.getAnnotation(MetricsAnnotation.class);
            this.resolve(ma, false);
            for (Segment seg : tc.getSegments()) {
                ma = seg.getAnnotation(MetricsAnnotation.class);
                this.resolve(ma, false);
            }
        }
    }

    public void resolve(IResource res, EventType eventType) {
        switch (eventType) {
            case TEXT_UNIT: {
                this.resolveTU((ITextUnit)res);
                break;
            }
            case END_BATCH_ITEM: {
                this.resolveEnding((Ending)res, false);
                break;
            }
            case END_BATCH: {
                this.resolveEnding((Ending)res, true);
                break;
            }
        }
    }

    private void resolveEnding(Ending res, boolean isEndBatch) {
        MetricsAnnotation ma = res.getAnnotation(MetricsAnnotation.class);
        if (ma != null) {
            Metrics metrics = ma.getMetrics();
            if (isEndBatch) {
                this.resolve(ma, false);
                return;
            }
            LinkedList<String> m = new LinkedList<String>(metrics);
            for (String metric : m) {
                long value = metrics.getMetric(metric);
                if ((value -= Util.getValue(this.removedCategories, metric, 0L).longValue()) <= 0L) {
                    metrics.unregisterMetric(metric);
                    continue;
                }
                metrics.setMetric(metric, value);
            }
        }
    }
}

