/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.filters.plaintext.base.Parameters;
import net.sf.okapi.lib.extra.filters.CompoundFilterParameters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GeneralTab
extends Composite
implements IDialogPage {
    private static String NONE_ID = "%%%^^^$$$nonenonenone$$$^^^%%%";
    private Group extr;
    private Group spliced;
    private Label lblSplicer;
    private Combo splicer;
    private Button codes;
    private Text custom;
    private Group regex;
    private Text edExpression;
    private Spinner edSource;
    private Label lblTextUnitExtraction;
    private Label lblSrcGroup;
    private Button line;
    private Button rule;
    private Label lblSample;
    private Composite composite_2;
    private Text edSample;
    private Text edResult;
    private Pattern fullPattern;
    private boolean busy;
    private Composite composite_3;
    private Button chkDotAll;
    private Button chkIgnoreCase;
    private Button chkMultiline;
    private Button para;
    private Label label;

    public GeneralTab(Composite parent, int style) {
        super(parent, 0);
        this.setLayout(new GridLayout(2, false));
        this.busy = true;
        this.extr = new Group(this, 0);
        this.extr.setLayout(new GridLayout(1, false));
        this.extr.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.extr.setText("Extraction mode");
        this.para = new Button(this.extr, 16);
        this.para.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.para.setText("Extract by paragraphs");
        this.line = new Button(this.extr, 16);
        this.line.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.line.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GeneralTab.this.interop(e.widget);
            }
        });
        this.line.setText("Extract by lines");
        this.rule = new Button(this.extr, 16);
        this.rule.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.rule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GeneralTab.this.interop(e.widget);
            }
        });
        this.rule.setText("Extract with a rule");
        this.spliced = new Group(this, 0);
        this.spliced.setLayout(new GridLayout(2, false));
        this.spliced.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.spliced.setText("Spliced lines");
        this.lblSplicer = new Label(this.spliced, 0);
        this.lblSplicer.setLayoutData(new GridData(131072, 0x1000000, true, false, 1, 1));
        this.lblSplicer.setAlignment(131072);
        this.lblSplicer.setText("Splicer:");
        this.splicer = new Combo(this.spliced, 0);
        this.splicer.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.splicer.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GeneralTab.this.interop(e.widget);
            }
        });
        this.splicer.setItems(new String[]{"None", "Backslash (\\)", "Underscore (_)", "Custom"});
        this.splicer.select(0);
        new Label(this.spliced, 0);
        this.custom = new Text(this.spliced, 2048);
        this.custom.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        new Label(this.spliced, 0);
        this.codes = new Button(this.spliced, 32);
        this.codes.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.codes.setText("Create inline codes for splicers");
        this.regex = new Group(this, 0);
        this.regex.setLayout(new GridLayout(1, false));
        this.regex.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.regex.setText("Extraction rule");
        this.composite_2 = new Composite(this.regex, 0);
        this.composite_2.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.composite_2.setLayout(new GridLayout(5, false));
        this.lblTextUnitExtraction = new Label(this.composite_2, 0);
        this.lblTextUnitExtraction.setAlignment(131072);
        this.lblTextUnitExtraction.setText("Regular expression:");
        this.edExpression = new Text(this.composite_2, 2048);
        this.edExpression.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                GeneralTab.this.updateResults();
            }
        });
        this.edExpression.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.label = new Label(this.composite_2, 0);
        this.label.setText("    ");
        this.lblSrcGroup = new Label(this.composite_2, 0);
        this.lblSrcGroup.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblSrcGroup.setAlignment(131072);
        this.lblSrcGroup.setText("Source group:");
        this.edSource = new Spinner(this.composite_2, 2048);
        this.edSource.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                GeneralTab.this.updateResults();
            }
        });
        new Label(this.composite_2, 0);
        this.lblSample = new Label(this.composite_2, 0);
        this.lblSample.setAlignment(131072);
        this.lblSample.setText("Sample:");
        new Label(this.composite_2, 0);
        new Label(this.composite_2, 0);
        new Label(this.composite_2, 0);
        new Label(this.composite_2, 0);
        this.edSample = new Text(this.composite_2, 2562);
        this.edSample.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                GeneralTab.this.updateResults();
            }
        });
        this.edSample.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.edSample.setText("");
        new Label(this.composite_2, 0);
        this.composite_3 = new Composite(this.composite_2, 0);
        this.composite_3.setLayoutData(new GridData(16384, 128, false, false, 2, 1));
        this.composite_3.setLayout(new GridLayout(1, false));
        this.chkDotAll = new Button(this.composite_3, 32);
        this.chkDotAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GeneralTab.this.updateResults();
            }
        });
        this.chkDotAll.setText("Dot also matches line-feed");
        this.chkDotAll.setText("Dot also matches line-feed");
        this.chkIgnoreCase = new Button(this.composite_3, 32);
        this.chkIgnoreCase.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GeneralTab.this.updateResults();
            }
        });
        this.chkIgnoreCase.setText("Ignore case difference");
        this.chkMultiline = new Button(this.composite_3, 32);
        this.chkMultiline.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                GeneralTab.this.updateResults();
            }
        });
        this.chkMultiline.setText("Multi-line");
        new Label(this.composite_2, 0);
        this.edResult = new Text(this.composite_2, 2562);
        this.edResult.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.edResult.setEditable(false);
        new Label(this.composite_2, 0);
        new Label(this.composite_2, 0);
        new Label(this.composite_2, 0);
        this.busy = false;
    }

    @Override
    protected void checkSubclass() {
    }

    private int getRegexOptions() {
        int tmp = 0;
        if (this.chkDotAll == null) {
            return 0;
        }
        if (this.chkIgnoreCase == null) {
            return 0;
        }
        if (this.chkMultiline == null) {
            return 0;
        }
        if (this.chkDotAll.getSelection()) {
            tmp |= 0x20;
        }
        if (this.chkIgnoreCase.getSelection()) {
            tmp |= 2;
        }
        if (this.chkMultiline.getSelection()) {
            tmp |= 8;
        }
        return tmp;
    }

    private void setRegexOptions(int value) {
        this.chkDotAll.setSelection((value & 0x20) == 32);
        this.chkIgnoreCase.setSelection((value & 2) == 2);
        this.chkMultiline.setSelection((value & 8) == 8);
    }

    private String getSampleText() {
        String tmp = this.edSample.getText();
        tmp = tmp.replaceAll("\r\r\n", "\n");
        tmp = tmp.replace("\r\n", "\n");
        return tmp.replace("\r", "\n");
    }

    private boolean updateResults() {
        boolean result = true;
        try {
            if (this.busy) {
                return false;
            }
            this.fullPattern = Pattern.compile(this.edExpression.getText(), this.getRegexOptions());
            int source = this.edSource.getSelection();
            Matcher m1 = this.fullPattern.matcher(this.getSampleText());
            StringBuilder tmp = new StringBuilder();
            int startSearch = 0;
            while (m1.find(startSearch) && m1.start() != m1.end()) {
                boolean hasGroup = false;
                if (tmp.length() > 0) {
                    tmp.append("-----\n");
                }
                if (source != 0) {
                    tmp.append("Source=[" + m1.group(source) + "]\n");
                    hasGroup = true;
                }
                if (!hasGroup) {
                    tmp.append("Expression=[" + m1.group() + "]\n");
                }
                startSearch = m1.end();
            }
            if (tmp.length() == 0) {
                tmp.append("<No match>");
            }
            this.edResult.setText(tmp.toString());
        }
        catch (Throwable e) {
            this.edResult.setText("Error: " + e.getMessage());
            result = false;
        }
        return result;
    }

    @Override
    public void interop(Widget speaker) {
        boolean paraMode = this.para.getSelection();
        boolean lineMode = this.line.getSelection();
        boolean ruleMode = this.rule.getSelection();
        SWTUtil.setAllEnabled(this.regex, ruleMode);
        SWTUtil.setAllEnabled(this.spliced, lineMode);
        if (this.splicer.getSelectionIndex() == 3 && lineMode) {
            this.custom.setEnabled(true);
            this.custom.setFocus();
        } else {
            this.custom.setEnabled(false);
        }
        if (lineMode) {
            if (this.splicer.getSelectionIndex() != 0) {
                this.codes.setEnabled(true);
            } else {
                this.codes.setSelection(false);
                this.codes.setEnabled(false);
            }
        }
    }

    @Override
    public boolean load(Object data) {
        if (data instanceof CompoundFilterParameters) {
            CompoundFilterParameters params = (CompoundFilterParameters)data;
            Class c = params.getParametersClass();
            if (c == net.sf.okapi.filters.plaintext.paragraphs.Parameters.class) {
                this.para.setSelection(true);
                this.line.setSelection(false);
                this.rule.setSelection(false);
            } else if (c == net.sf.okapi.filters.plaintext.spliced.Parameters.class) {
                this.para.setSelection(false);
                this.line.setSelection(true);
                this.rule.setSelection(false);
            } else if (c == net.sf.okapi.filters.plaintext.regex.Parameters.class) {
                this.para.setSelection(false);
                this.line.setSelection(false);
                this.rule.setSelection(true);
            } else {
                this.para.setSelection(false);
                this.line.setSelection(true);
                this.rule.setSelection(false);
                this.splicer.select(0);
            }
        } else if (!(data instanceof net.sf.okapi.filters.plaintext.paragraphs.Parameters)) {
            if (data instanceof net.sf.okapi.filters.plaintext.spliced.Parameters) {
                net.sf.okapi.filters.plaintext.spliced.Parameters params = (net.sf.okapi.filters.plaintext.spliced.Parameters)data;
                if (params.splicer.equals(NONE_ID)) {
                    this.splicer.select(0);
                    this.custom.setText("");
                } else if (params.splicer.equals("\\")) {
                    this.splicer.select(1);
                    this.custom.setText("");
                } else if (params.splicer.equals("_")) {
                    this.splicer.select(2);
                    this.custom.setText("");
                } else {
                    this.splicer.select(3);
                    this.custom.setText(params.splicer);
                }
                this.codes.setSelection(params.createPlaceholders);
            } else if (data instanceof net.sf.okapi.filters.plaintext.regex.Parameters) {
                net.sf.okapi.filters.plaintext.regex.Parameters params = (net.sf.okapi.filters.plaintext.regex.Parameters)data;
                this.edExpression.setText(params.rule);
                this.edSource.setSelection(params.sourceGroup);
                this.setRegexOptions(params.regexOptions);
                this.edSample.setText(params.sample);
            }
        }
        return true;
    }

    @Override
    public boolean save(Object data) {
        if (data instanceof CompoundFilterParameters) {
            CompoundFilterParameters params = (CompoundFilterParameters)data;
            if (this.para.getSelection()) {
                params.setParametersClass(net.sf.okapi.filters.plaintext.paragraphs.Parameters.class);
            } else if (this.line.getSelection() && this.splicer.getSelectionIndex() == 0) {
                params.setParametersClass(Parameters.class);
            } else if (this.line.getSelection() && this.splicer.getSelectionIndex() != 0) {
                params.setParametersClass(net.sf.okapi.filters.plaintext.spliced.Parameters.class);
            } else if (this.rule.getSelection()) {
                params.setParametersClass(net.sf.okapi.filters.plaintext.regex.Parameters.class);
            } else {
                params.setParametersClass(Parameters.class);
            }
        } else if (data instanceof net.sf.okapi.filters.plaintext.paragraphs.Parameters) {
            net.sf.okapi.filters.plaintext.paragraphs.Parameters params = (net.sf.okapi.filters.plaintext.paragraphs.Parameters)data;
            params.extractParagraphs = true;
        } else if (data instanceof net.sf.okapi.filters.plaintext.spliced.Parameters) {
            net.sf.okapi.filters.plaintext.spliced.Parameters params = (net.sf.okapi.filters.plaintext.spliced.Parameters)data;
            switch (this.splicer.getSelectionIndex()) {
                case 0: {
                    params.splicer = NONE_ID;
                    break;
                }
                case 1: {
                    params.splicer = "\\";
                    break;
                }
                case 2: {
                    params.splicer = "_";
                    break;
                }
                case 3: {
                    params.splicer = this.custom.getText();
                }
            }
            params.createPlaceholders = this.codes.getSelection();
        } else if (data instanceof net.sf.okapi.filters.plaintext.regex.Parameters) {
            net.sf.okapi.filters.plaintext.regex.Parameters params = (net.sf.okapi.filters.plaintext.regex.Parameters)data;
            params.rule = this.edExpression.getText();
            params.sourceGroup = this.edSource.getSelection();
            params.regexOptions = this.getRegexOptions();
            params.sample = this.edSample.getText();
        }
        return true;
    }

    @Override
    public boolean canClose(boolean isOK) {
        return true;
    }
}

