/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.verification;

import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StringListPanel
extends Composite {
    private Button btAdd;
    private Button btRemove;
    private Button btRemoveAll;
    private org.eclipse.swt.widgets.List lbList;

    public StringListPanel(Composite parent, int flags, String label) {
        super(parent, flags);
        this.createContent(label);
    }

    private void createContent(String label) {
        GridData gdTmp;
        GridLayout layTmp = new GridLayout(3, false);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        this.setLayout(layTmp);
        if (label != null) {
            Label stTmp = new Label(this, 0);
            stTmp.setText(label);
            gdTmp = new GridData();
            gdTmp.horizontalSpan = 3;
            stTmp.setLayoutData(gdTmp);
        }
        this.lbList = new org.eclipse.swt.widgets.List(this, 2560);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 3;
        this.lbList.setLayoutData(gdTmp);
        this.btAdd = UIUtil.createGridButton(this, 8, "Add...", 80, 1);
        this.btAdd.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                StringListPanel.this.addString();
            }
        });
        this.btRemove = UIUtil.createGridButton(this, 8, "Remove", 80, 1);
        this.btRemove.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                StringListPanel.this.removeString();
            }
        });
        this.btRemoveAll = UIUtil.createGridButton(this, 8, "Remove All", 80, 1);
        this.btRemoveAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                StringListPanel.this.lbList.removeAll();
                StringListPanel.this.updateButtons();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addString() {
        try {
            InputDialog dlg = new InputDialog(this.getShell(), "Add String", "New string to add:", "", null, 0, -1, -1);
            String tmp = dlg.showDialog();
            if (tmp == null) {
                return;
            }
            if (Arrays.asList(this.lbList.getItems()).contains(tmp)) {
                Dialogs.showError(this.getShell(), String.format("The string \"%s\" exists already in the list.", tmp), null);
                return;
            }
            this.lbList.add(tmp);
            this.lbList.setSelection(this.lbList.getItemCount() - 1);
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getLocalizedMessage(), null);
        }
        finally {
            this.updateButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeString() {
        try {
            int n = this.lbList.getSelectionIndex();
            if (n == -1) {
                return;
            }
            this.lbList.remove(n);
            if (n >= this.lbList.getItemCount()) {
                n = this.lbList.getItemCount() - 1;
            }
            if (n > -1) {
                this.lbList.setSelection(n);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.getShell(), e.getLocalizedMessage(), null);
        }
        finally {
            this.updateButtons();
        }
    }

    public void fillList(List<String> list) {
        this.lbList.removeAll();
        for (String string : list) {
            this.lbList.add(string);
        }
        if (this.lbList.getItemCount() > 0) {
            this.lbList.select(0);
        }
        this.updateButtons();
    }

    public List<String> getList() {
        return Arrays.asList(this.lbList.getItems());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    private void updateButtons() {
        this.btRemove.setEnabled(this.lbList.getItemCount() > 0);
        this.btRemoveAll.setEnabled(this.lbList.getItemCount() > 0);
    }
}

