/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.leveraging.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextAndBrowsePanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.translation.ConnectorSelectionPanel;
import net.sf.okapi.lib.ui.translation.DefaultConnectors;
import net.sf.okapi.lib.ui.translation.IConnectorList;
import net.sf.okapi.steps.leveraging.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkLeverage;
    private ConnectorSelectionPanel pnlConnector;
    private IConnectorList connectors = DefaultConnectors.getConnectors();
    private IHelp help;
    private Composite mainComposite;
    private IContext context;
    private Label stNoQueryThreshold;
    private Spinner spnNoQueryThreshold;
    private Label stThreshold;
    private Spinner spnThreshold;
    private Button chkDowngradeIBM;
    private Button chkCopySourceOnNoText;
    private Button chkFillTarget;
    private Button chkFillIfTargetIsEmpty;
    private Button chkFillIfTargetIsSameAsSource;
    private Label stFillTargetThreshold;
    private Spinner spnFillTargetThreshold;
    private Button chkMakeTMX;
    private TextAndBrowsePanel pnlTMXPath;
    private Button chkUseMTPrefix;
    private Button chkUseTargetPrefix;
    private Text edTargetPrefix;
    private Label stTargetPrefixThreshold;
    private Spinner spnTargetPrefixThreshold;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.context = context;
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.context = context;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Leveraging");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.createComposite(this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("Leveraging Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ParametersEditor.this.saveData();
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        this.setData();
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData(new GridData(1808));
        this.mainComposite.setLayout(new GridLayout(2, false));
        this.chkLeverage = new Button(this.mainComposite, 32);
        this.chkLeverage.setText("Leverage the text units");
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkLeverage.setLayoutData(gdTmp);
        this.chkLeverage.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateOptionsDisplay();
            }
        });
        this.pnlConnector = new ConnectorSelectionPanel(this.mainComposite, 0, this.connectors, this.context, null);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        this.pnlConnector.setLayoutData(gdTmp);
        this.stNoQueryThreshold = new Label(this.mainComposite, 0);
        this.stNoQueryThreshold.setText("Do not query if there is already a candidate with a score equals to or above:");
        this.spnNoQueryThreshold = new Spinner(this.mainComposite, 2048);
        this.spnNoQueryThreshold.setMinimum(0);
        this.spnNoQueryThreshold.setMaximum(101);
        this.spnNoQueryThreshold.setIncrement(1);
        this.spnNoQueryThreshold.setPageIncrement(10);
        this.stThreshold = new Label(this.mainComposite, 0);
        this.stThreshold.setText("Accept matches that are equal or above this score:");
        this.spnThreshold = new Spinner(this.mainComposite, 2048);
        this.spnThreshold.setMinimum(0);
        this.spnThreshold.setMaximum(100);
        this.spnThreshold.setIncrement(1);
        this.spnThreshold.setPageIncrement(10);
        this.chkDowngradeIBM = new Button(this.mainComposite, 32);
        this.chkDowngradeIBM.setText("Downgrade identical best exact matches");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkDowngradeIBM.setLayoutData(gdTmp);
        this.chkCopySourceOnNoText = new Button(this.mainComposite, 32);
        this.chkCopySourceOnNoText.setText("Copy the source into the target if the source content has no text");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkCopySourceOnNoText.setLayoutData(gdTmp);
        this.chkFillTarget = new Button(this.mainComposite, 32);
        this.chkFillTarget.setText("Fill the target with the best translation candidate");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkFillTarget.setLayoutData(gdTmp);
        this.chkFillTarget.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.stFillTargetThreshold.setEnabled(ParametersEditor.this.chkFillTarget.getSelection());
                ParametersEditor.this.spnFillTargetThreshold.setEnabled(ParametersEditor.this.chkFillTarget.getSelection());
                ParametersEditor.this.chkFillIfTargetIsEmpty.setEnabled(ParametersEditor.this.chkFillTarget.getSelection());
                if (ParametersEditor.this.chkFillTarget.getSelection()) {
                    ParametersEditor.this.chkFillIfTargetIsSameAsSource.setEnabled(ParametersEditor.this.chkFillIfTargetIsEmpty.getSelection());
                } else {
                    ParametersEditor.this.chkFillIfTargetIsSameAsSource.setEnabled(false);
                }
            }
        });
        this.stFillTargetThreshold = new Label(this.mainComposite, 0);
        this.stFillTargetThreshold.setText("When the best candidate is equal or above this score:");
        gdTmp = new GridData();
        int indent = 16;
        gdTmp.horizontalIndent = 16;
        this.stFillTargetThreshold.setLayoutData(gdTmp);
        this.spnFillTargetThreshold = new Spinner(this.mainComposite, 2048);
        this.spnFillTargetThreshold.setMinimum(0);
        this.spnFillTargetThreshold.setMaximum(100);
        this.spnFillTargetThreshold.setIncrement(1);
        this.spnFillTargetThreshold.setPageIncrement(10);
        this.chkFillIfTargetIsEmpty = new Button(this.mainComposite, 32);
        this.chkFillIfTargetIsEmpty.setText("Only if the target is empty");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        gdTmp.horizontalIndent = 16;
        this.chkFillIfTargetIsEmpty.setLayoutData(gdTmp);
        this.chkFillIfTargetIsEmpty.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.chkFillIfTargetIsSameAsSource.setEnabled(ParametersEditor.this.chkFillIfTargetIsEmpty.getSelection());
            }
        });
        this.chkFillIfTargetIsSameAsSource = new Button(this.mainComposite, 32);
        this.chkFillIfTargetIsSameAsSource.setText("Or if the target is the same as the source");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        gdTmp.horizontalIndent = 32;
        this.chkFillIfTargetIsSameAsSource.setLayoutData(gdTmp);
        this.chkUseTargetPrefix = new Button(this.mainComposite, 32);
        this.chkUseTargetPrefix.setText("Add this prefix to the leveraged translation");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseTargetPrefix.setLayoutData(gdTmp);
        this.chkUseTargetPrefix.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.edTargetPrefix.setEnabled(ParametersEditor.this.chkUseTargetPrefix.getSelection());
                ParametersEditor.this.stTargetPrefixThreshold.setEnabled(ParametersEditor.this.chkUseTargetPrefix.getSelection());
                ParametersEditor.this.spnTargetPrefixThreshold.setEnabled(ParametersEditor.this.chkUseTargetPrefix.getSelection());
            }
        });
        this.stTargetPrefixThreshold = new Label(this.mainComposite, 0);
        this.stTargetPrefixThreshold.setText("When the best candidate is equal or below this score:");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.stTargetPrefixThreshold.setLayoutData(gdTmp);
        this.spnTargetPrefixThreshold = new Spinner(this.mainComposite, 2048);
        this.spnTargetPrefixThreshold.setMinimum(0);
        this.spnTargetPrefixThreshold.setMaximum(100);
        this.spnTargetPrefixThreshold.setIncrement(1);
        this.spnTargetPrefixThreshold.setPageIncrement(10);
        this.edTargetPrefix = new Text(this.mainComposite, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        gdTmp.horizontalIndent = 16;
        this.edTargetPrefix.setLayoutData(gdTmp);
        this.chkMakeTMX = new Button(this.mainComposite, 32);
        this.chkMakeTMX.setText("Generate a TMX document");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkMakeTMX.setLayoutData(gdTmp);
        this.chkMakeTMX.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.pnlTMXPath.setEnabled(ParametersEditor.this.chkMakeTMX.getSelection());
                ParametersEditor.this.chkUseMTPrefix.setEnabled(ParametersEditor.this.chkMakeTMX.getSelection());
            }
        });
        this.pnlTMXPath = new TextAndBrowsePanel(this.mainComposite, 0, false);
        this.pnlTMXPath.setSaveAs(true);
        this.pnlTMXPath.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        gdTmp.horizontalIndent = 16;
        this.pnlTMXPath.setLayoutData(gdTmp);
        this.chkUseMTPrefix = new Button(this.mainComposite, 32);
        this.chkUseMTPrefix.setText("If needed, add a MT prefix to the source text");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        gdTmp.horizontalIndent = 16;
        this.chkUseMTPrefix.setLayoutData(gdTmp);
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void updateOptionsDisplay() {
        boolean enabled = this.chkLeverage.getSelection();
        this.pnlConnector.setEnabled(enabled);
        this.stNoQueryThreshold.setEnabled(enabled);
        this.spnNoQueryThreshold.setEnabled(enabled);
        this.stThreshold.setEnabled(enabled);
        this.spnThreshold.setEnabled(enabled);
        this.chkDowngradeIBM.setEnabled(enabled);
        this.chkCopySourceOnNoText.setEnabled(enabled);
        this.chkFillTarget.setEnabled(enabled);
        if (enabled) {
            this.chkFillIfTargetIsEmpty.setEnabled(this.chkFillTarget.getSelection());
            if (this.chkFillTarget.getSelection()) {
                this.chkFillIfTargetIsSameAsSource.setEnabled(this.chkFillIfTargetIsEmpty.getSelection());
            } else {
                this.chkFillIfTargetIsSameAsSource.setEnabled(false);
            }
        } else {
            this.chkFillIfTargetIsEmpty.setEnabled(false);
            this.chkFillIfTargetIsSameAsSource.setEnabled(false);
        }
        this.chkUseTargetPrefix.setEnabled(enabled);
        if (enabled) {
            this.edTargetPrefix.setEnabled(this.chkUseTargetPrefix.getSelection());
            this.stTargetPrefixThreshold.setEnabled(this.chkUseTargetPrefix.getSelection());
            this.spnTargetPrefixThreshold.setEnabled(this.chkUseTargetPrefix.getSelection());
        } else {
            this.edTargetPrefix.setEnabled(false);
            this.stTargetPrefixThreshold.setEnabled(false);
            this.spnTargetPrefixThreshold.setEnabled(false);
        }
        this.chkMakeTMX.setEnabled(enabled);
        if (enabled) {
            this.pnlTMXPath.setEnabled(this.chkMakeTMX.getSelection());
            this.chkUseMTPrefix.setEnabled(this.chkMakeTMX.getSelection());
            this.stFillTargetThreshold.setEnabled(this.chkFillTarget.getSelection());
            this.spnFillTargetThreshold.setEnabled(this.chkFillTarget.getSelection());
        } else {
            this.pnlTMXPath.setEnabled(false);
            this.chkUseMTPrefix.setEnabled(false);
            this.stFillTargetThreshold.setEnabled(false);
            this.spnFillTargetThreshold.setEnabled(false);
        }
    }

    private void setData() {
        this.chkLeverage.setSelection(this.params.getLeverage());
        this.pnlConnector.setData(this.params.getResourceClassName(), this.params.getResourceParameters());
        this.spnNoQueryThreshold.setSelection(this.params.getNoQueryThreshold());
        this.spnThreshold.setSelection(this.params.getThreshold());
        this.chkDowngradeIBM.setSelection(this.params.getDowngradeIdenticalBestMatches());
        this.chkFillTarget.setSelection(this.params.getFillTarget());
        this.chkFillIfTargetIsEmpty.setSelection(this.params.getFillIfTargetIsEmpty());
        this.chkFillIfTargetIsSameAsSource.setSelection(this.params.getFillIfTargetIsSameAsSource());
        this.spnFillTargetThreshold.setSelection(this.params.getFillTargetThreshold());
        this.chkMakeTMX.setSelection(this.params.getMakeTMX());
        this.pnlTMXPath.setText(this.params.getTMXPath());
        this.chkUseMTPrefix.setSelection(this.params.getUseMTPrefix());
        this.chkUseTargetPrefix.setSelection(this.params.getUseTargetPrefix());
        this.edTargetPrefix.setText(this.params.getTargetPrefix());
        this.spnTargetPrefixThreshold.setSelection(this.params.getTargetPrefixThreshold());
        this.chkCopySourceOnNoText.setSelection(this.params.getCopySourceOnNoText());
        this.updateOptionsDisplay();
    }

    private boolean saveData() {
        this.result = false;
        this.params.setLeverage(this.chkLeverage.getSelection());
        if (!this.chkLeverage.getSelection()) {
            this.result = true;
            return true;
        }
        if (this.chkMakeTMX.getSelection() && Util.isEmpty((String)this.pnlTMXPath.getText().trim())) {
            Dialogs.showError(this.shell, "You must provide a path for the TMX output.", null);
            return false;
        }
        if (this.chkUseTargetPrefix.getSelection() && Util.isEmpty((String)this.edTargetPrefix.getText().trim())) {
            Dialogs.showError(this.shell, "You must provide a target prefix.", null);
            return false;
        }
        this.params.setResourceClassName(this.pnlConnector.getConnectorClass());
        this.params.setResourceParameters(this.pnlConnector.getConnectorParameters());
        this.params.setNoQueryThreshold(this.spnNoQueryThreshold.getSelection());
        this.params.setThreshold(this.spnThreshold.getSelection());
        this.params.setDowngradeIdenticalBestMatches(this.chkDowngradeIBM.getSelection());
        this.params.setFillTarget(this.chkFillTarget.getSelection());
        this.params.setFillIfTargetIsEmpty(this.chkFillIfTargetIsEmpty.getSelection());
        this.params.setFillIfTargetIsSameAsSource(this.chkFillIfTargetIsSameAsSource.getSelection());
        this.params.setFillTargetThreshold(this.spnFillTargetThreshold.getSelection());
        this.params.setMakeTMX(this.chkMakeTMX.getSelection());
        this.params.setTMXPath(this.pnlTMXPath.getText());
        this.params.setUseMTPrefix(this.chkUseMTPrefix.getSelection());
        this.params.setUseTargetPrefix(this.chkUseTargetPrefix.getSelection());
        this.params.setTargetPrefix(this.edTargetPrefix.getText());
        this.params.setTargetPrefixThreshold(this.spnTargetPrefixThreshold.getSelection());
        this.params.setCopySourceOnNoText(this.chkCopySourceOnNoText.getSelection());
        this.result = true;
        return true;
    }
}

