/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.InputStream;
import java.util.zip.ZipEntry;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;

public abstract class ContentFilterBasedPartHandler
implements OpenXMLPartHandler {
    protected OpenXMLZipFile zipFile;
    protected ZipEntry entry;
    protected OpenXMLContentFilter contentFilter;
    protected ConditionalParameters cparams;

    ContentFilterBasedPartHandler(OpenXMLContentFilter contentFilter, ConditionalParameters cparams, OpenXMLZipFile zipFile, ZipEntry entry) {
        this.zipFile = zipFile;
        this.entry = entry;
        this.contentFilter = contentFilter;
        this.cparams = cparams;
    }

    @Override
    public boolean hasNext() {
        return this.contentFilter.hasNext();
    }

    @Override
    public Event next() {
        return this.contentFilter.next();
    }

    @Override
    public void close() {
        this.contentFilter.close();
    }

    protected Event openContentFilter(InputStream is, String docId, String subDocId, LocaleId srcLang) {
        this.contentFilter.open(new RawDocument(is, "UTF-8", srcLang));
        Event startDocEvent = this.contentFilter.next();
        StartSubDocument sd = new StartSubDocument(docId, subDocId);
        sd.setName(this.entry.getName());
        ConditionalParameters clonedParams = this.cparams.clone();
        clonedParams.nFileType = this.contentFilter.getParseType();
        sd.setFilterParameters(clonedParams);
        ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)startDocEvent.getStartDocument().getSkeleton(), this.zipFile.getZip(), this.entry);
        return new Event(EventType.START_SUBDOCUMENT, sd, skel);
    }

    @Override
    public void logEvent(Event e) {
        this.contentFilter.displayOneEvent(e);
    }
}

