/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Namespaces;

public class ContentTypes {
    static final QName DEFAULT = Namespaces.ContentTypes.getQName("Default");
    static final QName OVERRIDE = Namespaces.ContentTypes.getQName("Override");
    static final QName PARTNAME_ATTR = new QName("PartName");
    static final QName CONTENTTYPE_ATTR = new QName("ContentType");
    static final QName EXTENSION_ATTR = new QName("Extension");
    private XMLInputFactory factory;
    private Map<String, String> defaults = new HashMap<String, String>();
    private Map<String, String> overrides = new HashMap<String, String>();

    public ContentTypes(XMLInputFactory factory) {
        this.factory = factory;
    }

    public String getContentType(String partName) {
        if (this.overrides.containsKey(partName = this.ensureWellformedPath(partName))) {
            return this.overrides.get(partName);
        }
        String suffix = this.getSuffix(partName);
        if (this.defaults.containsKey(suffix)) {
            return this.defaults.get(suffix);
        }
        return "application/octet-stream";
    }

    public void parseFromXML(Reader reader) throws XMLStreamException {
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            Attribute type;
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement()) continue;
            StartElement el = e.asStartElement();
            if (el.getName().equals(DEFAULT)) {
                Attribute ext = el.getAttributeByName(EXTENSION_ATTR);
                type = el.getAttributeByName(CONTENTTYPE_ATTR);
                if (ext == null || type == null) continue;
                this.defaults.put(ext.getValue(), type.getValue());
                continue;
            }
            if (!el.getName().equals(OVERRIDE)) continue;
            Attribute part = el.getAttributeByName(PARTNAME_ATTR);
            type = el.getAttributeByName(CONTENTTYPE_ATTR);
            if (part == null || type == null) continue;
            this.overrides.put(this.ensureWellformedPath(part.getValue()), type.getValue());
        }
    }

    private String getSuffix(String partName) {
        String suffix = partName;
        int i = suffix.lastIndexOf(46);
        if (i != -1) {
            suffix = suffix.substring(i + 1);
        }
        return suffix;
    }

    private String ensureWellformedPath(String p) {
        return p.startsWith("/") ? p : "/" + p;
    }

    static class Types {
        private static final String PREFIX = "application/vnd.openxmlformats-officedocument.";

        Types() {
        }

        static class Excel {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
            static final String SHARED_STRINGS_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml";
            static final String WORKSHEET_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml";
            static final String WORKBOOK_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml";
            static final String COMMENT_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml";
            static final String TABLE_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml";

            Excel() {
            }
        }

        static class Powerpoint {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml";
            static final String SLIDE_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
            static final String COMMENTS_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.comments+xml";
            static final String NOTES_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml";
            static final String MASTERS_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml";
            static final String LAYOUT_TYPE = "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml";

            Powerpoint() {
            }
        }

        static class Drawing {
            static final String CHART_TYPE = "application/vnd.openxmlformats-officedocument.drawingml.chart+xml";
            static final String DIAGRAM_TYPE = "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml";

            Drawing() {
            }
        }

        static class Word {
            static final String MAIN_DOCUMENT_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml";
            static final String SETTINGS_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml";
            static final String STYLES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml";
            static final String FOOTER_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml";
            static final String ENDNOTES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml";
            static final String HEADER_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml";
            static final String FOOTNOTES_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml";
            static final String COMMENTS_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml";
            static final String GLOSSARY_TYPE = "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml";

            Word() {
            }
        }

        static class Common {
            static final String CORE_PROPERTIES_TYPE = "application/vnd.openxmlformats-package.core-properties+xml";

            Common() {
            }
        }
    }
}

