/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.SharedStringMap;

public class ExcelWorksheet {
    private XMLEventFactory eventFactory;
    private SharedStringMap stringTable;
    private Set<String> excludedColumns;
    private Set<String> excludedColors;
    private ExcelStyles styles;
    static final QName ROW = Namespaces.SpreadsheetML.getQName("row");
    static final QName CELL = Namespaces.SpreadsheetML.getQName("c");
    static final QName VALUE = Namespaces.SpreadsheetML.getQName("v");
    static final QName CELL_LOCATION = new QName("r");
    static final QName CELL_TYPE = new QName("t");
    static final QName CELL_STYLE = new QName("s");

    public ExcelWorksheet(XMLEventFactory eventFactory, SharedStringMap stringTable, ExcelStyles styles, Set<String> excludedColumns, Set<String> excludedColors) {
        this.eventFactory = eventFactory;
        this.stringTable = stringTable;
        this.styles = styles;
        this.excludedColumns = excludedColumns;
        this.excludedColors = excludedColors;
    }

    void parse(XMLEventReader reader, XMLEventWriter writer) throws IOException, XMLStreamException {
        boolean excluded = false;
        boolean inValue = false;
        boolean isSharedString = false;
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            if (e.isStartElement()) {
                StartElement el = e.asStartElement();
                if (el.getName().equals(CELL)) {
                    Attribute styleAttr;
                    Attribute typeAttr = el.getAttributeByName(CELL_TYPE);
                    if (typeAttr != null && typeAttr.getValue().equals("s")) {
                        String currentColumn = ExcelWorksheet.getLocationColumn(el.getAttributeByName(CELL_LOCATION).getValue());
                        excluded = this.excludedColumns.contains(currentColumn);
                        isSharedString = true;
                    }
                    if ((styleAttr = el.getAttributeByName(CELL_STYLE)) != null) {
                        int styleIndex = Integer.valueOf(styleAttr.getValue());
                        ExcelStyles.CellStyle style = this.styles.getCellStyle(styleIndex);
                        for (String excludedColor : this.excludedColors) {
                            if (!style.fill.matchesColor(excludedColor)) continue;
                            excluded = true;
                            break;
                        }
                    }
                } else if (el.getName().equals(VALUE)) {
                    inValue = true;
                }
            } else if (e.isEndElement()) {
                EndElement el = e.asEndElement();
                if (el.getName().equals(CELL)) {
                    excluded = false;
                    isSharedString = false;
                } else if (el.getName().equals(VALUE)) {
                    inValue = false;
                }
            } else if (e.isCharacters() && inValue && isSharedString) {
                int origIndex = ExcelWorksheet.getSharedStringIndex(e.asCharacters().getData());
                int newIndex = this.stringTable.createEntryForString(origIndex, excluded).getNewIndex();
                e = this.eventFactory.createCharacters(String.valueOf(newIndex));
            }
            writer.add(e);
        }
    }

    private static int getSharedStringIndex(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Unexpected shared string index '" + value + "'");
        }
    }

    private static String getLocationColumn(String location) {
        char[] buf = location.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (!Character.isDigit(buf[i])) continue;
            return location.substring(0, i);
        }
        throw new IllegalStateException("Unexpected worksheet cell location '" + location + "'");
    }
}

