/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Namespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphSimplifier {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private XMLEventReader xmlReader;
    private XMLEventWriter xmlWriter;
    private XMLEventFactory eventFactory;
    private ConditionalParameters params;
    private String goBackBookmarkId = null;
    static final QName ATTR_XML_SPACE = Namespaces.XML.getQName("space");
    static final QName CACHED_PAGE_BREAK = Namespaces.WordProcessingML.getQName("lastRenderedPageBreak");
    static final QName PROOFING_ERROR = Namespaces.WordProcessingML.getQName("proofErr");
    static final QName BOOKMARK_START = Namespaces.WordProcessingML.getQName("bookmarkStart");
    static final QName BOOKMARK_END = Namespaces.WordProcessingML.getQName("bookmarkEnd");
    static final QName WPML_ID = Namespaces.WordProcessingML.getQName("id");
    static final QName WPML_NAME = Namespaces.WordProcessingML.getQName("name");
    static final QName RUN_CONTENT_LANGUAGE = Namespaces.WordProcessingML.getQName("lang");
    static final QName RUN_CONTENT_SPACING = Namespaces.WordProcessingML.getQName("spacing");
    static final QName RUN_CONTENT_VERTALIGN = Namespaces.WordProcessingML.getQName("vertAlign");
    static final String LOCAL_PARA = "p";
    static final String LOCAL_RUN = "r";
    static final String LOCAL_RUNPROPS = "rPr";
    static final String LOCAL_TEXT = "t";
    static final String LOCAL_TAB = "tab";
    static final String LOCAL_LINEBREAK = "br";
    static final String LOCAL_SECTIONPROPS = "sectPr";

    public ParagraphSimplifier(XMLEventReader xmlReader, XMLEventWriter xmlWriter, XMLEventFactory eventFactory, ConditionalParameters params) {
        this.xmlReader = xmlReader;
        this.xmlWriter = xmlWriter;
        this.eventFactory = eventFactory;
        this.params = params;
    }

    public void process() throws XMLStreamException {
        while (this.xmlReader.hasNext()) {
            XMLEvent e = this.xmlReader.nextEvent();
            if (this.isBlockStartEvent(e)) {
                List<XMLEvent> blockEvents = this.processBlock(e.asStartElement(), this.xmlReader);
                this.flushEvents(blockEvents);
                continue;
            }
            if (this.isStartElement(e, LOCAL_SECTIONPROPS)) {
                e = this.stripRevisionAttrs(e.asStartElement());
            }
            this.xmlWriter.add(e);
        }
    }

    private List<XMLEvent> processBlock(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.log("startBlock: " + startEvent);
        ArrayList<XMLEvent> blockEvents = new ArrayList<XMLEvent>();
        Run previousRun = null;
        blockEvents.add(this.stripRevisionAttrs(startEvent));
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (this.isRunStartEvent(e)) {
                Run r = this.processRun(e.asStartElement(), events);
                if (previousRun != null) {
                    if (previousRun.canMerge(r)) {
                        previousRun.merge(r);
                        continue;
                    }
                    blockEvents.addAll(previousRun.getEvents());
                    previousRun = r;
                    continue;
                }
                previousRun = r;
                continue;
            }
            if (e.isStartElement() && (this.canStripParagraphElement(e.asStartElement(), events) || this.canStripBookmark(e.asStartElement(), events))) continue;
            if (previousRun != null && (e.isStartElement() || e.isEndElement())) {
                blockEvents.addAll(previousRun.getEvents());
                previousRun = null;
            }
            if (!this.isWhitespace(e)) {
                blockEvents.add(e);
            }
            if (!e.isEndElement() || !startEvent.getName().equals(e.asEndElement().getName())) continue;
            this.log("End block: " + e);
            return blockEvents;
        }
        throw new IllegalStateException("Invalid content? Unterminated paragraph");
    }

    private Run processRun(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        Run r = new Run(startEvent);
        this.log("startRun: " + startEvent);
        XMLEvent firstChild = events.nextTag();
        if (this.isRunPropsStartEvent(firstChild)) {
            this.processRunProps(r, firstChild.asStartElement(), events, false);
        } else {
            if (this.isEndElement(firstChild, startEvent)) {
                r.endRun(firstChild.asEndElement());
                this.log("endRun");
                return this.finalizeRun(r);
            }
            r.processRunBody(firstChild, events);
        }
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            this.log("processRun: " + e);
            if (this.isEndElement(e, startEvent)) {
                r.endRun(e.asEndElement());
                this.log("endRun");
                return this.finalizeRun(r);
            }
            r.processRunBody(e, events);
        }
        throw new IllegalStateException("Invalid content? Unterminated run");
    }

    private Run finalizeRun(Run r) throws XMLStreamException {
        XMLListEventReader oldRunPropEvents = new XMLListEventReader(r.runPropsEvents);
        r.runPropsEvents = new ArrayList();
        r.runPropCount = 0;
        if (oldRunPropEvents.hasNext()) {
            XMLEvent first = oldRunPropEvents.nextEvent();
            this.processRunProps(r, first.asStartElement(), oldRunPropEvents, true);
        }
        return r;
    }

    private void processRunProps(Run r, StartElement startEvent, XMLEventReader events, boolean stripUselessProperties) throws XMLStreamException {
        r.startRunProps(this.stripRevisionAttrs(startEvent));
        if (Namespaces.DrawingML.containsName(startEvent.getName())) {
            r.runPropCount += this.countAttributes(startEvent.getAttributes());
        }
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (this.isEndElement(e, startEvent)) {
                r.endRunProps(e.asEndElement());
                return;
            }
            if (e.isStartElement()) {
                if (stripUselessProperties && r.isStrippableRunPropertyElement(e.asStartElement())) {
                    this.skipElement(e.asStartElement(), events);
                    continue;
                }
                r.addRunProp(e.asStartElement(), events);
                continue;
            }
            if (!e.isCharacters() || this.isWhitespace(e)) continue;
            throw new IllegalStateException("Discarding non-whitespace rPr characters " + e.asCharacters().getData());
        }
        throw new IllegalStateException("Invalid content? Unterminated run properties");
    }

    private StartElement stripRevisionAttrs(StartElement el) {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = el.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            String localPart = a.getName().getLocalPart();
            if ("rsidR".equals(localPart) || "rsidRPr".equals(localPart) || "rsidP".equals(localPart) || "rsidRDefault".equals(localPart) || "rsidDel".equals(localPart) || "rsidSect".equals(localPart) || "err".equals(localPart)) continue;
            newAttrs.add(a);
        }
        return this.eventFactory.createStartElement(el.getName(), newAttrs.iterator(), el.getNamespaces());
    }

    private boolean isStrippableRunBodyElement(StartElement el) {
        return el.getName().equals(CACHED_PAGE_BREAK);
    }

    private boolean canStripParagraphElement(StartElement el, XMLEventReader events) throws XMLStreamException {
        if (el.getName().equals(PROOFING_ERROR)) {
            this.skipElement(el, events);
            return true;
        }
        return false;
    }

    private boolean canStripBookmark(StartElement el, XMLEventReader events) throws XMLStreamException {
        if (el.getName().equals(BOOKMARK_START) && "_GoBack".equals(this.getAttr(el, WPML_NAME))) {
            this.goBackBookmarkId = this.getAttr(el, WPML_ID);
            this.skipElement(el, events);
            return true;
        }
        if (el.getName().equals(BOOKMARK_END) && Objects.equals(this.goBackBookmarkId, this.getAttr(el, WPML_ID))) {
            this.skipElement(el, events);
            return true;
        }
        return false;
    }

    private void skipElement(StartElement el, XMLEventReader events) throws XMLStreamException {
        QName name = el.getName();
        while (events.hasNext()) {
            XMLEvent e = events.nextTag();
            if (!e.isEndElement() || !e.asEndElement().getName().equals(name)) continue;
            return;
        }
        throw new IllegalStateException("Unterminated element " + el + " at " + el.getLocation());
    }

    private void flushEvents(List<XMLEvent> events) throws XMLStreamException {
        for (XMLEvent e : events) {
            try {
                this.xmlWriter.add(e);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean isBlockStartEvent(XMLEvent e) {
        return this.isStartElement(e, LOCAL_PARA);
    }

    private boolean isRunStartEvent(XMLEvent e) {
        return this.isStartElement(e, LOCAL_RUN);
    }

    private boolean isRunPropsStartEvent(XMLEvent e) {
        return this.isStartElement(e, LOCAL_RUNPROPS);
    }

    private boolean isTextStartEvent(XMLEvent e) {
        return this.isStartElement(e, LOCAL_TEXT);
    }

    private boolean isTabStartEvent(XMLEvent e) {
        return this.isStartElement(e, LOCAL_TAB);
    }

    private boolean isLineBreakStartEvent(XMLEvent e) {
        return this.isStartElement(e, LOCAL_LINEBREAK);
    }

    private boolean isStartElement(XMLEvent e, String expectedLocalPart) {
        return e.isStartElement() ? expectedLocalPart.equals(e.asStartElement().getName().getLocalPart()) : false;
    }

    private boolean isEndElement(XMLEvent e, StartElement correspondingStartElement) {
        return e.isEndElement() ? e.asEndElement().getName().equals(correspondingStartElement.getName()) : false;
    }

    private boolean hasPreserveWhitespace(StartElement e) {
        return "preserve".equals(this.getAttr(e, ATTR_XML_SPACE));
    }

    private boolean isWhitespace(XMLEvent e) {
        return e.isCharacters() && e.asCharacters().getData().trim().isEmpty();
    }

    private int countAttributes(Iterator<?> attrs) {
        int i = 0;
        while (attrs.hasNext()) {
            attrs.next();
            ++i;
        }
        return i;
    }

    private String getAttr(StartElement el, QName name) {
        Attribute attr = el.getAttributeByName(name);
        return attr != null ? attr.getValue() : null;
    }

    private boolean eventEquals(XMLEvent e1, XMLEvent e2) {
        if (e1.getEventType() != e2.getEventType()) {
            return false;
        }
        switch (e1.getEventType()) {
            case 1: {
                return this.startElementEquals(e1.asStartElement(), e2.asStartElement());
            }
            case 2: {
                return e1.asEndElement().getName().equals(e2.asEndElement().getName());
            }
            case 4: {
                return e1.asCharacters().getData().equals(e2.asCharacters().getData());
            }
        }
        return true;
    }

    private boolean startElementEquals(StartElement e1, StartElement e2) {
        return e1.getName().equals(e2.getName()) && this.attrEquals(e1, e2);
    }

    private boolean attrEquals(StartElement e1, StartElement e2) {
        List<Attribute> a1 = this.attributesToList(e1);
        List<Attribute> a2 = this.attributesToList(e2);
        if (a1.size() != a2.size()) {
            return false;
        }
        for (Attribute a : a1) {
            boolean foundMatch = false;
            for (Attribute test : a2) {
                if (!this.attrEquals(a, test)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    private List<Attribute> attributesToList(StartElement el) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = el.getAttributes();
        while (it.hasNext()) {
            attrs.add(it.next());
        }
        return attrs;
    }

    private boolean attrEquals(Attribute a1, Attribute a2) {
        return Objects.equals(a1.getName(), a2.getName()) && Objects.equals(a1.getValue(), a2.getValue());
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }

    class XMLListEventReader
    implements XMLEventReader {
        private Iterator<XMLEvent> events;

        XMLListEventReader(Iterable<XMLEvent> events) {
            this.events = events.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.events.hasNext();
        }

        @Override
        public XMLEvent nextEvent() {
            return this.events.next();
        }

        @Override
        public void remove() {
            this.events.remove();
        }

        @Override
        public XMLEvent nextTag() throws XMLStreamException {
            XMLEvent e = this.nextEvent();
            while (e != null) {
                if (e.isStartElement() || e.isEndElement()) {
                    return e;
                }
                if (!ParagraphSimplifier.this.isWhitespace(e)) {
                    throw new IllegalStateException("Unexpected event: " + e);
                }
                e = this.nextEvent();
            }
            return null;
        }

        @Override
        public XMLEvent peek() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getElementText() throws XMLStreamException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws XMLStreamException {
        }

        @Override
        public Object next() {
            return this.events.next();
        }
    }

    class Run {
        private StartElement startEvent;
        private EndElement endEvent;
        private List<XMLEvent> runPropsEvents = new ArrayList<XMLEvent>();
        private List<XMLEvent> runBodyEvents = new ArrayList<XMLEvent>();
        private QName textName = null;
        private boolean isTextPreservingWhitespace = false;
        private StringBuilder textContent = new StringBuilder();
        private boolean hadAnyText = false;
        private boolean hadNonWhitespaceText = false;
        private int runPropCount = 0;

        public Run(StartElement startEvent) {
            this.startEvent = ParagraphSimplifier.this.stripRevisionAttrs(startEvent);
        }

        public boolean canMerge(Run otherRun) {
            if (Namespaces.Math.containsName(this.startEvent.getName())) {
                return false;
            }
            if (this.runPropCount == 0 && otherRun.runPropCount == 0) {
                return true;
            }
            if (this.runPropsEvents.size() != otherRun.runPropsEvents.size()) {
                return false;
            }
            for (int i = 0; i < this.runPropsEvents.size(); ++i) {
                if (ParagraphSimplifier.this.eventEquals(this.runPropsEvents.get(i), otherRun.runPropsEvents.get(i))) continue;
                return false;
            }
            return true;
        }

        public boolean isStrippableRunPropertyElement(StartElement el) {
            if (el.getName().equals(RUN_CONTENT_LANGUAGE)) {
                return true;
            }
            if (ParagraphSimplifier.this.params.getCleanupAggressively()) {
                if (el.getName().equals(RUN_CONTENT_SPACING)) {
                    return true;
                }
                if (el.getName().equals(RUN_CONTENT_VERTALIGN) && !this.hadNonWhitespaceText) {
                    return true;
                }
            }
            return false;
        }

        public void merge(Run other) throws XMLStreamException {
            ArrayList<XMLEvent> newBodyEvents = new ArrayList<XMLEvent>(this.runBodyEvents);
            this.isTextPreservingWhitespace = this.isTextPreservingWhitespace ? true : other.isTextPreservingWhitespace;
            newBodyEvents.addAll(other.runBodyEvents);
            this.runBodyEvents.clear();
            XMLListEventReader events = new XMLListEventReader(newBodyEvents);
            while (events.hasNext()) {
                this.addRunBody(events.nextEvent(), events);
            }
            this.flushText();
        }

        public void startRunProps(StartElement e) {
            this.runPropsEvents.add(e);
        }

        public void addRunProp(StartElement startEl, XMLEventReader events) throws XMLStreamException {
            this.runPropsEvents.add(startEl);
            ++this.runPropCount;
            while (events.hasNext()) {
                XMLEvent e = events.nextEvent();
                this.runPropsEvents.add(e);
                if (!ParagraphSimplifier.this.isEndElement(e, startEl)) continue;
                return;
            }
        }

        public void endRunProps(EndElement e) {
            this.runPropsEvents.add(e);
        }

        public void processRunBody(XMLEvent e, XMLEventReader events) throws XMLStreamException {
            if (ParagraphSimplifier.this.isBlockStartEvent(e)) {
                ParagraphSimplifier.this.log("Nested block start event: " + e);
                this.flushText();
                ParagraphSimplifier nested = new ParagraphSimplifier(ParagraphSimplifier.this.xmlReader, ParagraphSimplifier.this.xmlWriter, ParagraphSimplifier.this.eventFactory, ParagraphSimplifier.this.params);
                List nestedEvents = nested.processBlock(e.asStartElement(), events);
                this.runBodyEvents.addAll(nestedEvents);
            } else {
                this.addRunBody(e, ParagraphSimplifier.this.xmlReader);
            }
        }

        public void addRunBody(XMLEvent e, XMLEventReader events) throws XMLStreamException {
            if (ParagraphSimplifier.this.isTextStartEvent(e)) {
                this.processText(e.asStartElement(), events);
            } else if (ParagraphSimplifier.this.isTabStartEvent(e) && ParagraphSimplifier.this.params.getAddTabAsCharacter()) {
                this.addRawText("\t", e.asStartElement(), events);
            } else if (ParagraphSimplifier.this.isLineBreakStartEvent(e) && ParagraphSimplifier.this.params.getAddLineSeparatorCharacter()) {
                this.addRawText("\n", e.asStartElement(), events);
            } else if (e.isStartElement() && ParagraphSimplifier.this.isStrippableRunBodyElement(e.asStartElement())) {
                ParagraphSimplifier.this.skipElement(e.asStartElement(), events);
            } else if (!ParagraphSimplifier.this.isWhitespace(e) || this.inPreservingWhitespaceElement()) {
                this.flushText();
                this.isTextPreservingWhitespace = false;
                this.runBodyEvents.add(e);
            }
        }

        private boolean inPreservingWhitespaceElement() {
            for (int i = this.runBodyEvents.size() - 1; i >= 0; --i) {
                if (!this.runBodyEvents.get(i).isStartElement()) continue;
                return ParagraphSimplifier.this.hasPreserveWhitespace((StartElement)this.runBodyEvents.get(i));
            }
            return false;
        }

        private void processText(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
            this.hadAnyText = true;
            boolean bl = this.isTextPreservingWhitespace = this.isTextPreservingWhitespace ? true : ParagraphSimplifier.this.hasPreserveWhitespace(startEvent);
            if (this.textName == null) {
                this.textName = startEvent.getName();
            }
            while (events.hasNext()) {
                XMLEvent e = events.nextEvent();
                if (ParagraphSimplifier.this.isEndElement(e, startEvent)) {
                    return;
                }
                if (!e.isCharacters()) continue;
                String text = e.asCharacters().getData();
                if (text.trim().length() > 0) {
                    this.hadNonWhitespaceText = true;
                }
                this.textContent.append(text);
            }
        }

        private void flushText() {
            if (this.hadAnyText) {
                XMLEvent start = this.createTextStart();
                this.runBodyEvents.add(start);
                this.runBodyEvents.add(ParagraphSimplifier.this.eventFactory.createCharacters(this.textContent.toString()));
                this.runBodyEvents.add(ParagraphSimplifier.this.eventFactory.createEndElement(this.textName, null));
                this.textContent.setLength(0);
                this.hadAnyText = false;
            }
        }

        private XMLEvent createTextStart() {
            return ParagraphSimplifier.this.eventFactory.createStartElement(this.textName, this.isTextPreservingWhitespace ? Collections.singleton(ParagraphSimplifier.this.eventFactory.createAttribute("xml", Namespaces.XML.getURI(), "space", "preserve")).iterator() : null, null);
        }

        public void endRun(EndElement e) {
            this.flushText();
            this.endEvent = e;
        }

        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.startEvent);
            events.addAll(this.runPropsEvents);
            events.addAll(this.runBodyEvents);
            events.add(this.endEvent);
            return events;
        }

        private void addRawText(String text, StartElement startEl, XMLEventReader events) throws XMLStreamException {
            this.hadAnyText = true;
            this.textContent.append(text);
            ParagraphSimplifier.this.skipElement(startEl, events);
            if (this.textName == null) {
                this.textName = new QName(startEl.getName().getNamespaceURI(), ParagraphSimplifier.LOCAL_TEXT);
            }
        }
    }
}

