/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

public class WordDocument
extends DocumentType {
    public WordDocument(OpenXMLZipFile zipFile, ConditionalParameters params) {
        super(zipFile, params);
    }

    @Override
    public ParseType getDefaultParseType() {
        return ParseType.MSWORD;
    }

    @Override
    public void initialize() throws IOException, XMLStreamException {
    }

    @Override
    public OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType, boolean squishable) {
        if (!this.isTranslatableType(entry.getName(), contentType)) {
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getZipFile().getFactories(), this.getParams());
        openXMLContentFilter.setPartName(entry.getName());
        ParseType parseType = ParseType.MSWORD;
        boolean shouldSquishPart = false;
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml".equals(contentType)) {
            openXMLContentFilter.setBInMainFile(true);
            parseType = squishable ? ParseType.MSWORD : ParseType.MSWORDDOCPROPERTIES;
            shouldSquishPart = squishable;
        } else if ("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml".equals(contentType)) {
            openXMLContentFilter.setBInSettingsFile(true);
        } else if ("application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(contentType)) {
            parseType = ParseType.MSWORDCHART;
        } else if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        openXMLContentFilter.setUpConfig(parseType);
        if (!this.getParams().getTranslateWordHidden() || !this.getParams().getTranslateWordAllStyles()) {
            openXMLContentFilter.setTsExcludeWordStyles(this.getParams().tsExcludeWordStyles);
        }
        return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry, shouldSquishPart);
    }

    private boolean isTranslatableType(String entryName, String type) {
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml")) {
            return true;
        }
        if (this.getParams().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (this.getParams().getTranslateWordHeadersFooters() && (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml"))) {
            return true;
        }
        if (this.getParams().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml");
    }

    @Override
    public Enumeration<? extends ZipEntry> getZipFileEntries() {
        ArrayList<? extends ZipEntry> list = Collections.list(this.getZipFile().entries());
        ArrayList<String> additionalParts = new ArrayList<String>();
        additionalParts.add("word/styles.xml");
        additionalParts.add("word/_rels/document.xml.rels");
        additionalParts.add("word/document.xml");
        Collections.sort(list, new ZipEntryComparator(additionalParts));
        return Collections.enumeration(list);
    }
}

