/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.NSContextManager;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.lib.segmentation.CompiledRule;
import net.sf.okapi.lib.segmentation.ICURegex;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXSegmenter;
import net.sf.okapi.lib.segmentation.SegmentationRuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SRXDocument {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String NSURI_SRX20 = "http://www.lisa.org/srx20";
    private static final String NSURI_SRX10 = "http://www.lisa.org/srx10";
    private static final String NSURI_OKPSRX = "http://okapi.sf.net/srx-extensions";
    private static final String NSPREFIX_OKPSRX = "okpsrx";
    public static final String INLINECODE_PATTERN = String.format("([\\u%X\\u%X\\u%X].)", 57601, 57602, 57603);
    public static final String ANYCODE = "\\Y";
    public static final String NOAUTO = "[noauto]";
    private static final String AUTO_INLINECODES = "(" + INLINECODE_PATTERN + "*)";
    private boolean cascade;
    private boolean segmentSubFlows;
    private boolean includeStartCodes;
    private boolean includeEndCodes;
    private boolean includeIsolatedCodes;
    private boolean oneSegmentIncludesAll;
    private boolean trimLeadingWS;
    private boolean trimTrailingWS;
    private boolean useJavaRegex = true;
    private boolean treatIsolatedCodesAsWhitespace;
    private String version = "2.0";
    private String warning;
    private String sampleText;
    private String sampleLanguage;
    private boolean modified;
    private boolean testOnSelectedGroup;
    private ArrayList<LanguageMap> langMaps;
    private LinkedHashMap<String, ArrayList<Rule>> langRules;
    private String maskRule;
    private String docComment;
    private String headerComment;
    private ICURegex icuRegex;

    public SRXDocument() {
        this.resetAll();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasWarning() {
        return this.warning != null && this.warning.length() > 0;
    }

    public String getWarning() {
        if (this.warning == null) {
            return "";
        }
        return this.warning;
    }

    public String getHeaderComments() {
        return this.headerComment;
    }

    public void setHeaderComments(String text) {
        this.headerComment = text;
        if (this.headerComment != null && this.headerComment.length() == 0) {
            this.headerComment = null;
        }
    }

    public String getComments() {
        return this.docComment;
    }

    public void setComments(String text) {
        this.docComment = text;
        if (this.docComment != null && this.docComment.length() == 0) {
            this.docComment = null;
        }
    }

    public void resetAll() {
        this.langMaps = new ArrayList();
        this.langRules = new LinkedHashMap();
        this.maskRule = null;
        this.modified = false;
        this.segmentSubFlows = true;
        this.cascade = false;
        this.includeStartCodes = false;
        this.includeEndCodes = true;
        this.includeIsolatedCodes = false;
        this.oneSegmentIncludesAll = false;
        this.trimLeadingWS = false;
        this.trimTrailingWS = false;
        this.useJavaRegex = true;
        this.treatIsolatedCodesAsWhitespace = false;
        this.sampleText = "Mr. Holmes is from the U.K. not the U.S. <B>Is Dr. Watson from there too?</B> Yes: both are.<BR/>";
        this.sampleLanguage = "en";
        this.headerComment = null;
        this.docComment = null;
    }

    public LinkedHashMap<String, ArrayList<Rule>> getAllLanguageRules() {
        return this.langRules;
    }

    public ArrayList<Rule> getLanguageRules(String ruleName) {
        return this.langRules.get(ruleName);
    }

    public ArrayList<LanguageMap> getAllLanguagesMaps() {
        return this.langMaps;
    }

    public boolean segmentSubFlows() {
        return this.segmentSubFlows;
    }

    public void setSegmentSubFlows(boolean value) {
        this.segmentSubFlows = value;
    }

    public boolean cascade() {
        return this.cascade;
    }

    public void setCascade(boolean value) {
        if (value != this.cascade) {
            this.cascade = value;
            this.modified = true;
        }
    }

    public boolean oneSegmentIncludesAll() {
        return this.oneSegmentIncludesAll;
    }

    public void setOneSegmentIncludesAll(boolean value) {
        if (value != this.oneSegmentIncludesAll) {
            this.oneSegmentIncludesAll = value;
            this.modified = true;
        }
    }

    public boolean useJavaRegex() {
        return this.useJavaRegex;
    }

    public void setUseJavaRegex(boolean value) {
        if (value != this.useJavaRegex) {
            this.useJavaRegex = value;
            this.modified = true;
        }
        if (!this.useJavaRegex) {
            this.LOGGER.warn("Use of ICU regex is deprecated and may be removed in the future.");
        }
    }

    public boolean treatIsolatedCodesAsWhitespace() {
        return this.treatIsolatedCodesAsWhitespace;
    }

    public void setTreatIsolatedCodesAsWhitespace(boolean value) {
        if (value != this.treatIsolatedCodesAsWhitespace) {
            this.treatIsolatedCodesAsWhitespace = value;
            this.modified = true;
        }
    }

    public boolean trimLeadingWhitespaces() {
        return this.trimLeadingWS;
    }

    public void setTrimLeadingWhitespaces(boolean value) {
        if (value != this.trimLeadingWS) {
            this.trimLeadingWS = value;
            this.modified = true;
        }
    }

    public boolean trimTrailingWhitespaces() {
        return this.trimTrailingWS;
    }

    public void setTrimTrailingWhitespaces(boolean value) {
        if (value != this.trimTrailingWS) {
            this.trimTrailingWS = value;
            this.modified = true;
        }
    }

    public boolean includeStartCodes() {
        return this.includeStartCodes;
    }

    public void setIncludeStartCodes(boolean value) {
        if (value != this.includeStartCodes) {
            this.includeStartCodes = value;
            this.modified = true;
        }
    }

    public boolean includeEndCodes() {
        return this.includeEndCodes;
    }

    public void setIncludeEndCodes(boolean value) {
        if (value != this.includeEndCodes) {
            this.includeEndCodes = value;
            this.modified = true;
        }
    }

    public boolean includeIsolatedCodes() {
        return this.includeIsolatedCodes;
    }

    public void setIncludeIsolatedCodes(boolean value) {
        if (value != this.includeIsolatedCodes) {
            this.includeIsolatedCodes = value;
            this.modified = true;
        }
    }

    public String getMaskRule() {
        return this.maskRule;
    }

    public void setMaskRule(String pattern) {
        if (pattern != null) {
            if (!pattern.equals(this.maskRule)) {
                this.modified = true;
            }
        } else if (this.maskRule != null) {
            this.modified = true;
        }
        this.maskRule = pattern;
    }

    public String getSampleText() {
        if (this.sampleText == null) {
            return "";
        }
        return this.sampleText;
    }

    public void setSampleText(String value) {
        if (value != null) {
            if (!value.equals(this.sampleText)) {
                this.modified = true;
            }
        } else if (this.sampleText != null) {
            this.modified = true;
        }
        this.sampleText = value;
    }

    public String getSampleLanguage() {
        return this.sampleLanguage;
    }

    public void setSampleLanguage(String value) {
        if (value == null || value.length() == 0) {
            this.sampleLanguage = "en";
            this.modified = true;
        } else if (!value.equals(this.sampleLanguage)) {
            this.sampleLanguage = value;
            this.modified = true;
        }
    }

    public boolean testOnSelectedGroup() {
        return this.testOnSelectedGroup;
    }

    public void setTestOnSelectedGroup(boolean value) {
        if (value != this.testOnSelectedGroup) {
            this.testOnSelectedGroup = value;
            this.modified = true;
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean value) {
        this.modified = value;
    }

    public void addLanguageRule(String name, ArrayList<Rule> langRule) {
        this.langRules.put(name, langRule);
        this.modified = true;
    }

    public void addLanguageMap(LanguageMap langMap) {
        this.langMaps.add(langMap);
        this.modified = true;
    }

    public ISegmenter compileLanguageRules(LocaleId languageCode, ISegmenter existingSegmenter) {
        SRXSegmenter segmenter = null;
        if (existingSegmenter != null && existingSegmenter instanceof SRXSegmenter) {
            segmenter = (SRXSegmenter)existingSegmenter;
        }
        if (segmenter != null) {
            if (languageCode != null && languageCode.equals(segmenter.getLanguage()) && this.cascade == segmenter.cascade()) {
                return segmenter;
            }
            segmenter.reset();
        } else {
            segmenter = new SRXSegmenter();
        }
        this.icuRegex = segmenter.getICURegex();
        segmenter.setCascade(this.cascade);
        segmenter.setOptions(this.segmentSubFlows, this.includeStartCodes, this.includeEndCodes, this.includeIsolatedCodes, this.oneSegmentIncludesAll, this.trimLeadingWS, this.trimTrailingWS, this.useJavaRegex, this.treatIsolatedCodesAsWhitespace);
        for (LanguageMap langMap : this.langMaps) {
            if (!Pattern.matches(langMap.pattern, languageCode.toString())) continue;
            this.compileRules(segmenter, langMap.ruleName);
            if (segmenter.cascade()) continue;
            break;
        }
        segmenter.setLanguage(languageCode);
        return segmenter;
    }

    public ISegmenter compileSingleLanguageRule(String ruleName, ISegmenter existingSegmenter) {
        SRXSegmenter segmenter = null;
        if (existingSegmenter != null && existingSegmenter instanceof SRXSegmenter) {
            segmenter = (SRXSegmenter)existingSegmenter;
        }
        if (segmenter != null) {
            if (ruleName != null && segmenter.getLanguage().equals(LocaleId.EMPTY)) {
                return segmenter;
            }
            segmenter.reset();
        } else {
            segmenter = new SRXSegmenter();
        }
        this.icuRegex = segmenter.getICURegex();
        segmenter.setOptions(this.segmentSubFlows, this.includeStartCodes, this.includeEndCodes, this.includeIsolatedCodes, this.oneSegmentIncludesAll, this.trimLeadingWS, this.trimTrailingWS, this.useJavaRegex, this.treatIsolatedCodesAsWhitespace);
        this.compileRules(segmenter, ruleName);
        segmenter.setLanguage(LocaleId.EMPTY);
        return segmenter;
    }

    private void compileRules(SRXSegmenter segmenter, String ruleName) {
        if (!this.langRules.containsKey(ruleName)) {
            throw new SegmentationRuleException("language rule '" + ruleName + "' not found.");
        }
        ArrayList<Rule> langRule = this.langRules.get(ruleName);
        for (Rule rule : langRule) {
            String pattern;
            if (!rule.isActive) continue;
            if (this.useJavaRegex) {
                pattern = this.generateRuleRegex(rule, false);
                pattern = pattern.replace(ANYCODE, INLINECODE_PATTERN);
            } else {
                boolean hasICURules;
                boolean bl = hasICURules = this.icuRegex != null && (ICURegex.isICURule(rule.before) || ICURegex.isICURule(rule.after));
                if (hasICURules) {
                    this.icuRegex.setHasICURules(true);
                }
                pattern = this.generateRuleRegex(rule, hasICURules);
                pattern = pattern.replace(ANYCODE, INLINECODE_PATTERN);
                pattern = RegexUtil.updateGroupReferences(pattern, 1);
                if (hasICURules) {
                    pattern = this.icuRegex.processRule(pattern);
                }
            }
            segmenter.addRule(new CompiledRule(pattern, rule.isBreak));
        }
        segmenter.setMaskRule(this.maskRule);
    }

    private String generateRuleRegex(Rule rule, boolean hasICURules) {
        String pattern = "";
        String beforePattern = "";
        String afterPattern = "";
        if (this.useJavaRegex) {
            afterPattern = "(" + rule.after + ")";
            beforePattern = rule.before.endsWith(NOAUTO) ? "(" + rule.before.substring(0, rule.before.length() - NOAUTO.length()) + ")" : "(" + rule.before + AUTO_INLINECODES + ")";
        } else if (rule.before.endsWith(NOAUTO)) {
            beforePattern = "(" + this.WrapBeforePart(rule.before.substring(0, rule.before.length() - NOAUTO.length()), hasICURules) + ")";
            afterPattern = "(" + this.WrapAfterPart(rule.after, hasICURules) + ")";
        } else {
            beforePattern = "(" + this.WrapBeforePart(rule.before, hasICURules) + AUTO_INLINECODES + ")";
            afterPattern = "(" + this.WrapAfterPart(rule.after, hasICURules) + ")";
        }
        pattern = rule.before.isEmpty() ? "(.|\n)" + afterPattern : (rule.after.isEmpty() ? beforePattern + "()" : beforePattern + afterPattern);
        return pattern;
    }

    private String WrapBeforePart(String before, boolean addPlaceholders) {
        return addPlaceholders ? '\ue013' + before + '\ue014' : before;
    }

    private String WrapAfterPart(String after, boolean addPlaceholders) {
        return addPlaceholders ? '\ue015' + after + '\ue016' : after;
    }

    public void loadRules(CharSequence data) {
        this.loadRules(data, 1);
        this.modified = true;
    }

    public void loadRules(String pathOrURL) {
        this.loadRules(pathOrURL, 0);
    }

    public void loadRules(InputStream inputStream) {
        this.loadRules(inputStream, 2);
    }

    private void loadRules(Object input, int inputType) {
        try {
            Element elem3;
            int i;
            Document doc;
            DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
            Fact.setValidating(false);
            Fact.setNamespaceAware(true);
            DocumentBuilder docBuilder = Fact.newDocumentBuilder();
            docBuilder.setEntityResolver(new DefaultEntityResolver());
            if (inputType == 0) {
                String pathOrURL = (String)input;
                File srxFile = new File(Util.toURI(pathOrURL));
                if (!srxFile.exists()) {
                    throw new OkapiException("SRX file not found");
                }
                doc = docBuilder.parse(srxFile);
            } else if (inputType == 1) {
                CharSequence data = (CharSequence)input;
                doc = docBuilder.parse(new InputSource(new StringReader(data.toString())));
            } else {
                doc = docBuilder.parse((InputStream)input);
            }
            this.resetAll();
            XPathFactory xpathFac = Util.createXPathFactory();
            XPath xpath = xpathFac.newXPath();
            NSContextManager nsContext = new NSContextManager();
            nsContext.add("srx", NSURI_SRX20);
            nsContext.add(NSPREFIX_OKPSRX, NSURI_OKPSRX);
            nsContext.add("srx1", NSURI_SRX10);
            xpath.setNamespaceContext(nsContext);
            String ns = NSURI_SRX20;
            XPathExpression xpe = xpath.compile("//srx:srx");
            NodeList srxList = (NodeList)xpe.evaluate(doc, XPathConstants.NODESET);
            if (srxList.getLength() < 1) {
                xpe = xpath.compile("//srx1:srx");
                srxList = (NodeList)xpe.evaluate(doc, XPathConstants.NODESET);
                if (srxList.getLength() < 1) {
                    xpe = xpath.compile("//srx");
                    srxList = (NodeList)xpe.evaluate(doc, XPathConstants.NODESET);
                    if (srxList.getLength() < 1) {
                        return;
                    }
                    ns = "";
                } else {
                    ns = NSURI_SRX10;
                }
            }
            Element srxElem = (Element)srxList.item(0);
            this.docComment = this.getPreviousComments(srxElem, null);
            String tmp = srxElem.getAttribute("version");
            if (tmp.equals("1.0")) {
                this.version = tmp;
                this.warning = "SRX version 1.0 rules are subject to different interpretation.\nRead the help for more information.";
            } else if (tmp.equals("2.0")) {
                this.version = tmp;
                this.warning = null;
            } else {
                throw new OkapiIOException("Invalid version value.");
            }
            Element elem1 = this.getFirstElementByTagNameNS(ns, "header", srxElem);
            this.headerComment = this.getPreviousComments(elem1, null);
            tmp = elem1.getAttribute("segmentsubflows");
            if (tmp.length() > 0) {
                this.segmentSubFlows = "yes".equals(tmp);
            }
            if ((tmp = elem1.getAttribute("cascade")).length() > 0) {
                this.cascade = "yes".equals(tmp);
            }
            NodeList list2 = elem1.getElementsByTagNameNS(ns, "formathandle");
            for (int i2 = 0; i2 < list2.getLength(); ++i2) {
                Element elem2 = (Element)list2.item(i2);
                tmp = elem2.getAttribute("type");
                if ("start".equals(tmp)) {
                    tmp = elem2.getAttribute("include");
                    if (tmp.length() <= 0) continue;
                    this.includeStartCodes = "yes".equals(tmp);
                    continue;
                }
                if ("end".equals(tmp)) {
                    tmp = elem2.getAttribute("include");
                    if (tmp.length() <= 0) continue;
                    this.includeEndCodes = "yes".equals(tmp);
                    continue;
                }
                if (!"isolated".equals(tmp) || (tmp = elem2.getAttribute("include")).length() <= 0) continue;
                this.includeIsolatedCodes = "yes".equals(tmp);
            }
            Element elem2 = this.getFirstElementByTagNameNS(NSURI_OKPSRX, "options", elem1);
            if (elem2 != null) {
                tmp = elem2.getAttribute("oneSegmentIncludesAll");
                if (tmp.length() > 0) {
                    this.oneSegmentIncludesAll = "yes".equals(tmp);
                }
                if ((tmp = elem2.getAttribute("trimLeadingWhitespaces")).length() > 0) {
                    this.trimLeadingWS = "yes".equals(tmp);
                }
                if ((tmp = elem2.getAttribute("trimTrailingWhitespaces")).length() > 0) {
                    this.trimTrailingWS = "yes".equals(tmp);
                }
                if ((tmp = elem2.getAttribute("useJavaRegex")).length() > 0) {
                    this.useJavaRegex = "yes".equals(tmp);
                }
                if ((tmp = elem2.getAttribute("treatIsolatedCodesAsWhitespace")).length() > 0) {
                    this.treatIsolatedCodesAsWhitespace = "yes".equals(tmp);
                }
            }
            if ((elem2 = this.getFirstElementByTagNameNS(NSURI_OKPSRX, "sample", elem1)) != null) {
                this.setSampleText(Util.getTextContent(elem2));
                tmp = elem2.getAttribute("language");
                if (tmp.length() > 0) {
                    this.setSampleLanguage(tmp);
                }
                if ((tmp = elem2.getAttribute("useMappedRules")).length() > 0) {
                    this.setTestOnSelectedGroup("no".equals(tmp));
                }
            }
            if ((elem2 = this.getFirstElementByTagNameNS(NSURI_OKPSRX, "rangeRule", elem1)) != null) {
                this.setMaskRule(Util.getTextContent(elem2));
            }
            if ((elem2 = this.getFirstElementByTagNameNS(ns, "languagerules", elem1 = this.getFirstElementByTagNameNS(ns, "body", srxElem))) == null) {
                throw new OkapiException("the languagerules element is missing.");
            }
            list2 = elem2.getElementsByTagNameNS(ns, "languagerule");
            for (i = 0; i < list2.getLength(); ++i) {
                elem3 = (Element)list2.item(i);
                ArrayList<Rule> tmpList = new ArrayList<Rule>();
                String ruleName = elem3.getAttribute("languagerulename");
                NodeList list3 = elem3.getElementsByTagNameNS(ns, "rule");
                for (int j = 0; j < list3.getLength(); ++j) {
                    Element elem5;
                    Element elem4 = (Element)list3.item(j);
                    Rule newRule = new Rule();
                    newRule.comment = this.getPreviousComments(elem4, "rule");
                    tmp = elem4.getAttribute("break");
                    if (tmp.length() > 0) {
                        newRule.isBreak = "yes".equals(tmp);
                    }
                    if ((tmp = elem4.getAttributeNS(NSURI_OKPSRX, "active")).length() > 0) {
                        newRule.isActive = "yes".equals(tmp);
                    }
                    if ((elem5 = this.getFirstElementByTagNameNS(ns, "beforebreak", elem4)) != null) {
                        newRule.before = Util.getTextContent(elem5);
                    }
                    if ((elem5 = this.getFirstElementByTagNameNS(ns, "afterbreak", elem4)) != null) {
                        newRule.after = Util.getTextContent(elem5);
                    }
                    tmpList.add(newRule);
                }
                this.langRules.put(ruleName, tmpList);
            }
            elem2 = this.getFirstElementByTagNameNS(ns, "maprules", elem1);
            list2 = elem2.getElementsByTagNameNS(ns, "languagemap");
            for (i = 0; i < list2.getLength(); ++i) {
                elem3 = (Element)list2.item(i);
                LanguageMap langMap = new LanguageMap();
                tmp = elem3.getAttribute("languagepattern");
                if (tmp.length() > 0) {
                    langMap.pattern = tmp;
                }
                if ((tmp = elem3.getAttribute("languagerulename")).length() > 0) {
                    langMap.ruleName = tmp;
                }
                this.langMaps.add(langMap);
            }
            this.modified = false;
        }
        catch (SAXException e) {
            throw new OkapiIOException(e);
        }
        catch (ParserConfigurationException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        catch (XPathExpressionException e) {
            throw new OkapiIOException(e);
        }
    }

    private String getPreviousComments(Node startNode, String stopElement) {
        block4: for (Node node = startNode.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            switch (node.getNodeType()) {
                case 8: {
                    return node.getNodeValue();
                }
                case 1: {
                    if (stopElement == null || !node.getNodeName().equals(stopElement)) continue block4;
                    return null;
                }
            }
        }
        return null;
    }

    private Element getFirstElementByTagNameNS(String ns, String tagName, Element elem) {
        NodeList list = elem.getElementsByTagNameNS(ns, tagName);
        if (list == null || list.getLength() < 1) {
            return null;
        }
        return (Element)list.item(0);
    }

    public String saveRulesToString(boolean saveExtensions, boolean saveNonValidInfo) {
        StringWriter strWriter = new StringWriter();
        XMLWriter writer = new XMLWriter(strWriter);
        boolean current = this.modified;
        this.saveRules(writer, saveExtensions, saveNonValidInfo);
        this.modified = current;
        writer.close();
        return strWriter.toString();
    }

    public void saveRules(String rulesPath, boolean saveExtensions, boolean saveNonValidInfo) {
        XMLWriter writer = new XMLWriter(rulesPath);
        this.saveRules(writer, saveExtensions, saveNonValidInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRules(XMLWriter writer, boolean saveExtensions, boolean saveNonValidInfo) {
        try {
            writer.writeStartDocument();
            if (this.docComment != null) {
                writer.writeComment(this.docComment, true);
            }
            writer.writeStartElement("srx");
            writer.writeAttributeString("xmlns", NSURI_SRX20);
            if (saveExtensions) {
                writer.writeAttributeString("xmlns:okpsrx", NSURI_OKPSRX);
            }
            writer.writeAttributeString("version", "2.0");
            this.version = "2.0";
            writer.writeLineBreak();
            if (this.headerComment != null) {
                writer.writeComment(this.headerComment, true);
            }
            writer.writeStartElement("header");
            writer.writeAttributeString("segmentsubflows", this.segmentSubFlows ? "yes" : "no");
            writer.writeAttributeString("cascade", this.cascade ? "yes" : "no");
            writer.writeLineBreak();
            writer.writeStartElement("formathandle");
            writer.writeAttributeString("type", "start");
            writer.writeAttributeString("include", this.includeStartCodes ? "yes" : "no");
            writer.writeEndElementLineBreak();
            writer.writeStartElement("formathandle");
            writer.writeAttributeString("type", "end");
            writer.writeAttributeString("include", this.includeEndCodes ? "yes" : "no");
            writer.writeEndElementLineBreak();
            writer.writeStartElement("formathandle");
            writer.writeAttributeString("type", "isolated");
            writer.writeAttributeString("include", this.includeIsolatedCodes ? "yes" : "no");
            writer.writeEndElementLineBreak();
            if (saveExtensions) {
                writer.writeStartElement("okpsrx:options");
                writer.writeAttributeString("oneSegmentIncludesAll", this.oneSegmentIncludesAll ? "yes" : "no");
                writer.writeAttributeString("trimLeadingWhitespaces", this.trimLeadingWS ? "yes" : "no");
                writer.writeAttributeString("trimTrailingWhitespaces", this.trimTrailingWS ? "yes" : "no");
                writer.writeAttributeString("useJavaRegex", this.useJavaRegex ? "yes" : "no");
                writer.writeAttributeString("treatIsolatedCodesAsWhitespace", this.treatIsolatedCodesAsWhitespace ? "yes" : "no");
                writer.writeEndElementLineBreak();
                writer.writeStartElement("okpsrx:sample");
                writer.writeAttributeString("language", this.getSampleLanguage());
                writer.writeAttributeString("useMappedRules", this.testOnSelectedGroup() ? "no" : "yes");
                writer.writeString(this.getSampleText());
                writer.writeEndElementLineBreak();
                writer.writeStartElement("okpsrx:rangeRule");
                writer.writeString(this.getMaskRule());
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElementLineBreak();
            writer.writeStartElement("body");
            writer.writeLineBreak();
            writer.writeStartElement("languagerules");
            writer.writeLineBreak();
            for (String ruleName : this.langRules.keySet()) {
                writer.writeStartElement("languagerule");
                writer.writeAttributeString("languagerulename", ruleName);
                writer.writeLineBreak();
                ArrayList<Rule> langRule = this.langRules.get(ruleName);
                for (Rule rule : langRule) {
                    if (rule.comment != null) {
                        writer.writeComment(rule.comment, true);
                    }
                    writer.writeStartElement("rule");
                    writer.writeAttributeString("break", rule.isBreak ? "yes" : "no");
                    if (saveExtensions && saveNonValidInfo) {
                        writer.writeAttributeString("okpsrx:active", rule.isActive ? "yes" : "no");
                    }
                    writer.writeLineBreak();
                    writer.writeElementString("beforebreak", rule.before);
                    writer.writeLineBreak();
                    writer.writeElementString("afterbreak", rule.after);
                    writer.writeLineBreak();
                    writer.writeEndElementLineBreak();
                }
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElementLineBreak();
            writer.writeStartElement("maprules");
            writer.writeLineBreak();
            for (LanguageMap langMap : this.langMaps) {
                writer.writeStartElement("languagemap");
                writer.writeAttributeString("languagepattern", langMap.pattern);
                writer.writeAttributeString("languagerulename", langMap.ruleName);
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElementLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeEndElementLineBreak();
            writer.writeEndDocument();
            this.modified = false;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

