/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.terminology.TermHit;
import net.sf.okapi.lib.terminology.simpletb.SimpleTB;
import net.sf.okapi.lib.verification.Issue;

public class TermChecker {
    private ArrayList<Issue> issues;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private SimpleTB ta;
    private boolean stringSearch;
    private boolean betweenCodes;

    public void initialize(SimpleTB termAccess, LocaleId srcLoc, LocaleId trgLoc, boolean stringSearch, boolean betweenCodes) {
        this.issues = new ArrayList();
        this.ta = termAccess;
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
        this.stringSearch = stringSearch;
        this.betweenCodes = betweenCodes;
        this.ta.initialize(stringSearch, betweenCodes);
    }

    public int verify(URI docId, String subDocId, ITextUnit tu, Segment srcSeg, Segment trgSeg) {
        if (this.stringSearch) {
            return this.verifyStrings(docId, subDocId, tu, srcSeg, trgSeg);
        }
        return this.verifyTerms(docId, subDocId, tu, srcSeg, trgSeg);
    }

    private int verifyTerms(URI docId, String subDocId, ITextUnit tu, Segment srcSeg, Segment trgSeg) {
        this.issues.clear();
        List<TermHit> srcList = this.ta.getExistingTerms(srcSeg.text, this.srcLoc, this.trgLoc);
        List<TermHit> trgList = TermChecker.getExistingTargetTerms(trgSeg.text, srcList);
        TermChecker.removeMatches(srcList, trgList);
        for (TermHit th : srcList) {
            Issue issue = new Issue(docId, subDocId, IssueType.TERMINOLOGY, tu.getId(), srcSeg.getId(), String.format("In the glossary \"%s\" is translated \"%s\".", th.sourceTerm.getText(), th.targetTerm.getText()), -1, 0, -1, 0, 0.0, tu.getName());
            this.issues.add(issue);
        }
        return this.issues.size();
    }

    private int verifyStrings(URI docId, String subDocId, ITextUnit tu, Segment srcSeg, Segment trgSeg) {
        this.issues.clear();
        List<TermHit> srcList = this.ta.getExistingStrings(srcSeg.text, this.srcLoc, this.trgLoc);
        List<TermHit> trgList = TermChecker.getExistingTargetStrings(trgSeg.text, srcList, this.betweenCodes);
        TermChecker.removeMatches(srcList, trgList);
        for (TermHit th : srcList) {
            Issue issue = new Issue(docId, subDocId, IssueType.TERMINOLOGY, tu.getId(), srcSeg.getId(), String.format("In the glossary \"%s\" is translated \"%s\".", th.sourceTerm.getText(), th.targetTerm.getText()), TextFragment.fromFragmentToString(srcSeg.text, th.range.start), TextFragment.fromFragmentToString(srcSeg.text, th.range.end), -1, 0, 0.0, tu.getName());
            this.issues.add(issue);
        }
        return this.issues.size();
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public static List<TermHit> getExistingTargetTerms(TextFragment frag, List<TermHit> sourceHits) {
        String text = TextUnitUtil.getText(frag).toLowerCase();
        List<String> parts = Arrays.asList(text.split("\\s"));
        ArrayList<TermHit> res = new ArrayList<TermHit>();
        for (TermHit th : sourceHits) {
            if (!parts.contains(th.targetTerm.getText().toLowerCase())) continue;
            TermHit hit = new TermHit();
            hit.sourceTerm = th.targetTerm;
            hit.targetTerm = th.sourceTerm;
            res.add(hit);
        }
        return res;
    }

    public static List<TermHit> getExistingTargetStrings(TextFragment frag, List<TermHit> sourceHits, boolean betweenCodes) {
        StringBuilder text = new StringBuilder(frag);
        ArrayList<TermHit> res = new ArrayList<TermHit>();
        Range location = new Range(0, 0);
        for (TermHit th : sourceHits) {
            if (!SimpleTB.isValidMatch(text, th.targetTerm.getText(), location, betweenCodes)) continue;
            TermHit hit = new TermHit();
            hit.sourceTerm = th.targetTerm;
            hit.targetTerm = th.sourceTerm;
            res.add(hit);
            for (int i = location.start; i < location.end; ++i) {
                text.setCharAt(i, '`');
            }
        }
        return res;
    }

    public static List<TermHit> removeMatches(List<TermHit> srcList, List<TermHit> trgList) {
        Iterator<TermHit> srcIter = srcList.iterator();
        block0: while (srcIter.hasNext()) {
            TermHit srcHit = srcIter.next();
            Iterator<TermHit> trgIter = trgList.iterator();
            while (trgIter.hasNext()) {
                TermHit trgHit = trgIter.next();
                if (!srcHit.targetTerm.getText().equals(trgHit.sourceTerm.getText()) || !srcHit.sourceTerm.getText().equals(trgHit.targetTerm.getText())) continue;
                trgIter.remove();
                srcIter.remove();
                continue block0;
            }
        }
        return srcList;
    }
}

