/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.msbatchtranslation;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.common.uidescription.TextLabelPart;

@EditorFor(value=SubmissionParameters.class)
public class SubmissionParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String CLIENTID = "clientId";
    private static final String SECRET = "secret";
    private static final String CATEGORY = "category";
    private static final String BATCHSIZE = "batchSize";
    private static final String RATING = "rating";

    public SubmissionParameters() {
    }

    public SubmissionParameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setClientId("");
        this.setSecret("");
        this.setCategory("");
        this.setBatchSize(80);
        this.setRating(4);
    }

    public int getBatchSize() {
        return this.getInteger(BATCHSIZE);
    }

    public void setBatchSize(int batchSize) {
        this.setInteger(BATCHSIZE, batchSize);
    }

    public int getRating() {
        return this.getInteger(RATING);
    }

    public void setRating(int rating) {
        this.setInteger(RATING, rating);
    }

    public String getClientId() {
        return this.getString(CLIENTID);
    }

    public String getSecret() {
        return this.getString(SECRET);
    }

    public String getCategory() {
        return this.getString(CATEGORY);
    }

    public void setClientId(String clientId) {
        this.setString(CLIENTID, clientId);
    }

    public void setSecret(String secret) {
        this.setString(SECRET, secret);
    }

    public void setCategory(String category) {
        this.setString(CATEGORY, category);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CLIENTID, "Client ID", "Client ID in Microsoft Azure Marketplace");
        desc.add(SECRET, "Client Secret", "Client Secret from Microsoft Azure Marketplace");
        desc.add(CATEGORY, "Category", "Category code if accessing a trained system");
        desc.add(BATCHSIZE, "Batch size", "Number of segments to send in each batch");
        desc.add(RATING, "Default rating", "Default rating to use for if one is not provided with the translated segment");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft Batch Submission Settings");
        TextLabelPart tlp = desc.addTextLabelPart("Powered by Microsoft\u00ae Translator");
        tlp.setVertical(true);
        SeparatorPart sp = desc.addSeparatorPart();
        sp.setVertical(true);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(CLIENTID));
        tip.setPassword(false);
        tip = desc.addTextInputPart(paramsDesc.get(SECRET));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        tip.setPassword(false);
        sp = desc.addSeparatorPart();
        sp.setVertical(true);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(RATING));
        sip.setRange(-10, 10);
        sip = desc.addSpinInputPart(paramsDesc.get(BATCHSIZE));
        sip.setRange(1, 100);
        return desc;
    }
}

