/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.engine;

import java.io.IOException;
import java.io.StringReader;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.steps.tokenization.common.AbstractLexer;
import net.sf.okapi.steps.tokenization.common.Lexem;
import net.sf.okapi.steps.tokenization.common.Lexems;
import net.sf.okapi.steps.tokenization.engine.javacc.ParseException;
import net.sf.okapi.steps.tokenization.engine.javacc.SimpleCharStream;
import net.sf.okapi.steps.tokenization.engine.javacc.Token;
import net.sf.okapi.steps.tokenization.engine.javacc.TokenMgrError;
import net.sf.okapi.steps.tokenization.engine.javacc.WordTokenizer;
import net.sf.okapi.steps.tokenization.engine.javacc.WordTokenizerTokenManager;
import net.sf.okapi.steps.tokenization.tokens.Tokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCcLexer
extends AbstractLexer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SimpleCharStream stream;
    private WordTokenizer tokenizer;
    private boolean hasNext;

    @Override
    protected boolean lexer_hasNext() {
        return this.hasNext;
    }

    @Override
    protected void lexer_init() {
        this.hasNext = false;
    }

    @Override
    protected Lexem lexer_next() {
        Token token = null;
        try {
            token = this.tokenizer.nextToken();
        }
        catch (TokenMgrError e) {
            this.logger.debug("JavaCC error: {}", (Object)e.getMessage());
            return null;
        }
        catch (Error e) {
            this.logger.debug("JavaCC error: {}", (Object)e.getMessage());
            return null;
        }
        catch (ParseException e) {
            this.logger.debug("JavaCC parsing exception: {}", (Object)e.getMessage());
            return null;
        }
        catch (IOException e) {
            this.logger.debug("JavaCC IO exception: {}", (Object)e.getMessage());
            return null;
        }
        if (token == null) {
            this.hasNext = false;
            return null;
        }
        int end = this.stream.bufpos + 1;
        int start = end - token.image.length();
        if (start < 0) {
            return null;
        }
        if (start > end) {
            return null;
        }
        int lexemId = token.kind;
        Lexem lexem = new Lexem(lexemId, token.image, start, end);
        return lexem;
    }

    @Override
    protected void lexer_open(String text, LocaleId language, Tokens tokens) {
        StringReader sr = new StringReader(text);
        this.stream = new SimpleCharStream(sr);
        WordTokenizerTokenManager tm = new WordTokenizerTokenManager(this.stream);
        this.tokenizer = new WordTokenizer(tm);
        this.hasNext = true;
    }

    @Override
    public Lexems process(String text, LocaleId language, Tokens tokens) {
        return null;
    }
}

