/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.ui;

import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.filters.table.tsv.Parameters;
import net.sf.okapi.lib.extra.filters.CompoundFilterParameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TableTab
extends Composite
implements IDialogPage,
SelectionListener {
    private static String NONE_ID = "%%%^^^$$$nonenonenone$$$^^^%%%";
    private Group grpTableType;
    private Button btnCSV;
    private Button btnTSV;
    private Button btnFWC;
    private Group grpTableProperties;
    private Label lblValuesStartAt;
    private Spinner start;
    private Spinner cols;
    private Label lcols;
    private Group csvOptions;
    private Button removeQualif;
    private Button nqualif;
    private Button trim;
    private Button allT;
    private Button addQualif;
    private Group extr;
    private Button header;
    private Button names;
    private Button allE;
    private Button body;
    private Group csvActions;
    private Text custDelim;
    private Text custQualif;
    private Combo delim;
    private Combo qualif;
    private Label label_3;
    private Group csvEscapingMode;
    private Button dupl;
    private Button bslash;

    public TableTab(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new GridLayout(3, false));
        this.grpTableType = new Group(this, 0);
        this.grpTableType.setLayout(new GridLayout(1, false));
        this.grpTableType.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.grpTableType.setText("Table type");
        this.btnCSV = new Button(this.grpTableType, 16);
        this.btnCSV.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnCSV.setData("name", "btnCSV");
        this.btnCSV.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.btnCSV.setText("CSV (Columns, separated by a comma, semicolon, etc.)                  ");
        this.btnTSV = new Button(this.grpTableType, 16);
        this.btnTSV.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTSV.setData("name", "btnTSV");
        this.btnTSV.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.btnTSV.setText("TSV (Columns, separated by one or more tabs)");
        this.btnFWC = new Button(this.grpTableType, 16);
        this.btnFWC.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnFWC.setData("name", "btnFWC");
        this.btnFWC.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.btnFWC.setText("Fixed-width columns");
        this.grpTableProperties = new Group(this, 0);
        this.grpTableProperties.setLayout(new GridLayout(2, false));
        this.grpTableProperties.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.grpTableProperties.setText("Table properties");
        this.lblValuesStartAt = new Label(this.grpTableProperties, 0);
        this.lblValuesStartAt.setLayoutData(new GridData(131072, 0x1000000, true, false, 1, 1));
        this.lblValuesStartAt.setAlignment(131072);
        this.lblValuesStartAt.setText("Values start at line:");
        this.start = new Spinner(this.grpTableProperties, 2048);
        this.start.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.start.setMinimum(1);
        this.lcols = new Label(this.grpTableProperties, 0);
        this.lcols.setLayoutData(new GridData(131072, 0x1000000, true, false, 1, 1));
        this.lcols.setAlignment(131072);
        this.lcols.setText("Line with column names (0 if none):");
        this.cols = new Spinner(this.grpTableProperties, 2048);
        this.cols.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.csvOptions = new Group(this, 0);
        this.csvOptions.setLayout(new GridLayout(1, false));
        this.csvOptions.setText("CSV options");
        this.csvOptions.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        Composite composite = new Composite(this.csvOptions, 0);
        composite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        composite.setLayout(new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Field delimiter:");
        label.setAlignment(131072);
        label.setLayoutData(new GridData(131072, 0x1000000, true, false, 1, 1));
        this.delim = new Combo(composite, 8);
        this.delim.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
                if (TableTab.this.custDelim.getEnabled()) {
                    TableTab.this.custDelim.setFocus();
                }
            }
        });
        this.delim.setItems(new String[]{"Comma (,)", "Semi-colon (;)", "Tab", "Space", "Custom"});
        this.delim.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.delim.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.delim.select(0);
        label = new Label(composite, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 1));
        this.custDelim = new Text(composite, 2048);
        this.custDelim.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.custDelim.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        new Label(composite, 0);
        new Label(composite, 0);
        Label label_1 = new Label(composite, 0);
        label_1.setText("Text qualifier:");
        label_1.setAlignment(131072);
        label_1.setLayoutData(new GridData(131072, 0x1000000, true, false, 1, 1));
        this.qualif = new Combo(composite, 8);
        this.qualif.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
                if (TableTab.this.custQualif.getEnabled()) {
                    TableTab.this.custQualif.setFocus();
                }
            }
        });
        this.qualif.setItems(new String[]{"Double-quote (\")", "Apostrophe (')", "None", "Custom"});
        this.qualif.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.qualif.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.qualif.select(0);
        new Label(composite, 0);
        this.custQualif = new Text(composite, 2048);
        this.custQualif.setData("name", "custQualif");
        this.custQualif.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.custQualif.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.csvEscapingMode = new Group(this, 0);
        this.csvEscapingMode.setLayout(new GridLayout(1, false));
        this.csvEscapingMode.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.csvEscapingMode.setText("CSV escaping mode");
        this.dupl = new Button(this.csvEscapingMode, 16);
        this.dupl.setSelection(true);
        this.dupl.setText("Duplicate qualifier (\"\")");
        this.bslash = new Button(this.csvEscapingMode, 16);
        this.bslash.setText("Backslash (\\\")");
        this.extr = new Group(this, 0);
        this.extr.setLayout(new GridLayout(2, false));
        this.extr.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this.extr.setText("Extraction mode");
        this.header = new Button(this.extr, 32);
        this.header.setLayoutData(new GridData(16384, 0x1000000, true, false, 2, 1));
        this.header.setData("name", "header");
        this.header.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.header.setText("Extract header lines");
        this.label_3 = new Label(this.extr, 0);
        this.label_3.setData("name", "label_3");
        this.label_3.setText("    ");
        this.names = new Button(this.extr, 16);
        this.names.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.names.setText("Column names only         ");
        new Label(this.extr, 0);
        this.allE = new Button(this.extr, 16);
        this.allE.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.allE.setText("All");
        this.body = new Button(this.extr, 32);
        this.body.setLayoutData(new GridData(16384, 0x1000000, true, false, 2, 1));
        this.body.addSelectionListener(this);
        this.body.setData("name", "body");
        this.body.setText("Extract table data");
        this.csvActions = new Group(this, 0);
        this.csvActions.setLayout(new GridLayout(1, false));
        this.csvActions.setText("CSV actions");
        this.csvActions.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.removeQualif = new Button(this.csvActions, 32);
        this.removeQualif.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.removeQualif.setText("Exclude qualifiers from extracted text");
        this.trim = new Button(this.csvActions, 32);
        this.trim.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.trim.setData("name", "trim");
        this.trim.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                TableTab.this.interop(e.widget);
            }
        });
        this.trim.setText("Exclude leading/trailing white spaces from extracted text");
        this.nqualif = new Button(this.csvActions, 16);
        GridData gd_nqualif = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_nqualif.horizontalIndent = 20;
        this.nqualif.setLayoutData(gd_nqualif);
        this.nqualif.setText("Only entries without qualifiers");
        this.allT = new Button(this.csvActions, 16);
        GridData gd_allT = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_allT.horizontalIndent = 20;
        this.allT.setLayoutData(gd_allT);
        this.allT.setText("All");
        this.addQualif = new Button(this.csvActions, 32);
        this.addQualif.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.addQualif.setText("Add qualifiers to output when appropriate");
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    public boolean canClose(boolean isOK) {
        return true;
    }

    @Override
    public void interop(Widget speaker) {
        boolean noColNames;
        SWTUtil.setAllEnabled(this.csvOptions, this.btnCSV.getSelection());
        SWTUtil.setAllEnabled(this.csvEscapingMode, this.btnCSV.getSelection());
        SWTUtil.setAllEnabled(this.csvActions, this.btnCSV.getSelection());
        this.custDelim.setEnabled(this.delim.getSelectionIndex() == 4);
        this.custQualif.setEnabled(this.qualif.getSelectionIndex() == 3);
        boolean noQualif = this.qualif.getSelectionIndex() == 2;
        boolean trimOn = this.trim.getSelection();
        boolean noHeader = this.start.getSelection() <= 1;
        boolean headerOn = this.header.getSelection();
        boolean bl = noColNames = this.cols.getSelection() == 0;
        if (noQualif && this.btnCSV.getSelection()) {
            this.removeQualif.setSelection(false);
        }
        this.removeQualif.setEnabled(!noQualif && this.btnCSV.getSelection());
        this.addQualif.setEnabled(!noQualif && this.btnCSV.getSelection());
        if (noQualif) {
            this.nqualif.setSelection(false);
            this.nqualif.setEnabled(false);
            this.allT.setEnabled(false);
            this.allT.setSelection(false);
        } else {
            this.nqualif.setEnabled(trimOn && this.btnCSV.getSelection());
            this.allT.setEnabled(trimOn && this.btnCSV.getSelection());
        }
        if (!trimOn) {
            this.trim.setSelection(false);
            this.nqualif.setSelection(false);
            this.allT.setSelection(false);
            this.nqualif.setEnabled(false);
            this.allT.setEnabled(false);
        } else {
            this.nqualif.setEnabled(!noQualif && this.btnCSV.getSelection());
            this.allT.setEnabled(this.btnCSV.getSelection());
            if (!this.nqualif.getSelection() && !this.allT.getSelection()) {
                if (this.nqualif.getEnabled()) {
                    this.nqualif.setSelection(true);
                    this.allT.setSelection(false);
                } else {
                    this.nqualif.setSelection(false);
                    this.allT.setSelection(true);
                }
            }
        }
        if (noHeader) {
            this.names.setSelection(false);
            this.names.setEnabled(false);
            this.allE.setSelection(false);
            this.allE.setEnabled(false);
            this.header.setSelection(false);
            this.header.setEnabled(false);
            this.cols.setSelection(0);
            this.cols.setEnabled(false);
            this.lcols.setEnabled(false);
        } else {
            this.lcols.setEnabled(true);
            this.cols.setEnabled(true);
            this.header.setEnabled(true);
            this.names.setEnabled(headerOn);
            this.allE.setEnabled(headerOn);
            if (!headerOn) {
                this.names.setSelection(false);
                this.allE.setSelection(false);
            } else if (!this.names.getSelection() && !this.allE.getSelection()) {
                this.names.setSelection(headerOn);
                this.allE.setSelection(false);
            }
        }
        this.cols.setMaximum(this.start.getSelection() - 1);
        if (noColNames) {
            this.names.setSelection(false);
            this.allE.setSelection(this.allE.getEnabled());
            this.names.setEnabled(false);
        } else {
            this.names.setEnabled(headerOn);
        }
        SWTUtil.disableIfDisabled(this.names, this.header);
        SWTUtil.disableIfDisabled(this.allE, this.header);
        SWTUtil.selectIfDisabled(this.body, this.header);
        if (this.body.getEnabled() && !this.header.getSelection() && !this.body.getSelection()) {
            this.body.setSelection(true);
        }
    }

    @Override
    public boolean load(Object data) {
        if (data instanceof CompoundFilterParameters) {
            CompoundFilterParameters params = (CompoundFilterParameters)data;
            Class c = params.getParametersClass();
            if (c == net.sf.okapi.filters.table.csv.Parameters.class) {
                this.btnCSV.setSelection(true);
                this.btnTSV.setSelection(false);
                this.btnFWC.setSelection(false);
            } else if (c == Parameters.class) {
                this.btnCSV.setSelection(false);
                this.btnTSV.setSelection(true);
                this.btnFWC.setSelection(false);
            } else if (c == net.sf.okapi.filters.table.fwc.Parameters.class) {
                this.btnCSV.setSelection(false);
                this.btnTSV.setSelection(false);
                this.btnFWC.setSelection(true);
            } else {
                this.btnCSV.setSelection(true);
                this.btnTSV.setSelection(false);
                this.btnFWC.setSelection(false);
            }
        } else {
            net.sf.okapi.filters.table.csv.Parameters params;
            if (data instanceof net.sf.okapi.filters.table.csv.Parameters) {
                params = (net.sf.okapi.filters.table.csv.Parameters)data;
                if (params.fieldDelimiter.equals(",") || params.fieldDelimiter.equals("")) {
                    this.delim.select(0);
                    this.custDelim.setText("");
                } else if (params.fieldDelimiter.equals(";")) {
                    this.delim.select(1);
                    this.custDelim.setText("");
                } else if (params.fieldDelimiter.equals("\t")) {
                    this.delim.select(2);
                    this.custDelim.setText("");
                } else if (params.fieldDelimiter.equals(" ")) {
                    this.delim.select(3);
                    this.custDelim.setText("");
                } else {
                    this.delim.select(4);
                    this.custDelim.setText(params.fieldDelimiter);
                }
                if (params.textQualifier.equals("\"") || params.textQualifier.equals("")) {
                    this.qualif.select(0);
                    this.custQualif.setText("");
                } else if (params.textQualifier.equals("'")) {
                    this.qualif.select(1);
                    this.custQualif.setText("");
                } else if (params.textQualifier.equals(NONE_ID)) {
                    this.qualif.select(2);
                    this.custQualif.setText("");
                } else {
                    this.qualif.select(3);
                    this.custQualif.setText(params.textQualifier);
                }
                this.removeQualif.setSelection(params.removeQualifiers);
                this.addQualif.setSelection(params.addQualifiers);
                this.dupl.setSelection(params.escapingMode == 1);
                this.bslash.setSelection(params.escapingMode == 2);
            }
            if (data instanceof net.sf.okapi.filters.table.base.Parameters) {
                params = (net.sf.okapi.filters.table.base.Parameters)data;
                this.cols.setSelection(params.columnNamesLineNum);
                this.start.setSelection(params.valuesStartLineNum);
                this.body.setSelection(params.sendColumnsMode != 0);
                if (params.sendHeaderMode == 0) {
                    this.header.setSelection(false);
                    this.names.setSelection(false);
                    this.allE.setSelection(false);
                } else if (params.sendHeaderMode == 1) {
                    this.header.setEnabled(true);
                    this.header.setSelection(true);
                    this.names.setSelection(true);
                    this.allE.setSelection(false);
                } else if (params.sendHeaderMode == 2) {
                    this.header.setEnabled(true);
                    this.header.setSelection(true);
                    this.names.setSelection(false);
                    this.allE.setSelection(true);
                }
                if (params.trimMode == 1) {
                    this.trim.setEnabled(true);
                    this.trim.setSelection(true);
                    this.nqualif.setSelection(true);
                    this.allT.setSelection(false);
                } else if (params.trimMode == 2) {
                    this.trim.setEnabled(true);
                    this.trim.setSelection(true);
                    this.nqualif.setSelection(false);
                    this.allT.setSelection(true);
                } else if (params.trimMode == 0) {
                    this.trim.setSelection(false);
                    this.nqualif.setSelection(false);
                    this.allT.setSelection(false);
                }
            }
        }
        return true;
    }

    @Override
    public boolean save(Object data) {
        if (data instanceof CompoundFilterParameters) {
            CompoundFilterParameters params = (CompoundFilterParameters)data;
            if (this.btnCSV.getSelection()) {
                params.setParametersClass(net.sf.okapi.filters.table.csv.Parameters.class);
            } else if (this.btnTSV.getSelection()) {
                params.setParametersClass(Parameters.class);
            } else if (this.btnFWC.getSelection()) {
                params.setParametersClass(net.sf.okapi.filters.table.fwc.Parameters.class);
            } else {
                params.setParametersClass(net.sf.okapi.filters.table.base.Parameters.class);
            }
        } else {
            net.sf.okapi.filters.table.csv.Parameters params;
            if (data instanceof net.sf.okapi.filters.table.csv.Parameters) {
                params = (net.sf.okapi.filters.table.csv.Parameters)data;
                switch (this.delim.getSelectionIndex()) {
                    case 0: {
                        params.fieldDelimiter = ",";
                        break;
                    }
                    case 1: {
                        params.fieldDelimiter = ";";
                        break;
                    }
                    case 2: {
                        params.fieldDelimiter = "\t";
                        break;
                    }
                    case 3: {
                        params.fieldDelimiter = " ";
                        break;
                    }
                    case 4: {
                        params.fieldDelimiter = this.custDelim.getText();
                    }
                }
                switch (this.qualif.getSelectionIndex()) {
                    case 0: {
                        params.textQualifier = "\"";
                        break;
                    }
                    case 1: {
                        params.textQualifier = "'";
                        break;
                    }
                    case 2: {
                        params.textQualifier = NONE_ID;
                        break;
                    }
                    case 3: {
                        params.textQualifier = this.custQualif.getText();
                    }
                }
                params.removeQualifiers = this.removeQualif.getSelection();
                params.addQualifiers = this.addQualif.getSelection();
                if (this.dupl.getSelection()) {
                    params.escapingMode = 1;
                }
                if (this.bslash.getSelection()) {
                    params.escapingMode = 2;
                }
            }
            if (data instanceof net.sf.okapi.filters.table.base.Parameters) {
                params = (net.sf.okapi.filters.table.base.Parameters)data;
                params.columnNamesLineNum = this.cols.getSelection();
                params.valuesStartLineNum = this.start.getSelection();
                params.sendHeaderMode = this.header.getSelection() && this.names.getSelection() ? 1 : (this.header.getSelection() && this.allE.getSelection() ? 2 : 0);
                if (!this.body.getSelection()) {
                    params.sendColumnsMode = 0;
                }
                params.trimMode = this.trim.getSelection() && this.nqualif.getSelection() ? 1 : (this.trim.getSelection() && this.allT.getSelection() ? 2 : 0);
            }
        }
        return true;
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        this.interop(e.widget);
    }
}

