/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;

public final class FileUtil {
    private static final Pattern pattern = Pattern.compile("\\s(srclang|source-?language|xml:lang|lang|(target)?locale|(target-?)?language)\\s*?=\\s*?['\"](.*?)['\"]", 2);
    private static final Pattern XLIFF_SEGMENTATION_PATTERN = Pattern.compile("<\\s*seg-source\\s*>", 2);

    public static File[] getFilteredFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = FileUtil.getFilteredFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> getFilteredFiles(File directory, FilenameFilter filter, boolean recurse) {
        LinkedList<File> files = new LinkedList<File>();
        File[] entries = directory.listFiles();
        if (entries == null) {
            return files;
        }
        for (File entry : entries) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(FileUtil.getFilteredFiles(entry, filter, recurse));
        }
        return files;
    }

    public static List<String> guessLanguages(String path) {
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader reader = null;
        String encoding = Charset.defaultCharset().name();
        try (FileInputStream fis = new FileInputStream(path);
             BOMAwareInputStream bis = new BOMAwareInputStream(fis, encoding);){
            encoding = bis.detectEncoding();
            reader = new InputStreamReader((InputStream)fis, encoding);
            int BYTES_TO_SCAN = 102400;
            char[] buffer = new char[102400];
            String trgValue = null;
            int readCount = reader.read(buffer, 0, 102400);
            if (readCount <= 0) {
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            String line = new String(buffer, 0, readCount);
            Matcher m = pattern.matcher(line);
            while (m.find()) {
                String lang = m.group(4).toLowerCase();
                if (lang.isEmpty()) continue;
                String name = m.group(1).toLowerCase();
                if ((name.equals("language") || name.startsWith("target")) && list.isEmpty()) {
                    trgValue = lang;
                    continue;
                }
                if (!list.contains(lang)) {
                    list.add(lang);
                }
                if (trgValue != null) {
                    list.add(trgValue);
                    trgValue = null;
                }
                if (list.size() <= 1) continue;
                break;
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error while trying to guess language information.\n" + e.getLocalizedMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public static boolean isXliffSegmented(String path) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void zipDirectory(String sourceDir, String zipExtension) {
        FileUtil.zipDirectory(sourceDir, zipExtension, null);
    }

    public static void zipDirectory(String sourceDir, String zipExtension, String destinationPathWithoutExtension) {
        ZipOutputStream os = null;
        String zipPath = null;
        zipPath = Util.isEmpty(destinationPathWithoutExtension) ? (sourceDir.endsWith(File.separator) || sourceDir.endsWith("/") ? sourceDir.substring(0, sourceDir.length() - 1) : sourceDir) : destinationPathWithoutExtension;
        zipPath = Util.isEmpty(zipExtension) ? zipPath + ".zip" : zipPath + zipExtension;
        try {
            File dir = new File(sourceDir);
            if (!dir.isDirectory()) {
                return;
            }
            os = new ZipOutputStream(new FileOutputStream(zipPath));
            FileUtil.addDirectoryToZip(dir, os, null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while zipping.", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing stream while zipping.", e);
                }
            }
        }
    }

    public static void zipFiles(String zipPath, String sourceDir, String ... filenames) {
        ZipOutputStream os = null;
        try {
            Util.createDirectories(zipPath);
            os = new ZipOutputStream(new FileOutputStream(zipPath));
            for (String name : filenames) {
                File file = new File(Util.ensureSeparator(sourceDir, true) + name);
                FileUtil.addFileToZip(file, os);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while zipping.", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing stream while zipping.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(File file, ZipOutputStream os) throws IOException {
        try (FileInputStream input = null;){
            int nCount;
            byte[] aBuf = new byte[1024];
            input = new FileInputStream(file);
            os.putNextEntry(new ZipEntry(file.getName()));
            while ((nCount = input.read(aBuf)) > 0) {
                os.write(aBuf, 0, nCount);
            }
            os.closeEntry();
        }
    }

    public static void addFileToZip(File zipFile, String file) throws IOException {
        File[] files = new File[]{new File(file)};
        FileUtil.addFilesToZip(zipFile, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFilesToZip(File zipFile, File[] files) throws IOException {
        File tempFile = null;
        ZipInputStream zin = null;
        ZipOutputStream out = null;
        byte[] buf = null;
        try {
            tempFile = File.createTempFile("~okapi-12_" + zipFile.getName(), null, new File(zipFile.getParent()));
            tempFile.delete();
            boolean renameOk = zipFile.renameTo(tempFile);
            if (!renameOk) {
                throw new OkapiException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
            }
            buf = new byte[1024];
            zin = new ZipInputStream(new FileInputStream(tempFile));
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean notInFiles = true;
                for (File f : files) {
                    if (!f.getName().equals(name)) continue;
                    notInFiles = false;
                    break;
                }
                if (notInFiles) {
                    int len;
                    out.putNextEntry(new ZipEntry(name));
                    while ((len = zin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                entry = zin.getNextEntry();
            }
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            if (out != null) {
                for (int i = 0; i < files.length; ++i) {
                    int len;
                    FileInputStream in = new FileInputStream(files[i]);
                    out.putNextEntry(new ZipEntry(files[i].getName()));
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    ((InputStream)in).close();
                }
                out.close();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirectoryToZip(File dir, ZipOutputStream os, String subDir) throws IOException {
        try (FileInputStream input = null;){
            byte[] aBuf = new byte[1024];
            for (File file : dir.listFiles()) {
                int nCount;
                if (file.isDirectory()) {
                    FileUtil.addDirectoryToZip(file, os, (subDir == null ? "" : subDir + "\\") + file.getName());
                    continue;
                }
                input = new FileInputStream(file.getPath());
                os.putNextEntry(new ZipEntry((subDir == null ? "" : subDir + "\\") + file.getName()));
                while ((nCount = input.read(aBuf)) > 0) {
                    os.write(aBuf, 0, nCount);
                }
                os.closeEntry();
            }
        }
    }

    public static void unzip(String zipFileName, String destPath) {
        ZipInputStream in = null;
        OutputStream out = null;
        Util.createDirectories(destPath);
        try {
            in = new ZipInputStream(new FileInputStream(zipFileName));
            byte[] buf = new byte[1024];
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                String outFilename = entry.getName();
                if (entry.isDirectory()) {
                    new File(destPath, outFilename).mkdirs();
                    continue;
                }
                if (!Util.getDirectoryName(outFilename).isEmpty()) {
                    File f = new File(destPath, outFilename);
                    Util.createDirectories(f.getAbsolutePath());
                }
                out = new FileOutputStream(new File(destPath, outFilename));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.close();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error unzipping file.\n" + e.getMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing input while unzipping file.", e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing output while unzipping file.", e);
                }
            }
        }
    }

    public static void deleteAllFilesInDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        File[] files = directory.listFiles();
        if (files == null) {
            throw new OkapiIOException("Error finding directory: " + directoryPath);
        }
        for (File file : files) {
            if (file.delete()) continue;
            throw new OkapiIOException("Error deleting file: " + file.getPath());
        }
    }

    public static String getLocaleBasedFile(String baseName, final String extension, LocaleId locale) {
        ResourceBundle.Control control = new ResourceBundle.Control(){
            private String resourceFound = null;

            @Override
            public List<String> getFormats(String baseName) {
                return Arrays.asList(extension);
            }

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                URL r = loader.getResource(resourceName);
                if (r != null) {
                    this.resourceFound = new File(Util.URLtoURI(r)).getPath();
                    return new ResourceBundle(){

                        @Override
                        public Enumeration<String> getKeys() {
                            return null;
                        }

                        @Override
                        protected Object handleGetObject(String key) {
                            return null;
                        }
                    };
                }
                return null;
            }

            public String toString() {
                return this.resourceFound;
            }
        };
        ResourceBundle.clearCache();
        ResourceBundle.getBundle(baseName, locale.toJavaLocale(), control);
        return control.toString();
    }

    public static String getPartBeforeFile(URI uri) {
        String tmp = uri.toString();
        int n = tmp.lastIndexOf(47);
        if (n == -1) {
            return uri.toString();
        }
        return tmp.substring(0, n + 1);
    }

    public static File createTempFile(String prefix, String extension) {
        try {
            return File.createTempFile(prefix, extension);
        }
        catch (IOException e) {
            throw new OkapiIOException("Cannot create temporary file.", e);
        }
    }

    public static File createTempFile(String prefix) {
        return FileUtil.createTempFile(prefix, ".tmp");
    }

    public static void deleteFileFromZip(File zipFile, String file) throws IOException {
        String[] files = new String[]{file};
        FileUtil.deleteFilesFromZip(zipFile, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFilesFromZip(File zipFile, String[] files) throws IOException {
        ZipInputStream zin = null;
        ZipOutputStream zout = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile(zipFile.getName(), null, new File(zipFile.getParent()));
            tempFile.delete();
            boolean renameOk = zipFile.renameTo(tempFile);
            if (!renameOk) {
                throw new OkapiException("Could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
            }
            byte[] buf = new byte[1024];
            zin = new ZipInputStream(new FileInputStream(tempFile));
            zout = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean toBeDeleted = false;
                for (String f : files) {
                    if (!f.equals(name)) continue;
                    toBeDeleted = true;
                    break;
                }
                if (!toBeDeleted) {
                    int len;
                    zout.putNextEntry(new ZipEntry(name));
                    while ((len = zin.read(buf)) > 0) {
                        zout.write(buf, 0, len);
                    }
                }
                entry = zin.getNextEntry();
            }
        }
        finally {
            if (zin != null) {
                zin.close();
            }
            if (zout != null) {
                zout.close();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OkapiException(e);
        }
    }

    public static File urlToFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new OkapiException(e);
        }
    }
}

