/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.SkeletonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitUtil {
    private static final String SEG_START = "$seg_start$";
    private static final String SEG_END = "$seg_end$";
    private static final String TP_START = "$tp_start$";
    private static final String TP_END = "$tp_end$";
    private static final Pattern SEG_REGEX = Pattern.compile("\\[#\\$([A-Za-z_\\-0-9]+?)\\@\\%\\$seg_start\\$\\](.*?)\\[#\\$(\\1)\\@\\%\\$seg_end\\$\\]");
    private static final Pattern SEG_START_REGEX = Pattern.compile("\\[#\\$([A-Za-z_\\-0-9]+?)\\@\\%\\$seg_start\\$\\]");
    private static final Pattern SEG_END_REGEX = Pattern.compile("\\[#\\$([A-Za-z_\\-0-9]+?)\\@\\%\\$seg_end\\$\\]");
    private static final Pattern TP_REGEX = Pattern.compile("\\$tp_start\\$(.*?)\\$tp_end\\$");
    private static final Pattern TP_START_REGEX = Pattern.compile("\\$tp_start\\$");
    private static final Pattern TP_END_REGEX = Pattern.compile("\\$tp_end\\$");
    private static final Pattern ANY_SEG_TP_REGEX = Pattern.compile("\\[#\\$([A-Za-z_\\-0-9]+?)\\@\\%\\$seg_start\\$\\]|\\[#\\$([A-Za-z_\\-0-9]+?)\\@\\%\\$seg_end\\$\\]|\\$tp_start\\$|\\$tp_end\\$");
    private static final Pattern EXTERNAL_REF_REGEX = Pattern.compile("\\[\\#\\$((tu)|(sg))[0-9]+\\]");
    private static final char FOO = '\u0001';
    private static final Pattern PLAIN_TEXT_REGEX = Pattern.compile(String.format("[^%s]+", Character.valueOf('\u0001')));
    private static String testMarkersSt;

    public static void trimLeading(TextFragment textFragment) {
        TextUnitUtil.trimLeading(textFragment, null);
    }

    public static TextFragment copySrcCodeDataToMatchingTrgCodes(TextFragment oriSrc, TextFragment newTrg, boolean alwaysCopyCodes, boolean addMissingCodes, TextFragment newSrc, ITextUnit parent) {
        Logger localLogger = LoggerFactory.getLogger(TextUnitUtil.class);
        if (newTrg == oriSrc) {
            return newTrg;
        }
        List<Code> newCodes = newTrg.getCodes();
        List<Code> oriCodes = oriSrc.getCodes();
        boolean needAdjustment = false;
        if (!alwaysCopyCodes) {
            for (Code code : newCodes) {
                if (code.hasData()) continue;
                needAdjustment = true;
                break;
            }
            if (!needAdjustment) {
                for (Code code : oriCodes) {
                    if (!code.hasReference()) continue;
                    needAdjustment = true;
                    break;
                }
            }
            if (!needAdjustment) {
                return newTrg;
            }
        }
        if (!newTrg.hasCode() && !oriSrc.hasCode()) {
            return newTrg;
        }
        if (newSrc != null && !needAdjustment && oriCodes.toString().equals(newSrc.getCodes().toString())) {
            return newTrg;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i = 0; i < oriIndices.length; ++i) {
            oriIndices[i] = i;
        }
        int done = 0;
        for (int i = 0; i < newCodes.size(); ++i) {
            Code newCode = newCodes.get(i);
            newCode.setOuterData(null);
            if (newCode.hasOnlyAnnotation()) continue;
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriCodes.get(j).getId() != newCode.getId() || oriCodes.get(j).getTagType() != newCode.getTagType()) continue;
                if (oriIndices[j] == -1 && !oriCodes.get(j).isCloneable()) {
                    String place = null;
                    if (parent != null) {
                        place = String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                    }
                    localLogger.debug(String.format("The extra code id='%d' cannot be cloned.", newCode.getId()) + (place == null ? "" : place));
                }
                oriCode = oriCodes.get(j);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (newCode.getData() != null && newCode.getData().length() != 0) continue;
                String place = null;
                if (parent != null) {
                    place = String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                }
                localLogger.warn(String.format("The extra target code id='%d' does not have corresponding data.", newCode.getId()) + (place == null ? "" : place));
                continue;
            }
            newCode.setData(oriCode.getData());
            newCode.setOuterData(oriCode.getOuterData());
            newCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            TextFragment leadingCodes = new TextFragment();
            for (int i = 0; i < oriIndices.length; ++i) {
                if (oriIndices[i] == -1) continue;
                Code code = oriCodes.get(oriIndices[i]);
                if (addMissingCodes) {
                    if (TextUnitUtil.isLeadingCode(code, oriSrc)) {
                        leadingCodes.append(code.clone());
                        continue;
                    }
                    newTrg.append(code.clone());
                    continue;
                }
                if (code.isDeleteable()) continue;
                String msg = String.format("The code id='%d' (%s) is missing in target.", code.getId(), code.getData());
                if (parent != null) {
                    msg = msg + String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                }
                localLogger.debug(msg);
                localLogger.debug(String.format("Source='%s'\nTarget='%s'", oriSrc.toText(), newTrg.toText()));
            }
            if (addMissingCodes) {
                newTrg.insert(0, leadingCodes, true);
            }
        }
        return newTrg;
    }

    private static boolean isLeadingCode(Code code, TextFragment oriSrc) {
        int index = oriSrc.getCodes().indexOf(code);
        if (index == -1) {
            return false;
        }
        String ctext = oriSrc.getCodedText();
        int pos = ctext.indexOf(String.valueOf(TextFragment.toChar(index)), 0);
        if (pos == -1) {
            return false;
        }
        String substr = ctext.substring(0, pos - 1);
        return (substr = TextFragment.MARKERS_REGEX.matcher(substr).replaceAll("")).trim().length() == 0;
    }

    public static void trimLeading(TextFragment textFragment, GenericSkeleton skel) {
        TextFragment skelTF;
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfFirstNonWhitespace(st, 0, -1, false, false, false, true);
        if (pos == -1) {
            skelTF = new TextFragment(st);
            textFragment.setCodedText("");
        } else {
            skelTF = textFragment.subSequence(0, pos);
            textFragment.setCodedText(st.substring(pos));
        }
        if (skel == null) {
            return;
        }
        if (skelTF == null) {
            return;
        }
        st = skelTF.toText();
        if (!Util.isEmpty(st)) {
            skel.append(st);
        }
    }

    public static void trimTrailing(TextFragment textFragment) {
        TextUnitUtil.trimTrailing(textFragment, null);
    }

    public static void trimTrailing(TextFragment textFragment, GenericSkeleton skel) {
        TextFragment skelTF;
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, false, false, false, true);
        if (pos == -1) {
            skelTF = new TextFragment(st);
            textFragment.setCodedText("");
        } else {
            skelTF = textFragment.subSequence(pos + 1, st.length());
            textFragment.setCodedText(st.substring(0, pos + 1));
        }
        if (skel == null) {
            return;
        }
        if (skelTF == null) {
            return;
        }
        st = skelTF.toText();
        if (!Util.isEmpty(st)) {
            skel.append(st);
        }
    }

    public static boolean endsWith(TextFragment textFragment, String substr) {
        if (textFragment == null) {
            return false;
        }
        if (Util.isEmpty(substr)) {
            return false;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return false;
        }
        return st.lastIndexOf(substr) == pos - substr.length() + 1;
    }

    public static boolean isEmpty(ITextUnit textUnit) {
        return textUnit == null || textUnit.getSource().isEmpty();
    }

    public static boolean hasSource(ITextUnit textUnit) {
        return !TextUnitUtil.isEmpty(textUnit, true);
    }

    public static boolean isEmpty(ITextUnit textUnit, boolean ignoreWS) {
        return textUnit == null || Util.isEmpty(TextUnitUtil.getSourceText(textUnit), ignoreWS);
    }

    public static String getSourceText(ITextUnit textUnit) {
        return textUnit.getSource().getFirstContent().getCodedText();
    }

    public static String getSourceText(ITextUnit textUnit, boolean removeCodes) {
        if (textUnit == null) {
            return "";
        }
        if (removeCodes) {
            return TextUnitUtil.getText(textUnit.getSource().getFirstContent());
        }
        return textUnit.getSource().getFirstContent().getCodedText();
    }

    public static String getTargetText(ITextUnit textUnit, LocaleId locId) {
        if (textUnit == null) {
            return "";
        }
        if (Util.isNullOrEmpty(locId)) {
            return "";
        }
        return TextUnitUtil.getCodedText(textUnit.getTarget(locId).getFirstContent());
    }

    public static String getCodedText(TextFragment textFragment) {
        if (textFragment == null) {
            return "";
        }
        return textFragment.getCodedText();
    }

    public static String getText(TextFragment textFragment, List<Integer> markerPositions) {
        if (textFragment == null) {
            return "";
        }
        String res = textFragment.getCodedText();
        if (markerPositions != null) {
            markerPositions.clear();
        }
        if (!textFragment.hasCode()) {
            return res;
        }
        StringBuilder sb = new StringBuilder();
        int startPos = -1;
        block3: for (int i = 0; i < res.length(); ++i) {
            switch (res.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    if (markerPositions != null) {
                        markerPositions.add(i);
                    }
                    if (i > startPos && startPos >= 0) {
                        sb.append(res.substring(startPos, i));
                    }
                    ++i;
                    startPos = -1;
                    continue block3;
                }
                default: {
                    if (startPos >= 0) continue block3;
                    startPos = i;
                }
            }
        }
        if (startPos < 0 && sb.length() == 0) {
            startPos = 0;
        } else if (startPos > -1 && startPos < res.length()) {
            sb.append(res.substring(startPos));
        }
        return sb.toString();
    }

    public static String printMarkerIndexes(TextFragment textFragment) {
        return new GenericContent(textFragment).printMarkerIndexes();
    }

    public static String printMarkers(TextFragment textFragment) {
        return new GenericContent(textFragment).toString();
    }

    public static String getText(TextFragment textFragment) {
        return TextUnitUtil.getText(textFragment, null);
    }

    public static char getLastChar(TextFragment textFragment) {
        if (textFragment == null) {
            return '\u0000';
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return '\u0000';
        }
        return st.charAt(pos);
    }

    public static void deleteLastChar(TextFragment textFragment) {
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return;
        }
        textFragment.remove(pos, pos + 1);
    }

    public static int lastIndexOf(TextFragment textFragment, String findWhat) {
        if (textFragment == null) {
            return -1;
        }
        if (Util.isEmpty(findWhat)) {
            return -1;
        }
        if (Util.isEmpty(textFragment.getCodedText())) {
            return -1;
        }
        return textFragment.getCodedText().lastIndexOf(findWhat);
    }

    public static boolean isEmpty(TextFragment textFragment) {
        return textFragment == null || textFragment != null && textFragment.isEmpty();
    }

    public static ITextUnit buildTU(TextContainer source) {
        return TextUnitUtil.buildTU(null, "", source, null, LocaleId.EMPTY, "");
    }

    public static ITextUnit buildTU(String source) {
        return TextUnitUtil.buildTU(new TextContainer(source));
    }

    public static ITextUnit buildTU(String srcPart, String skelPart) {
        ITextUnit res = TextUnitUtil.buildTU(srcPart);
        if (res == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)res.getSkeleton();
        if (skel == null) {
            return null;
        }
        skel.addContentPlaceholder(res);
        skel.append(skelPart);
        return res;
    }

    public static ITextUnit buildTU(ITextUnit textUnit, String name, TextContainer source, TextContainer target, LocaleId locId, String comment) {
        if (textUnit == null) {
            textUnit = new TextUnit("");
        }
        if (textUnit.getSkeleton() == null) {
            GenericSkeleton skel = new GenericSkeleton();
            textUnit.setSkeleton(skel);
        }
        if (!Util.isEmpty(name)) {
            textUnit.setName(name);
        }
        if (source != null) {
            textUnit.setSource(source);
        }
        if (target != null && !Util.isNullOrEmpty(locId)) {
            textUnit.setTarget(locId, target);
        }
        if (!Util.isEmpty(comment)) {
            textUnit.setProperty(new Property("note", comment));
        }
        return textUnit;
    }

    public static GenericSkeleton forceSkeleton(ITextUnit tu) {
        if (tu == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tu.setSkeleton(skel);
        }
        if (!SkeletonUtil.hasTuRef(skel)) {
            skel.addContentPlaceholder(tu);
        }
        return skel;
    }

    public static GenericSkeleton convertToSkeleton(ITextUnit textUnit) {
        if (textUnit == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)textUnit.getSkeleton();
        if (skel == null) {
            return new GenericSkeleton(textUnit.toString());
        }
        List<GenericSkeletonPart> list = skel.getParts();
        if (list.size() == 0) {
            return new GenericSkeleton(textUnit.toString());
        }
        String tuRef = TextFragment.makeRefMarker("$self$");
        GenericSkeleton res = new GenericSkeleton();
        List<GenericSkeletonPart> list2 = res.getParts();
        for (GenericSkeletonPart part : list) {
            String st = part.toString();
            if (Util.isEmpty(st)) continue;
            if (st.equalsIgnoreCase(tuRef)) {
                LocaleId locId = part.getLocale();
                if (Util.isNullOrEmpty(locId)) {
                    res.add(TextUnitUtil.getSourceText(textUnit));
                    continue;
                }
                res.add(TextUnitUtil.getTargetText(textUnit, locId));
                continue;
            }
            list2.add(part);
        }
        return res;
    }

    public static <A extends IAnnotation> A getSourceAnnotation(ITextUnit textUnit, Class<A> type) {
        if (textUnit == null) {
            return null;
        }
        if (textUnit.getSource() == null) {
            return null;
        }
        return textUnit.getSource().getAnnotation(type);
    }

    public static void setSourceAnnotation(ITextUnit textUnit, IAnnotation annotation) {
        if (textUnit == null) {
            return;
        }
        if (textUnit.getSource() == null) {
            return;
        }
        textUnit.getSource().setAnnotation(annotation);
    }

    public static <A extends IAnnotation> A getTargetAnnotation(ITextUnit textUnit, LocaleId locId, Class<A> type) {
        if (textUnit == null) {
            return null;
        }
        if (Util.isNullOrEmpty(locId)) {
            return null;
        }
        if (textUnit.getTarget(locId) == null) {
            return null;
        }
        return textUnit.getTarget(locId).getAnnotation(type);
    }

    public static void setTargetAnnotation(ITextUnit textUnit, LocaleId locId, IAnnotation annotation) {
        if (textUnit == null) {
            return;
        }
        if (Util.isNullOrEmpty(locId)) {
            return;
        }
        if (textUnit.getTarget(locId) == null) {
            return;
        }
        textUnit.getTarget(locId).setAnnotation(annotation);
    }

    public static void setSourceText(ITextUnit textUnit, String text) {
        TextFragment source = textUnit.getSource().getFirstContent();
        source.setCodedText(text);
    }

    public static void setTargetText(ITextUnit textUnit, LocaleId locId, String text) {
        TextFragment target = textUnit.getTarget(locId).getFirstContent();
        target.setCodedText(text);
    }

    public static void trimTU(ITextUnit textUnit, boolean trimLeading, boolean trimTrailing) {
        int index;
        if (textUnit == null) {
            return;
        }
        if (!trimLeading && !trimTrailing) {
            return;
        }
        TextContainer source = textUnit.getSource();
        GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
        GenericSkeleton skel = new GenericSkeleton();
        if (trimLeading) {
            TextUnitUtil.trimLeading(source.getFirstContent(), skel);
        }
        skel.addContentPlaceholder(textUnit);
        if (trimTrailing) {
            TextUnitUtil.trimTrailing(source.getFirstContent(), skel);
        }
        if ((index = SkeletonUtil.findTuRefInSkeleton(tuSkel)) != -1) {
            SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
        } else {
            tuSkel.add(skel);
        }
    }

    public static void addQualifiers(ITextUnit textUnit, String startQualifier, String endQualifier) {
        if (textUnit == null) {
            return;
        }
        if (Util.isEmpty(startQualifier)) {
            return;
        }
        if (Util.isEmpty(endQualifier)) {
            return;
        }
        GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
        GenericSkeleton skel = new GenericSkeleton();
        skel.add(startQualifier);
        skel.addContentPlaceholder(textUnit);
        skel.add(endQualifier);
        int index = SkeletonUtil.findTuRefInSkeleton(tuSkel);
        if (index != -1) {
            SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
        } else {
            tuSkel.add(skel);
        }
    }

    public static void addQualifiers(ITextUnit textUnit, String qualifier) {
        TextUnitUtil.addQualifiers(textUnit, qualifier, qualifier);
    }

    public static boolean removeQualifiers(ITextUnit textUnit, String startQualifier, String endQualifier) {
        if (textUnit == null) {
            return false;
        }
        if (Util.isEmpty(startQualifier)) {
            return false;
        }
        if (Util.isEmpty(endQualifier)) {
            return false;
        }
        String st = TextUnitUtil.getSourceText(textUnit);
        if (st == null) {
            return false;
        }
        boolean res = false;
        int startQualifierLen = startQualifier.length();
        int endQualifierLen = endQualifier.length();
        if (st.startsWith(startQualifier) && st.endsWith(endQualifier) && st.length() >= 2) {
            GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
            GenericSkeleton skel = new GenericSkeleton();
            skel.add(startQualifier);
            skel.addContentPlaceholder(textUnit);
            skel.add(endQualifier);
            res = true;
            TextUnitUtil.setSourceText(textUnit, st.substring(startQualifierLen, Util.getLength(st) - endQualifierLen));
            int index = SkeletonUtil.findTuRefInSkeleton(tuSkel);
            if (index != -1) {
                SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
            } else {
                tuSkel.add(skel);
            }
        }
        return res;
    }

    public static void simplifyCodes(ITextUnit textUnit, String rules, boolean removeLeadingTrailingCodes) {
        Logger localLogger = LoggerFactory.getLogger(TextUnitUtil.class);
        if (textUnit == null) {
            localLogger.warn("Text unit is null.");
            return;
        }
        if (textUnit.getTargetLocales().size() > 0) {
            localLogger.warn(String.format("Text unit %s has one or more targets, desinchronization of codes in source and targets is possible.", textUnit.getId()));
        }
        TextContainer tc = textUnit.getSource();
        TextFragment[] res = null;
        if (textUnit.getSource().hasBeenSegmented()) {
            res = TextUnitUtil.simplifyCodes(tc, rules, removeLeadingTrailingCodes);
        } else {
            TextFragment tf = tc.getUnSegmentedContentCopy();
            res = TextUnitUtil.simplifyCodes(tf, rules, removeLeadingTrailingCodes);
            textUnit.setSourceContent(tf);
        }
        if (removeLeadingTrailingCodes && res != null) {
            GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
            GenericSkeleton skel = new GenericSkeleton();
            skel.add(TextUnitUtil.isEmpty(res[0]) ? null : TextFragmentUtil.toText(res[0]));
            skel.addContentPlaceholder(textUnit);
            skel.add(TextUnitUtil.isEmpty(res[1]) ? null : TextFragmentUtil.toText(res[1]));
            int index = SkeletonUtil.findTuRefInSkeleton(tuSkel);
            if (index != -1) {
                SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
            } else {
                tuSkel.add(skel);
            }
        }
    }

    public static void simplifyCodesPostSegmentation(ITextUnit textUnit, String rules, boolean removeLeadingTrailingCodes) {
        if (textUnit == null || TextUnitUtil.isEmpty(textUnit) || !textUnit.isTranslatable()) {
            return;
        }
        TextUnitUtil.simplifyCodesPostSegmentation(textUnit.getSource(), rules, removeLeadingTrailingCodes);
        for (LocaleId tl : textUnit.getTargetLocales()) {
            TextUnitUtil.simplifyCodesPostSegmentation(textUnit.getTarget(tl), rules, removeLeadingTrailingCodes);
        }
    }

    public static void simplifyCodesPostSegmentation(TextContainer tc, String rules, boolean removeLeadingTrailingCodes) {
        LinkedList<TextPart> newParts;
        if (tc.hasBeenSegmented()) {
            newParts = new LinkedList<TextPart>();
            for (TextPart p : tc.getParts()) {
                if (p.isSegment()) {
                    TextFragment[] res = TextUnitUtil.simplifyCodes(p.text, rules, removeLeadingTrailingCodes, true);
                    if (removeLeadingTrailingCodes && res != null) {
                        if (res[0] != null) {
                            newParts.add(new TextPart(TextUnitUtil.expandCodes(res[0])));
                        }
                        newParts.add(p);
                        if (res[1] == null) continue;
                        newParts.add(new TextPart(TextUnitUtil.expandCodes(res[1])));
                        continue;
                    }
                    newParts.add(p);
                    continue;
                }
                newParts.add(p);
            }
        } else {
            return;
        }
        tc.setParts(newParts.toArray(new TextPart[newParts.size()]));
    }

    public static TextFragment expandCodes(TextFragment tf) {
        if (tf == null || !tf.hasCode()) {
            return tf;
        }
        TextFragment expandedCodes = new TextFragment();
        block3: for (int i = 0; i < tf.length(); ++i) {
            switch (tf.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    int index = TextFragment.toIndex(tf.charAt(i + 1));
                    Code code = tf.codes.get(index);
                    if (code.isMerged()) {
                        for (Code c : Code.stringToCodes(code.getMergedData())) {
                            expandedCodes.append(c);
                        }
                    } else {
                        expandedCodes.append(code);
                    }
                    ++i;
                    continue block3;
                }
                default: {
                    expandedCodes.append(tf.charAt(i));
                }
            }
        }
        expandedCodes.balanceMarkers();
        return expandedCodes;
    }

    public static boolean hasMergedCode(TextFragment tf) {
        if (tf == null || tf.isEmpty()) {
            return false;
        }
        for (Code c : tf.getCodes()) {
            if (!c.isMerged()) continue;
            return true;
        }
        return false;
    }

    public static void removeCodes(ITextUnit textUnit, boolean removeTargetCodes) {
        Logger localLogger = LoggerFactory.getLogger(TextUnitUtil.class);
        if (textUnit == null) {
            localLogger.warn("Text unit is null.");
            return;
        }
        TextContainer stc = textUnit.getSource();
        TextUnitUtil.removeCodes(stc);
        if (removeTargetCodes && !textUnit.getTargetLocales().isEmpty()) {
            for (LocaleId locale : textUnit.getTargetLocales()) {
                TextContainer ttc = textUnit.getTarget(locale);
                TextUnitUtil.removeCodes(ttc);
            }
        }
    }

    public static void removeCodes(TextContainer tc) {
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        StringBuilder tmp = new StringBuilder();
        StringBuilder text = new StringBuilder(tf.getText());
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    ++i;
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        tc.setContent(new TextFragment(tmp.toString()));
    }

    public static void removeCodes(TextFragment tf) {
        StringBuilder tmp = new StringBuilder();
        StringBuilder text = new StringBuilder(tf.getText());
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    ++i;
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        tf.clear();
        tf.setCodedText(tmp.toString());
    }

    public static String removeCodes(String codedText) {
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < codedText.length(); ++i) {
            switch (codedText.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    ++i;
                    continue block3;
                }
                default: {
                    tmp.append(codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static String removeAndReplaceCodes(String codedText, String isolatedCodeReplacement) {
        StringBuilder tmp = new StringBuilder();
        block4: for (int i = 0; i < codedText.length(); ++i) {
            switch (TextFragment.Marker.asEnum(codedText.charAt(i))) {
                case OPENING: 
                case CLOSING: {
                    ++i;
                    continue block4;
                }
                case ISOLATED: {
                    ++i;
                    tmp.append(isolatedCodeReplacement);
                    continue block4;
                }
                default: {
                    tmp.append(codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static TextFragment[] simplifyCodes(TextFragment tf, String rules, boolean removeLeadingTrailingCodes) {
        CodeSimplifier simplifier = new CodeSimplifier();
        simplifier.setRules(rules);
        return simplifier.simplifyAll(tf, removeLeadingTrailingCodes);
    }

    private static TextFragment[] simplifyCodes(TextFragment tf, String rules, boolean removeLeadingTrailingCodes, boolean postSegmentation) {
        CodeSimplifier simplifier = new CodeSimplifier();
        simplifier.setRules(rules);
        simplifier.postSegmentation = postSegmentation;
        return simplifier.simplifyAll(tf, removeLeadingTrailingCodes);
    }

    public static TextFragment[] simplifyCodes(TextContainer tc, String rules, boolean removeLeadingTrailingCodes) {
        CodeSimplifier simplifier = new CodeSimplifier();
        simplifier.setRules(rules);
        TextFragment[] res = simplifier.simplifyAll(tc, removeLeadingTrailingCodes);
        TextUnitUtil.trimSegments(tc);
        return res;
    }

    public static boolean removeQualifiers(ITextUnit textUnit, String qualifier) {
        return TextUnitUtil.removeQualifiers(textUnit, qualifier, qualifier);
    }

    public static AltTranslationsAnnotation addAltTranslation(TextContainer targetContainer, AltTranslation alt) {
        AltTranslationsAnnotation altTrans = targetContainer.getAnnotation(AltTranslationsAnnotation.class);
        if (altTrans == null) {
            altTrans = new AltTranslationsAnnotation();
            targetContainer.setAnnotation(altTrans);
        }
        altTrans.add(alt);
        return altTrans;
    }

    public static AltTranslationsAnnotation addAltTranslation(Segment seg, AltTranslation alt) {
        AltTranslationsAnnotation altTrans = seg.getAnnotation(AltTranslationsAnnotation.class);
        if (altTrans == null) {
            altTrans = new AltTranslationsAnnotation();
            seg.setAnnotation(altTrans);
        }
        altTrans.add(alt);
        return altTrans;
    }

    public static TextFragment storeSegmentation(TextContainer tc) {
        TextFragment tf = new TextFragment();
        int lastCodeId = 0;
        for (TextPart part : tc) {
            Code code;
            TextFragment ptf = part.getContent().clone();
            ++lastCodeId;
            lastCodeId = ptf.renumberCodes(lastCodeId);
            if (part.isSegment()) {
                boolean insertTrailingPart;
                Segment seg = (Segment)part;
                int startPos = TextUnitUtil.getStartPosition(ptf);
                TextFragment ctf = new TextFragment();
                if (startPos > 0) {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_START);
                    code.setId(++lastCodeId);
                    ctf.append(code);
                    ptf.insert(0, ctf, true);
                    startPos += 2;
                    ctf = new TextFragment();
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_END);
                    code.setId(++lastCodeId);
                    ctf.append(code);
                }
                int markerId = ++lastCodeId;
                code = new Code(TextFragment.TagType.OPENING, "seg", TextFragment.makeRefMarker(seg.getId(), SEG_START));
                code.setId(markerId);
                ctf.append(code);
                ptf.insert(startPos, ctf, true);
                ctf = new TextFragment();
                int endPos = TextUnitUtil.getEndPosition(ptf);
                code = new Code(TextFragment.TagType.CLOSING, "seg", TextFragment.makeRefMarker(seg.getId(), SEG_END));
                code.setId(markerId);
                ctf.append(code);
                boolean bl = insertTrailingPart = endPos < ptf.length();
                if (insertTrailingPart) {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_START);
                    code.setId(++lastCodeId);
                    ctf.append(code);
                }
                ptf.insert(endPos, ctf, true);
                if (insertTrailingPart) {
                    ctf = new TextFragment();
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_END);
                    code.setId(++lastCodeId);
                    ctf.append(code);
                    ptf.insert(-1, ctf, true);
                }
                tf.insert(-1, ptf, true);
                continue;
            }
            code = new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_START);
            code.setId(++lastCodeId);
            tf.append(code);
            tf.insert(-1, ptf, true);
            code = new Code(TextFragment.TagType.PLACEHOLDER, "tp", TP_END);
            code.setId(++lastCodeId);
            tf.append(code);
        }
        tf.renumberCodes();
        return tf;
    }

    private static String buildSearchString(TextFragment tf) {
        String text = tf.getCodedText();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': {
                    sb.append("11");
                    ++i;
                    continue block4;
                }
                case '\ue103': {
                    sb.append("00");
                    ++i;
                    continue block4;
                }
                default: {
                    if (Character.isWhitespace(text.charAt(i))) {
                        sb.append("0");
                        continue block4;
                    }
                    sb.append("1");
                }
            }
        }
        return sb.toString();
    }

    private static int getStartPosition(TextFragment tf) {
        String st = TextUnitUtil.buildSearchString(tf);
        int pos = st.indexOf(49);
        return pos == -1 ? 0 : pos;
    }

    private static int getEndPosition(TextFragment tf) {
        String st = TextUnitUtil.buildSearchString(tf);
        int pos = StringUtil.mirrorString(st).indexOf(49);
        return pos == -1 ? st.length() : st.length() - pos;
    }

    public static void trimSegments(TextContainer tc, boolean trimLeading, boolean trimTrailing) {
        if (!trimLeading && !trimTrailing) {
            return;
        }
        for (int index = 0; index < tc.count(); ++index) {
            TextPart part = tc.get(index);
            if (!part.isSegment()) continue;
            TextFragment tf = part.getContent();
            if (trimLeading) {
                GenericSkeleton skel1 = new GenericSkeleton();
                TextUnitUtil.trimLeading(tf, skel1);
                if (!skel1.isEmpty()) {
                    tc.insert(index, new TextPart(skel1.toString()));
                    ++index;
                }
            }
            if (!trimTrailing) continue;
            GenericSkeleton skel2 = new GenericSkeleton();
            TextUnitUtil.trimTrailing(tf, skel2);
            if (skel2.isEmpty()) continue;
            tc.insert(index + 1, new TextPart(skel2.toString()));
            ++index;
        }
    }

    public static void trimSegments(TextContainer tc) {
        TextUnitUtil.trimSegments(tc, true, true);
    }

    public static TextFragment extractSegMarkers(TextFragment tf, TextFragment original, boolean removeFromOriginal) {
        Logger localLogger = LoggerFactory.getLogger(TextUnitUtil.class);
        if (tf == null) {
            localLogger.warn("Text fragment is null, no codes are added");
        }
        if (original == null) {
            localLogger.warn("Original string is null, no processing was performed");
            return null;
        }
        Matcher matcher = ANY_SEG_TP_REGEX.matcher(original.toText());
        while (tf != null && matcher.find()) {
            tf.append(new Code(TextFragment.TagType.PLACEHOLDER, null, matcher.group()));
        }
        if (removeFromOriginal) {
            LinkedList<Code> removedCodes = new LinkedList<Code>();
            for (Code c : original.getCodes()) {
                matcher = ANY_SEG_TP_REGEX.matcher(c.getOuterData());
                String d = matcher.replaceAll("");
                if (!c.getOuterData().isEmpty() && d.isEmpty()) {
                    removedCodes.add(c);
                    continue;
                }
                if (!c.getData().isEmpty()) {
                    c.setData(d);
                    continue;
                }
                if (c.getOuterData().isEmpty()) continue;
                c.setOuterData(d);
            }
            for (Code c : removedCodes) {
                original.removeCode(c);
            }
            return original;
        }
        return original;
    }

    public static boolean hasSegOrTpMarker(Code code) {
        return ANY_SEG_TP_REGEX.matcher(code.data).find();
    }

    public static boolean hasSegStartMarker(Code code) {
        return SEG_START_REGEX.matcher(code.data).find();
    }

    public static boolean hasSegEndMarker(Code code) {
        return SEG_END_REGEX.matcher(code.data).find();
    }

    public static boolean hasTpStartMarker(Code code) {
        return TP_START_REGEX.matcher(code.data).find();
    }

    public static boolean hasTpEndMarker(Code code) {
        return TP_END_REGEX.matcher(code.data).find();
    }

    public static boolean hasExternalRefMarker(Code code) {
        return EXTERNAL_REF_REGEX.matcher(code.data).find();
    }

    public static String restoreSegmentation(TextContainer tc, TextFragment segStorage) {
        Logger localLogger = LoggerFactory.getLogger(TextUnitUtil.class);
        tc.clear();
        TextFragment tf = segStorage;
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < ctext.length(); ++i) {
            if (!TextFragment.isMarker(ctext.charAt(i))) continue;
            int codeIndex = TextFragment.toIndex(ctext.charAt(i + 1));
            Code code = codes.get(codeIndex);
            String data = code.getData();
            ArrayList<Token> tokens = new ArrayList<Token>();
            Matcher matcher = SEG_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.SEG, new Range(matcher.start(), matcher.end()), new Range(matcher.start(2), matcher.end(2)), matcher.group(1), matcher.group()));
            }
            matcher = TP_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP, new Range(matcher.start(), matcher.end()), new Range(matcher.start(1), matcher.end(1)), null, matcher.group()));
            }
            for (Token token : tokens) {
                data = StringUtil.padString(data, token.range.start, token.range.end, '\u0001');
            }
            matcher = SEG_START_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.SEG_START, new Range(matcher.start(), matcher.end()), null, matcher.group(1), matcher.group()));
            }
            matcher = SEG_END_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.SEG_END, new Range(matcher.start(), matcher.end()), null, matcher.group(1), matcher.group()));
            }
            matcher = TP_START_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP_START, new Range(matcher.start(), matcher.end()), null, null, matcher.group()));
            }
            matcher = TP_END_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP_END, new Range(matcher.start(), matcher.end()), null, null, matcher.group()));
            }
            if (tokens.size() == 0) {
                ++i;
                continue;
            }
            for (Token token : tokens) {
                data = StringUtil.padString(data, token.range.start, token.range.end, '\u0001');
            }
            matcher = PLAIN_TEXT_REGEX.matcher(data);
            while (matcher.find()) {
                tokens.add(new Token(TokenType.TP, new Range(matcher.start(), matcher.end()), new Range(matcher.start(), matcher.end()), null, matcher.group()));
            }
            Collections.sort(tokens, new Comparator<Token>(){

                @Override
                public int compare(Token t1, Token t2) {
                    if (t1.type == TokenType.SEG_END && t2.type == TokenType.TP) {
                        return -1;
                    }
                    if (t2.type == TokenType.SEG_END && t1.type == TokenType.TP) {
                        return 1;
                    }
                    if (t1.type == TokenType.SEG_START && t2.type == TokenType.TP) {
                        return 1;
                    }
                    if (t2.type == TokenType.SEG_START && t1.type == TokenType.TP) {
                        return -1;
                    }
                    if (t1.textRange.start < t2.textRange.start) {
                        return -1;
                    }
                    if (t1.textRange.start > t2.textRange.start) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (Token token : tokens) {
                switch (token.type) {
                    case SEG: {
                        markers.add(new Marker(MarkerType.M_SEG_START, token.id, i, token.textRange.start, code));
                        markers.add(new Marker(MarkerType.M_SEG_END, token.id, i, token.textRange.end, code));
                        break;
                    }
                    case TP: {
                        markers.add(new Marker(MarkerType.M_TP_START, i, token.textRange.start, code));
                        markers.add(new Marker(MarkerType.M_TP_END, i, token.textRange.end, code));
                        break;
                    }
                    case SEG_START: {
                        markers.add(new Marker(MarkerType.M_SEG_START, token.id, i + 2, 0, null));
                        break;
                    }
                    case SEG_END: {
                        markers.add(new Marker(MarkerType.M_SEG_END, token.id, i, 0, null));
                        break;
                    }
                    case TP_START: {
                        markers.add(new Marker(MarkerType.M_TP_START, i + 2, 0, null));
                        break;
                    }
                    case TP_END: {
                        markers.add(new Marker(MarkerType.M_TP_END, i, 0, null));
                    }
                }
            }
            ++i;
        }
        Collections.sort(markers, new Comparator<Marker>(){

            @Override
            public int compare(Marker m1, Marker m2) {
                if (m1.position < m2.position) {
                    return -1;
                }
                if (m1.position > m2.position) {
                    return 1;
                }
                if (m1.context != null && m2.context != null) {
                    if (m1.relPos < m2.relPos) {
                        return -1;
                    }
                    if (m1.relPos > m2.relPos) {
                        return 1;
                    }
                    return 0;
                }
                if (m1.context != null && m2.context == null) {
                    return 1;
                }
                if (m1.context == null && m2.context != null) {
                    return -1;
                }
                return 0;
            }
        });
        StringBuilder markersSb = new StringBuilder();
        ArrayList<TextPart> list = new ArrayList<TextPart>();
        int start = -1;
        for (Marker d : markers) {
            switch (d.type) {
                case M_SEG_START: {
                    int n = start = d.context == null ? d.position : d.relPos;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s %s) ", d.position, "seg_start", d.id));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s %s) ", d.position, d.relPos, "seg_start", d.id));
                    break;
                }
                case M_SEG_END: {
                    TextFragment tf2;
                    if (start > -1) {
                        if (d.context == null) {
                            if (start <= d.position) {
                                list.add(new Segment(d.id, tf.subSequence(start, d.position)));
                            } else {
                                localLogger.warn(String.format("Cannot create the segment %s - incorrect range: (%d - %d)", d.id, start, d.position));
                            }
                        } else if (start <= d.relPos) {
                            tf2 = new TextFragment();
                            tf2.append(new Code(((Marker)d).context.tagType, ((Marker)d).context.type, d.context.getData().substring(start, d.relPos)));
                            Segment newSeg = new Segment(d.id, tf2);
                            list.add(newSeg);
                        } else {
                            localLogger.warn(String.format("Cannot create the segment %s - incorrect range: (%d - %d)", d.id, start, d.relPos));
                        }
                    }
                    start = -1;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s %s) ", d.position, "seg_end", d.id));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s %s) ", d.position, d.relPos, "seg_end", d.id));
                    break;
                }
                case M_TP_START: {
                    int n = start = d.context == null ? d.position : d.relPos;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s) ", d.position, "tp_start"));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s) ", d.position, d.relPos, "tp_start"));
                    break;
                }
                case M_TP_END: {
                    TextFragment tf2;
                    if (start > -1) {
                        if (d.context == null) {
                            if (start <= d.position) {
                                list.add(new TextPart(tf.subSequence(start, d.position)));
                            } else {
                                localLogger.warn(String.format("Cannot create a text part - incorrect range: (%d - %d)", start, d.position));
                            }
                        } else if (start <= d.relPos) {
                            tf2 = new TextFragment();
                            tf2.append(new Code(((Marker)d).context.tagType, ((Marker)d).context.type, d.context.getData().substring(start, d.relPos)));
                            TextPart newTp = new TextPart(tf2);
                            list.add(newTp);
                        } else {
                            localLogger.warn(String.format("Cannot create a text part - incorrect range: (%d - %d)", start, d.relPos));
                        }
                    }
                    start = -1;
                    if (d.context == null) {
                        markersSb.append(String.format("(%d: %s) ", d.position, "tp_end"));
                        break;
                    }
                    markersSb.append(String.format("(%d-%d: %s) ", d.position, d.relPos, "tp_end"));
                }
            }
        }
        testMarkersSt = markersSb.toString().trim();
        TextUnitUtil.setParts(tc, list.toArray(new TextPart[list.size()]));
        return testMarkersSt;
    }

    public static String testMarkers() {
        return testMarkersSt;
    }

    private static void setParts(TextContainer tc, TextPart ... parts) {
        tc.setParts(parts);
    }

    public static String toText(TextFragment tf) {
        List<Code> codes = tf.getCodes();
        String text = tf.getCodedText();
        if (codes == null || codes.size() == 0) {
            return text.toString();
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(String.format("[%s]", code.data));
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static String toText(String text, List<Code> codes) {
        if (codes == null || codes.size() == 0) {
            return text.toString();
        }
        StringBuilder tmp = new StringBuilder();
        block5: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    int index = TextFragment.toIndex(text.charAt(++i));
                    try {
                        Code code = codes.get(index);
                        tmp.append(String.format("[%s]", code.data));
                    }
                    catch (Exception e) {
                        tmp.append(String.format("[-ERR:UNKNOWN-CODE- %d]", index));
                    }
                    continue block5;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public static boolean isApproved(ITextUnit tu, LocaleId targetLocale) {
        if (!tu.isTranslatable()) {
            return false;
        }
        Property prop = tu.getTargetProperty(targetLocale, "approved");
        return prop != null && "yes".equals(prop.getValue());
    }

    public static void convertTextPartsToCodes(TextContainer tc) {
        for (TextPart textPart : tc) {
            TextUnitUtil.convertTextPartToCode(textPart);
        }
    }

    public static void convertTextPartToCode(TextPart textPart) {
        if (!textPart.isSegment()) {
            TextFragment tf = textPart.getContent();
            if (tf.hasCode()) {
                return;
            }
            tf.changeToCode(0, tf.getCodedText().length(), TextFragment.TagType.PLACEHOLDER, null);
        }
    }

    public static void convertTextParts_whitespaceCodesToText(TextContainer tc) {
        for (TextPart textPart : tc) {
            TextUnitUtil.convertTextPart_whitespaceCodesToText(textPart);
        }
    }

    public static void convertTextPart_whitespaceCodesToText(TextPart textPart) {
        if (textPart.isSegment()) {
            return;
        }
        TextFragment tf = textPart.getContent();
        if (tf.hasText()) {
            return;
        }
        if (Util.isEmpty(tf.toText().trim())) {
            textPart.setContent(new TextFragment(tf.toText()));
        }
    }

    public static boolean isStandalone(ITextUnit tu) {
        if (tu == null) {
            return true;
        }
        if (tu.isReferent()) {
            return false;
        }
        TextFragment tf = tu.getSource().getUnSegmentedContentCopy();
        for (Code code : tf.getCodes()) {
            if (!code.hasReference()) continue;
            return false;
        }
        ISkeleton skel = tu.getSkeleton();
        if (skel == null) {
            return true;
        }
        if (!(skel instanceof GenericSkeleton)) {
            return true;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (!SkeletonUtil.isReference(part)) continue;
            return false;
        }
        return true;
    }

    public static void renumberCodes(TextContainer tc) {
        for (TextPart textPart : tc) {
            textPart.getContent().renumberCodes(1);
        }
    }

    public static boolean needsPreserveWhitespaces(TextContainer tc) {
        return !Util.isEmpty(RegexUtil.find(tc.toString(), "[^\\S ]| {2,}", 0));
    }

    public static boolean needsPreserveWhitespaces(ITextUnit tu) {
        if (TextUnitUtil.needsPreserveWhitespaces(tu.getSource())) {
            return true;
        }
        for (LocaleId trgLoc : tu.getTargetLocales()) {
            if (!TextUnitUtil.needsPreserveWhitespaces(tu.getTarget(trgLoc))) continue;
            return true;
        }
        return false;
    }

    public static boolean isWellformed(TextFragment tf) {
        Stack<Integer> idStack = new Stack<Integer>();
        idStack.push(-1);
        String text = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    int index = TextFragment.toIndex(text.charAt(i + 1));
                    Code code = codes.get(index);
                    switch (code.tagType) {
                        case OPENING: {
                            idStack.push(code.getId());
                            break;
                        }
                        case CLOSING: {
                            if (((Integer)idStack.pop()).intValue() == code.getId()) break;
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    public static boolean isWellformed(TextContainer tc) {
        for (TextPart textPart : tc) {
            if (TextUnitUtil.isWellformed(textPart.text)) continue;
            return false;
        }
        return true;
    }

    public static void unsegmentTU(ITextUnit tu) {
        tu.getSource().joinAll();
        for (LocaleId trgLoc : tu.getTargetLocales()) {
            tu.getTarget(trgLoc).joinAll();
        }
    }

    private static final class Token {
        TokenType type;
        String id;
        Range range;
        Range textRange;

        private Token(TokenType type, Range range, Range textRange, String id, String match) {
            this.type = type;
            this.range = range;
            this.textRange = textRange == null ? range : textRange;
            this.id = id;
        }
    }

    private static enum TokenType {
        SEG,
        TP,
        SEG_START,
        SEG_END,
        TP_START,
        TP_END;

    }

    private static final class Marker {
        private MarkerType type;
        private String id;
        private int position;
        private int relPos;
        private Code context;

        private Marker(MarkerType type, int position, int relPos, Code context) {
            this(type, null, position, relPos, context);
        }

        private Marker(MarkerType type, String id, int position, int relPos, Code context) {
            this.type = type;
            this.id = id;
            this.position = position;
            this.relPos = relPos;
            this.context = context;
        }
    }

    private static enum MarkerType {
        M_SEG_START,
        M_SEG_END,
        M_TP_START,
        M_TP_END;

    }
}

