/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.microsoft.ApacheHttpClientForMT;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MicrosoftMTConnector
extends BaseConnector
implements ITMQuery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String OPTIONS1 = "<TranslateOptions xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\"><Category>";
    private final String OPTIONS2 = "</Category><ContentType>text/html</ContentType><ReservedFlags /><State /><Uri></Uri><User>defaultUser</User></TranslateOptions>";
    private static final int QUERYLENGTHLIMIT = 10000;
    private static final int RETRIES = 5;
    private final String PLACEHOLDER = "[$#@list@#$]";
    private final int TOKENRETRIES = 3;
    private int SLEEPPAUSE = 300;
    private QueryUtil util = new QueryUtil();
    Parameters params = new Parameters();
    int maximumHits = 1;
    int threshold = -10;
    private List<QueryResult> results;
    String queryListTemplate;
    String addListTemplate;
    private String sToken = "";
    private long lExpirationTime = 0L;

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Microsoft-Translator";
    }

    @Override
    public String getSettingsDisplay() {
        return "Service: http://api.microsofttranslator.com/V2/Http.svc";
    }

    @Override
    public void open() {
        this.results = new ArrayList<QueryResult>();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    private static String fromInputStreamToString(InputStream stream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    @Override
    public int query(TextFragment frag) {
        this.current = -1;
        this.results.clear();
        if (!frag.hasText(false)) {
            return 0;
        }
        try {
            String stext = this.util.toCodedHTML(frag);
            String sAddress = String.format("http://api.microsofttranslator.com/v2/Http.svc/GetTranslations?text=%s&from=%s&to=%s&maxTranslations=%d", URLEncoder.encode(stext, "UTF-8"), this.srcCode, this.trgCode, this.maximumHits);
            for (int tries = 0; tries < 5; ++tries) {
                if (!this.getNewTokenIfNeeded()) {
                    throw new OkapiException("Error getting Microsoft Azure access token for translation");
                }
                if (tries == 4) {
                    throw new OkapiException(String.format("Failed to get Microsoft Translator access token after %d tries.\nStopped at fragment: %s", 3, frag.toString()));
                }
                String sBlock = this.postQuery(sAddress, "<TranslateOptions xmlns=\"http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2\"><Category>" + this.params.getCategory() + "</Category><ContentType>text/html</ContentType><ReservedFlags /><State /><Uri></Uri><User>defaultUser</User></TranslateOptions>");
                if (sBlock == null) {
                    try {
                        Thread.sleep(this.SLEEPPAUSE);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new OkapiException("Interrupted while waiting for Microsoft Translator access token");
                    }
                }
                this.results = this.parseBlock(sBlock, frag);
                break;
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error querying the MT server.\n" + e.getMessage(), e);
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    private String postQuery(String sAddress, String query) throws MalformedURLException, IOException {
        URL url = new URL(sAddress);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.addRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("Authorization", "Bearer " + this.sToken);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            osw.write(query);
        }
        catch (Exception e) {
            throw new OkapiException("Problem querying the MT server.\n" + e.getMessage(), e);
        }
        finally {
            osw.flush();
            osw.close();
        }
        int code = conn.getResponseCode();
        if (code == 200) {
            return MicrosoftMTConnector.fromInputStreamToString(conn.getInputStream(), "UTF-8");
        }
        this.logger.error("Query response code: {}: {}", (Object)code, (Object)conn.getResponseMessage());
        return null;
    }

    private String unescapeXML(String text) {
        text = text.replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        return text.replace("&amp;", "&");
    }

    private List<QueryResult> parseBlock(String block, TextFragment frag) {
        int n1;
        ArrayList<QueryResult> list = new ArrayList<QueryResult>(this.maximumHits);
        int from = 0;
        if (block == null) {
            return list;
        }
        while ((n1 = block.indexOf("<TranslationMatch>", from)) >= 0) {
            int combinedScore;
            int n2 = block.indexOf("</TranslationMatch>", n1);
            String res = block.substring(n1, n2);
            from = n2 + 1;
            n1 = res.indexOf("<MatchDegree>");
            n2 = res.indexOf("</MatchDegree>", n1 + 1);
            int score = Integer.parseInt(res.substring(n1 + 13, n2));
            int rating = 5;
            n1 = res.indexOf("<Rating", 0);
            n2 = res.indexOf("</Rating>", n1);
            if (n2 > -1) {
                rating = Integer.parseInt(res.substring(n1 + 8, n2));
                if (rating < -10) {
                    rating = -10;
                } else if (rating > 10) {
                    rating = 10;
                }
            }
            if ((combinedScore = score) > 90) {
                combinedScore += rating - 10;
            }
            if (combinedScore < this.threshold) continue;
            n1 = res.indexOf("<MatchedOriginalText", 0);
            n2 = res.indexOf("</MatchedOriginalText", n1);
            String stext = null;
            if (n2 > -1) {
                stext = this.unescapeXML(res.substring(n1 + 21, n2));
            }
            String ttext = "";
            n1 = res.indexOf("<TranslatedText", n2);
            if ((n2 = res.indexOf("</TranslatedText", n1)) > -1) {
                ttext = this.unescapeXML(res.substring(n1 + 16, n2));
            }
            QueryResult qr = new QueryResult();
            qr.setQuality(Util.normalizeRange(-10.0, 10.0, rating));
            qr.setFuzzyScore(score);
            qr.setCombinedScore(combinedScore);
            qr.weight = this.getWeight();
            try {
                if (frag.hasCode()) {
                    qr.source = stext == null ? frag : new TextFragment(this.util.fromCodedHTML(stext, frag, false), frag.getClonedCodes());
                    qr.target = new TextFragment(this.util.fromCodedHTML(ttext, frag, false), frag.getClonedCodes());
                } else {
                    qr.source = stext == null ? frag : new TextFragment(this.util.fromCodedHTML(stext, frag, false));
                    qr.target = new TextFragment(this.util.fromCodedHTML(ttext, frag, false));
                }
            }
            catch (InvalidContentException e) {
                this.logger.error("This MT candidate will be ignored.\n{}\n{}", (Object)frag.toString(), (Object)e.getMessage());
                qr.setQuality(QueryResult.QUALITY_UNDEFINED);
                qr.setFuzzyScore(0);
                qr.setCombinedScore(0);
                qr.source = frag;
                qr.target = frag.clone();
            }
            qr.origin = this.getName();
            if (!Util.isEmpty(this.params.getCategory())) {
                qr.engine = this.params.getCategory();
            }
            qr.matchType = MatchType.MT;
            list.add(qr);
        }
        return list;
    }

    private List<List<QueryResult>> parseAllBlocks(String resp, List<TextFragment> fragments) {
        try {
            ArrayList<List<QueryResult>> list = new ArrayList<List<QueryResult>>();
            if (resp == null) {
                return list;
            }
            int from = 0;
            for (TextFragment frag : fragments) {
                if (!frag.hasText(false)) {
                    ArrayList res = new ArrayList();
                    list.add(res);
                    continue;
                }
                if ((from = resp.indexOf("<Translations>", from)) < 0) break;
                int n = resp.indexOf("</Translations>", from);
                String block = resp.substring(from, n);
                from = n + 1;
                list.add(this.parseBlock(block, frag));
            }
            return list;
        }
        catch (Throwable e) {
            throw new OkapiException("Error parsing translation results.", e);
        }
    }

    public int addTranslation(TextFragment source, TextFragment target, int rating) {
        try {
            String stext = this.util.toCodedHTML(source);
            String ttext = this.util.toCodedHTML(target);
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/AddTranslation?originaltext=%s&translatedtext=%s&from=%s&to=%s&user=defaultUser&rating=%d&category=%s", URLEncoder.encode(stext, "UTF-8"), URLEncoder.encode(ttext, "UTF-8"), this.srcCode, this.trgCode, rating, this.params.getCategory()));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("Authorization", "Bearer " + this.sToken);
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            return conn.getResponseCode();
        }
        catch (Throwable e) {
            throw new OkapiException("Error adding translation to the server.\n" + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTranslationList(List<TextFragment> sources, List<TextFragment> targets, List<Integer> ratings) {
        StringWriter strWriter = null;
        try {
            if (targets.size() != sources.size()) {
                throw new OkapiException("There should be as many targets as sources.");
            }
            if (ratings.size() != sources.size()) {
                throw new OkapiException("There should be as many ratings as sources.");
            }
            if (sources.size() > 100) {
                throw new OkapiException("No more than 100 segments allowed.");
            }
            if (this.addListTemplate == null) {
                strWriter = new StringWriter();
                XMLWriter xmlWriter = new XMLWriter(strWriter);
                xmlWriter.writeStartDocument();
                xmlWriter.writeStartElement("AddtranslationsRequest");
                xmlWriter.writeAttributeString("xmlns:o", "http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2");
                xmlWriter.writeElementString("AppId", "");
                xmlWriter.writeElementString("From", this.srcCode);
                xmlWriter.writeStartElement("Options");
                xmlWriter.writeElementString("o:Category", this.params.getCategory());
                xmlWriter.writeElementString("o:ContentType", "text/html");
                xmlWriter.writeElementString("o:ReservedFlags", "");
                xmlWriter.writeElementString("o:State", "");
                xmlWriter.writeElementString("o:Uri", "");
                xmlWriter.writeElementString("o:User", "defaultUser");
                xmlWriter.writeEndElement();
                xmlWriter.writeElementString("To", this.trgCode);
                xmlWriter.writeStartElement("Translations");
                xmlWriter.writeRawXML("[$#@list@#$]");
                xmlWriter.writeEndElement();
                xmlWriter.writeEndElement();
                xmlWriter.writeEndDocument();
                xmlWriter.close();
                strWriter.close();
                this.addListTemplate = strWriter.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sources.size(); ++i) {
                TextFragment src = sources.get(i);
                TextFragment trg = targets.get(i);
                int rating = ratings.get(i);
                if (rating < -10 && rating > 10) {
                    rating = 4;
                }
                sb.append("<o:Translation>");
                sb.append("<o:OriginalText>");
                String tmp = this.util.toCodedHTML(src);
                sb.append(Util.escapeToXML(tmp, 0, false, null));
                sb.append("</o:OriginalText>");
                sb.append(String.format("<o:Rating>%d</o:Rating>", rating));
                sb.append(String.format("<o:Sequence>%d</o:Sequence>", 0));
                sb.append("<o:TranslatedText>");
                tmp = this.util.toCodedHTML(trg);
                sb.append(Util.escapeToXML(tmp, 0, false, null));
                sb.append("</o:TranslatedText>");
                sb.append("</o:Translation>");
            }
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/AddTranslationArray", new Object[0]));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("Content-Type", "text/xml");
            conn.setRequestProperty("Authorization", "Bearer " + this.sToken);
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
                String query = this.addListTemplate.replace("[$#@list@#$]", sb.toString());
                osw.write(query);
            }
            finally {
                osw.flush();
                osw.close();
            }
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new OkapiException("HTTP error when adding translation.\n" + conn.getResponseMessage());
            }
            return code;
        }
        catch (Throwable e) {
            throw new OkapiException("Error adding translations.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void leverage(ITextUnit tu) {
        this.leverageUsingBatchQuery(tu);
    }

    @Override
    public void batchLeverage(List<ITextUnit> tuList) {
        this.batchLeverageUsingBatchQuery(tuList);
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        ArrayList<List<QueryResult>> list = new ArrayList<List<QueryResult>>();
        int nEwLen = 0;
        boolean bGotSome = false;
        StringWriter strWriter = null;
        try {
            if (this.queryListTemplate == null) {
                strWriter = new StringWriter();
                XMLWriter xmlWriter = new XMLWriter(strWriter);
                xmlWriter.writeStartDocument();
                xmlWriter.writeStartElement("GetTranslationsArrayRequest");
                xmlWriter.writeElementString("AppId", "");
                xmlWriter.writeElementString("From", this.srcCode);
                xmlWriter.writeStartElement("Options");
                xmlWriter.writeAttributeString("xmlns:o", "http://schemas.datacontract.org/2004/07/Microsoft.MT.Web.Service.V2");
                xmlWriter.writeElementString("o:Category", this.params.getCategory());
                xmlWriter.writeElementString("o:ContentType", "text/html");
                xmlWriter.writeElementString("o:ReservedFlags", "");
                xmlWriter.writeElementString("o:State", "");
                xmlWriter.writeElementString("o:Uri", "");
                xmlWriter.writeElementString("o:User", "");
                xmlWriter.writeEndElement();
                xmlWriter.writeStartElement("Texts");
                xmlWriter.writeAttributeString("xmlns:s", "http://schemas.microsoft.com/2003/10/Serialization/Arrays");
                xmlWriter.writeRawXML("[$#@list@#$]");
                xmlWriter.writeEndElement();
                xmlWriter.writeElementString("To", this.trgCode);
                xmlWriter.writeElementString("MaxTranslations", String.valueOf(this.maximumHits));
                xmlWriter.writeEndElement();
                xmlWriter.writeEndDocument();
                xmlWriter.close();
                strWriter.close();
                this.queryListTemplate = strWriter.toString();
            }
            int nCharCount = this.queryListTemplate.length() + 200;
            StringBuilder sb = new StringBuilder();
            ArrayList<TextFragment> subFragments = new ArrayList<TextFragment>();
            List<Object> subList = new ArrayList();
            for (TextFragment tf : fragments) {
                if (!tf.hasText(false)) continue;
                String stext = this.util.toCodedHTML(tf);
                String sEscapee = Util.escapeToXML(stext, 0, false, null);
                nEwLen = 21 + sEscapee.length();
                if (nEwLen + this.queryListTemplate.length() + 200 > 10000) {
                    this.logger.warn("Segment starting with '{}' is too long to query.", (Object)sEscapee.substring(0, 20));
                    continue;
                }
                if (nCharCount + nEwLen > 10000) {
                    subList = this.subBatchQuery(this.queryListTemplate, sb, subFragments);
                    Iterator<Object> it = subList.iterator();
                    while (it.hasNext()) {
                        list.add((List<QueryResult>)it.next());
                        bGotSome = true;
                    }
                    nCharCount = this.queryListTemplate.length() + 200;
                    sb = new StringBuilder();
                    subFragments = new ArrayList();
                    subList = new ArrayList();
                }
                sb.append("<s:string>");
                sb.append(sEscapee);
                sb.append("</s:string>");
                nCharCount += nEwLen;
                subFragments.add(tf);
            }
            if (!bGotSome && sb.length() == 0) {
                for (int i = 0; i < fragments.size(); ++i) {
                    ArrayList res = new ArrayList();
                    list.add(res);
                }
                return list;
            }
            subList = this.subBatchQuery(this.queryListTemplate, sb, subFragments);
            Iterator<Object> it = subList.iterator();
            while (it.hasNext()) {
                list.add((List<QueryResult>)it.next());
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error when translating batch.\n" + e.getMessage(), e);
        }
        return list;
    }

    private List<List<QueryResult>> subBatchQuery(String subQueryListTemplate, StringBuilder sb, List<TextFragment> fragments) {
        List<List<QueryResult>> list = new ArrayList<List<QueryResult>>();
        try {
            String query = subQueryListTemplate.replace("[$#@list@#$]", sb.toString());
            String sAddress = String.format("http://api.microsofttranslator.com/v2/Http.svc/GetTranslationsArray", new Object[0]);
            for (int tries = 0; tries < 5; ++tries) {
                String sBlock;
                if (!this.getNewTokenIfNeeded()) {
                    throw new OkapiException("Error getting Microsoft Azure access token for translation");
                }
                if (tries == 4) {
                    this.logger.error(String.format("Failed to get Microsoft Translator access token after %d tries. Skipping query for %s", 3, sb.toString()));
                }
                if ((sBlock = this.postQuery(sAddress, query)) == null) {
                    try {
                        Thread.sleep(this.SLEEPPAUSE);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new OkapiException("Interrupted while waiting for Microsoft Translator access token");
                    }
                }
                list = this.parseAllBlocks(sBlock, fragments);
                break;
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error when batch translating.\n" + e.getMessage(), e);
        }
        return list;
    }

    private boolean getNewTokenIfNeeded() {
        boolean bResult = true;
        long lNow = this.getCurrentTime();
        if (lNow > this.lExpirationTime - 500L) {
            Long lDiff = lNow - this.lExpirationTime;
            if (lDiff > 0L && lDiff < 500L) {
                try {
                    Thread.sleep(lNow - this.lExpirationTime);
                }
                catch (InterruptedException e) {
                    throw new OkapiException("Sleep interrupted while attempting to get Azure Marketplace Token" + e.getMessage(), e);
                }
            }
            for (int tries = 0; tries < 3; ++tries) {
                if (this.getAccessToken()) {
                    bResult = true;
                    break;
                }
                if (tries == 2) {
                    throw new OkapiException(String.format("Failed to get Microsoft Translator access token after %d tries.", 3));
                }
                try {
                    Thread.sleep(this.SLEEPPAUSE);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new OkapiException("Interrupted while waiting for Microsoft Translator access token");
                }
            }
        }
        return bResult;
    }

    private boolean getAccessToken() {
        boolean bResult = false;
        try {
            String tokenRes = ApacheHttpClientForMT.getAzureAccessToken("https://datamarket.accesscontrol.windows.net/v2/OAuth2-13", this.params.getClientId(), this.params.getSecret());
            if (tokenRes != null) {
                this.sToken = this.parseTokenForm(tokenRes);
                if (!this.sToken.equals("")) {
                    bResult = true;
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Error in getAccessToken: {}", (Object)e.getMessage());
        }
        return bResult;
    }

    private String parseTokenForm(String sBlock) {
        String sAccessToken = "";
        Long lExpiresAt = 0L;
        String sExpiresAt = "0";
        long lDies = 0L;
        int n1 = sBlock.indexOf("access_token\":\"");
        int n2 = sBlock.indexOf("\"", n1 + 15);
        if (n1 > 0 && n2 > 0) {
            sAccessToken = sBlock.substring(n1 + 15, n2);
            n1 = sBlock.indexOf("ExpiresOn=");
            n2 = sBlock.indexOf("&", n1 + 10);
            if (n1 > 0 && n2 > 0) {
                sExpiresAt = sBlock.substring(n1 + 10, n2);
                try {
                    lExpiresAt = Long.valueOf(sExpiresAt);
                }
                catch (Exception e) {
                    lExpiresAt = 0L;
                }
            }
            try {
                lDies = 1000L * lExpiresAt;
            }
            catch (Exception e) {
                lDies = 0L;
            }
        }
        if (lDies <= 0L) {
            sAccessToken = "";
        }
        this.lExpirationTime = lDies;
        return sAccessToken;
    }

    private long getCurrentTime() {
        Date date = new Date();
        return date.getTime();
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        if (code.equals("zh-tw") || code.equals("zh-hant") || code.equals("zh-cht")) {
            code = "zh-CHT";
        } else if (code.startsWith("zh")) {
            code = "zh-CHS";
        } else if (!code.startsWith("pt") && !code.equals("es-419")) {
            code = locale.getLanguage();
        }
        return code;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public boolean hasNext() {
        if (this.results == null) {
            return false;
        }
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.results == null) {
            return null;
        }
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public int getMaximumHits() {
        return this.maximumHits;
    }

    @Override
    public void setMaximumHits(int maximumHits) {
        this.maximumHits = maximumHits;
        this.queryListTemplate = null;
        this.addListTemplate = null;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
        this.threshold = -10;
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        super.setLanguages(sourceLocale, targetLocale);
        this.queryListTemplate = null;
        this.addListTemplate = null;
    }
}

