/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;

public class Parameters
extends StringParameters
implements ISimplifierRulesParameters {
    private static final String EXTRACTISOLATEDSTRINGS = "extractIsolatedStrings";
    private static final String EXTRACTALLPAIRS = "extractAllPairs";
    private static final String EXCEPTIONS = "exceptions";
    private static final String USEKEYASNAME = "useKeyAsName";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String USEFULLKEYPATH = "useFullKeyPath";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String SUBFILTER = "subfilter";
    private InlineCodeFinder codeFinder;

    public boolean getExtractStandalone() {
        return this.getBoolean(EXTRACTISOLATEDSTRINGS);
    }

    public void setExtractStandalone(boolean extractStandalone) {
        this.setBoolean(EXTRACTISOLATEDSTRINGS, extractStandalone);
    }

    public boolean getExtractAllPairs() {
        return this.getBoolean(EXTRACTALLPAIRS);
    }

    public void setExtractAllPairs(boolean extractAllPairs) {
        this.setBoolean(EXTRACTALLPAIRS, extractAllPairs);
    }

    public String getExceptions() {
        return this.getString(EXCEPTIONS);
    }

    public void setExceptions(String exceptions) {
        this.setString(EXCEPTIONS, exceptions);
    }

    public boolean getUseKeyAsName() {
        return this.getBoolean(USEKEYASNAME);
    }

    public void setUseKeyAsName(boolean useKeyAsName) {
        this.setBoolean(USEKEYASNAME, useKeyAsName);
    }

    public boolean getUseFullKeyPath() {
        return this.getBoolean(USEFULLKEYPATH);
    }

    public void setUseFullKeyPath(boolean useFullKeyPath) {
        this.setBoolean(USEFULLKEYPATH, useFullKeyPath);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
        if (this.getUseCodeFinder()) {
            this.setSubfilter("");
        }
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getSubfilter() {
        return this.getString(SUBFILTER);
    }

    public void setSubfilter(String subfilter) {
        this.setString(SUBFILTER, subfilter);
        if (!"".equals(this.getSubfilter())) {
            this.setUseCodeFinder(false);
        }
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    @Override
    public void reset() {
        super.reset();
        this.setExtractStandalone(false);
        this.setExtractAllPairs(true);
        this.setExceptions("");
        this.setUseKeyAsName(true);
        this.setUseFullKeyPath(false);
        this.setUseCodeFinder(false);
        this.setSubfilter(null);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
        this.setSimplifierRules(null);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

