/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BlockParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockParser.class);
    private StartElement blockStartEvent;
    private XMLEventReader events;
    private XMLEventFactory eventFactory;
    private ConditionalParameters params;
    private IdGenerator nestedBlockIdGenerator;
    private StyleDefinitions styleDefinitions;
    private ElementSkipper generalElementSkipper;
    private ElementSkipper bookmarkElementSkipper;

    BlockParser(StartElement startEvent, XMLEventReader events, XMLEventFactory eventFactory, ConditionalParameters params, IdGenerator nestedBlockIdGenerator, StyleDefinitions styleDefinitions) {
        this.blockStartEvent = startEvent;
        this.events = events;
        this.eventFactory = eventFactory;
        this.params = params;
        this.nestedBlockIdGenerator = nestedBlockIdGenerator;
        this.styleDefinitions = styleDefinitions;
        this.generalElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_INSERTED_PARAGRAPH_MARK, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTY_DELETED_PARAGRAPH_MARK, ElementSkipper.RevisionPropertySkippableElement.PARAGRAPH_PROPERTIES_CHANGE, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTIES_CHANGE);
        this.bookmarkElementSkipper = ElementSkipperFactory.createBookmarkElementSkipper(ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_START, ElementSkipper.GeneralCrossStructureSkippableElement.BOOKMARK_END);
    }

    private void addRunsToBuilder(BlockBuilder builder, RunMerger runMerger) throws XMLStreamException {
        for (Run run : runMerger.getRuns()) {
            builder.addChunk(run);
        }
        runMerger.reset();
    }

    private void parseRunContainer(BlockBuilder builder, StartElement runContainerStart) throws XMLStreamException {
        RunMerger runMerger = new RunMerger();
        while (this.events.hasNext()) {
            XMLEvent e = this.events.nextEvent();
            if (e.isEndElement() && runContainerStart.getName().equals(e.asEndElement().getName())) {
                builder.addChunk(new RunContainer(runContainerStart, e.asEndElement(), runMerger.getRuns()));
                return;
            }
            if (!XMLEventHelpers.isRunStartEvent(e)) continue;
            this.processRun(builder, runMerger, e.asStartElement());
        }
        throw new IllegalStateException("Invalid content? Unterminated run container");
    }

    Block parse() throws XMLStreamException {
        BlockBuilder builder = new BlockBuilder();
        this.log("startBlock: " + this.blockStartEvent);
        builder.addMarkupComponent(MarkupComponentFactory.createStartMarkupComponent(this.eventFactory, AttributeStripper.RevisionAttributeStripper.stripParagraphRevisionAttributes(this.eventFactory, this.blockStartEvent)));
        RunMerger runMerger = new RunMerger();
        while (this.events.hasNext()) {
            XMLEvent e = this.events.nextEvent();
            if (XMLEventHelpers.isParagraphPropertiesStartEvent(e)) {
                MarkupComponent blockProperties = MarkupComponentParser.parseBlockProperties(this.events, this.eventFactory, e.asStartElement(), this.generalElementSkipper);
                builder.addMarkupComponent(blockProperties);
                String paragraphStyle = this.getParagraphStyle(((BlockProperties)blockProperties).getParagraphStyleProperty());
                runMerger.setParagraphStyle(paragraphStyle);
                builder.setIsHidden(this.hasToBeHidden(paragraphStyle));
                continue;
            }
            if (XMLEventHelpers.isRunStartEvent(e)) {
                this.processRun(builder, runMerger, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isRunContainerStartEvent(e)) {
                StartElement runContainerStart = e.asStartElement();
                this.addRunsToBuilder(builder, runMerger);
                this.parseRunContainer(builder, runContainerStart);
                continue;
            }
            if (XMLEventHelpers.isSimpleFieldStartEvent(e)) {
                this.addRunsToBuilder(builder, runMerger);
                for (XMLEvent fldEvent : XMLEventHelpers.gatherEvents(e.asStartElement(), this.events)) {
                    builder.addEvent(fldEvent);
                }
                builder.flushMarkup();
                continue;
            }
            if (this.processSkippableElements(e) || XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(builder, runMerger);
            if (e.isEndElement() && this.blockStartEvent.getName().equals(e.asEndElement().getName())) {
                builder.addMarkupComponent(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                this.log("End block: " + e);
                return builder.build();
            }
            builder.addEvent(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated paragraph");
    }

    private boolean processSkippableElements(XMLEvent event) throws XMLStreamException {
        if (ElementSkipper.GeneralElementSkipper.isInsertedRunContentElement(event)) {
            return true;
        }
        if (ElementSkipper.GeneralElementSkipper.isDeletedRunContentStartElement(event)) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(this.events, event.asStartElement());
            return true;
        }
        if (ElementSkipper.GeneralElementSkipper.isProofingErrorStartElement(event)) {
            ElementSkipper.GeneralElementSkipper.skipElementEvents(this.events, event.asStartElement());
            return true;
        }
        if (event.isStartElement() && this.bookmarkElementSkipper.isSkippableElement(event.asStartElement())) {
            this.bookmarkElementSkipper.skipElement(this.events, event.asStartElement());
            return true;
        }
        return false;
    }

    private void processRun(BlockBuilder builder, RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        RunParser runParser = new RunParser(startEl, this.events, this.eventFactory, this.nestedBlockIdGenerator, this.params, this.styleDefinitions).parse();
        builder.setRunName(startEl.getName());
        builder.setTextName(runParser.getTextName());
        runMerger.add(runParser);
    }

    private String getParagraphStyle(BlockProperty paragraphStyleProperty) {
        if (null == paragraphStyleProperty) {
            return null;
        }
        return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
    }

    private boolean hasToBeHidden(String paragraphStyle) {
        return !this.params.getTranslateWordHidden() && null != paragraphStyle && this.params.tsExcludeWordStyles.contains(paragraphStyle);
    }

    private void log(String s) {
        LOGGER.debug(s);
    }

    private class BlockBuilder {
        private List<Chunk> chunks = new ArrayList<Chunk>();
        private List<XMLEvent> currentMarkupComponentEvents = new ArrayList<XMLEvent>();
        private Markup markup = new Block.BlockMarkup();
        private boolean isHidden = false;
        private QName runName;
        private QName textName;

        BlockBuilder() {
        }

        void setIsHidden(boolean isHidden) {
            this.isHidden = isHidden;
        }

        void setRunName(QName runName) {
            if (this.runName == null) {
                this.runName = runName;
            }
        }

        void setTextName(QName textName) {
            if (this.textName == null) {
                this.textName = textName;
            }
        }

        private void flushMarkup() {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            if (!this.markup.getComponents().isEmpty()) {
                this.chunks.add(this.markup);
                this.markup = new Block.BlockMarkup();
            }
        }

        void addEvent(XMLEvent event) {
            this.currentMarkupComponentEvents.add(event);
        }

        void addChunk(Chunk chunk) {
            this.flushMarkup();
            this.chunks.add(chunk);
        }

        void addMarkupComponent(MarkupComponent markupComponent) {
            if (!this.currentMarkupComponentEvents.isEmpty()) {
                this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.currentMarkupComponentEvents));
                this.currentMarkupComponentEvents = new ArrayList<XMLEvent>();
            }
            this.markup.addComponent(markupComponent);
        }

        Block build() {
            this.flushMarkup();
            return new Block(this.chunks, this.runName, this.textName, this.isHidden);
        }
    }

    static class RunMerger {
        private String paragraphStyle;
        private RunParser previousRunParser;
        private List<Run> completedRuns = new ArrayList<Run>();

        RunMerger() {
        }

        void setParagraphStyle(String paragraphStyle) {
            this.paragraphStyle = paragraphStyle;
        }

        void add(RunParser rp) throws XMLStreamException {
            if (this.previousRunParser != null) {
                if (this.previousRunParser.canMerge(rp, this.paragraphStyle)) {
                    this.previousRunParser.merge(rp);
                } else {
                    this.completedRuns.add(this.previousRunParser.build());
                    this.previousRunParser = rp;
                }
            } else {
                this.previousRunParser = rp;
            }
        }

        List<Run> getRuns() throws XMLStreamException {
            if (this.previousRunParser != null) {
                this.completedRuns.add(this.previousRunParser.build());
                this.previousRunParser = null;
            }
            return this.completedRuns;
        }

        void reset() {
            this.completedRuns.clear();
            this.previousRunParser = null;
        }
    }
}

