/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ElementSkipperStrategy;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class ElementSkipper {
    private ElementSkipperStrategy elementSkipperStrategy;

    protected ElementSkipper(ElementSkipperStrategy elementSkipperStrategy) {
        this.elementSkipperStrategy = elementSkipperStrategy;
    }

    boolean isSkippableElement(StartElement startElement) {
        return this.elementSkipperStrategy.isSkippableElement(startElement);
    }

    void skipElement(XMLEventReader eventReader, StartElement startElement) throws XMLStreamException {
        this.elementSkipperStrategy.skipElement(eventReader, startElement);
    }

    static enum RevisionPropertySkippableElement implements PropertySkippableElement
    {
        RUN_PROPERTY_INSERTED_PARAGRAPH_MARK("ins"),
        RUN_PROPERTY_DELETED_PARAGRAPH_MARK("del"),
        PARAGRAPH_PROPERTIES_CHANGE("pPrChange"),
        RUN_PROPERTIES_CHANGE("rPrChange"),
        SECTION_PROPERTIES_CHANGE("sectPrChange"),
        TABLE_GRID_CHANGE("tblGridChange"),
        TABLE_PROPERTIES_CHANGE("tblPrChange"),
        TABLE_PROPERTIES_EXCEPTIONS_CHANGE("tblPrExChange"),
        TABLE_CELL_PROPERTIES_CHANGE("tcPrChange"),
        TABLE_ROW_PROPERTIES_CHANGE("trPrChange");

        private String value;

        private RevisionPropertySkippableElement(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static enum RunPropertySkippableElement implements PropertySkippableElement
    {
        RUN_PROPERTY_COMPLEX_SCRIPT_BOLD("bCs"),
        RUN_PROPERTY_LANGUAGE("lang"),
        RUN_PROPERTY_NO_SPELLING_OR_GRAMMAR("noProof"),
        RUN_PROPERTY_CHARACTER_SPACING("spacing"),
        RUN_PROPERTY_COMPLEX_SCRIPT_FONT_SIZE("szCs"),
        RUN_PROPERTY_CHARACTER_WIDTH("w"),
        RUN_PROPERTY_VERTICAL_ALIGNMENT("vertAlign");

        private String value;

        private RunPropertySkippableElement(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static interface PropertySkippableElement
    extends SkippableElement {
    }

    static enum GeneralCrossStructureSkippableElement implements CrossStructureSkippableElement
    {
        BOOKMARK_START("bookmarkStart"),
        BOOKMARK_END("bookmarkEnd");

        private String value;

        private GeneralCrossStructureSkippableElement(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static interface CrossStructureSkippableElement
    extends SkippableElement {
    }

    static enum RevisionInlineSkippableElement implements InlineSkippableElement
    {
        RUN_INSERTED_CONTENT("ins"),
        RUN_DELETED_CONTENT("del");

        private String value;

        private RevisionInlineSkippableElement(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static enum GeneralInlineSkippableElement implements InlineSkippableElement
    {
        PROOFING_ERROR_ANCHOR("proofErr");

        private String value;

        private GeneralInlineSkippableElement(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static interface InlineSkippableElement
    extends SkippableElement {
    }

    static interface SkippableElement {
        public String getValue();
    }

    static class BookmarkElementSkipper
    extends ElementSkipper {
        BookmarkElementSkipper(ElementSkipperStrategy elementSkipperStrategy) {
            super(elementSkipperStrategy);
        }

        static boolean isBookmarkStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, GeneralCrossStructureSkippableElement.BOOKMARK_START.getValue());
        }

        static boolean isBookmarkEndElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, GeneralCrossStructureSkippableElement.BOOKMARK_END.getValue());
        }
    }

    static class GeneralElementSkipper
    extends ElementSkipper {
        GeneralElementSkipper(ElementSkipperStrategy elementSkipperStrategy) {
            super(elementSkipperStrategy);
        }

        static boolean isProofingErrorStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, GeneralInlineSkippableElement.PROOFING_ERROR_ANCHOR.getValue());
        }

        static boolean isInsertedRunContentElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionInlineSkippableElement.RUN_INSERTED_CONTENT.getValue()) || XMLEventHelpers.isEndElement(event, RevisionInlineSkippableElement.RUN_INSERTED_CONTENT.getValue());
        }

        static boolean isDeletedRunContentStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionInlineSkippableElement.RUN_DELETED_CONTENT.getValue());
        }

        static boolean isSectionPropertiesChangeStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionPropertySkippableElement.SECTION_PROPERTIES_CHANGE.getValue());
        }

        static boolean isTableGridChangeStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionPropertySkippableElement.TABLE_GRID_CHANGE.getValue());
        }

        static boolean isTablePropertiesExceptionsChangeStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionPropertySkippableElement.TABLE_PROPERTIES_EXCEPTIONS_CHANGE.getValue());
        }

        static boolean isTableCellPropertiesChangeStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionPropertySkippableElement.TABLE_CELL_PROPERTIES_CHANGE.getValue());
        }

        static boolean isTableRowPropertiesChangeStartElement(XMLEvent event) {
            return XMLEventHelpers.isStartElement(event, RevisionPropertySkippableElement.TABLE_ROW_PROPERTIES_CHANGE.getValue());
        }

        static void skipElementEvents(XMLEventReader eventReader, StartElement startElement) throws XMLStreamException {
            ElementSkipperStrategy.GeneralElementSkipperStrategy.skipElementEvents(eventReader, startElement);
        }
    }
}

