/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

public class Run
implements Block.BlockChunk {
    private StartElement startEvent;
    private EndElement endEvent;
    private RunProperties runProperties;
    private List<Chunk> bodyChunks;
    private List<Textual> nestedTextualItems;

    Run(StartElement startEvent, EndElement endEvent, RunProperties runProperties, List<Chunk> bodyChunks, List<Textual> nestedTextualItems) {
        this.startEvent = startEvent;
        this.endEvent = endEvent;
        this.runProperties = runProperties;
        this.bodyChunks = bodyChunks;
        this.nestedTextualItems = nestedTextualItems;
    }

    public RunProperties getProperties() {
        return this.runProperties;
    }

    public List<Chunk> getBodyChunks() {
        return this.bodyChunks;
    }

    public List<Textual> getNestedTextualItems() {
        return this.nestedTextualItems;
    }

    public boolean containsText() {
        for (Chunk c : this.bodyChunks) {
            if (!(c instanceof RunText)) continue;
            return !this.getProperties().isHidden();
        }
        return false;
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startEvent);
        events.addAll(this.runProperties.getEvents());
        for (XMLEvents xMLEvents : this.bodyChunks) {
            events.addAll(xMLEvents.getEvents());
        }
        events.add(this.endEvent);
        return events;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + XMLEventSerializer.serialize(this.getEvents()) + "]";
    }

    static class RunMarkup
    extends Markup
    implements RunChunk {
        RunMarkup() {
        }
    }

    public static interface RunChunk
    extends Chunk {
    }

    public static class RunText
    implements RunChunk {
        private StartElement startText;
        private Characters text;
        private EndElement endText;

        RunText(StartElement startText, Characters text, EndElement endText) {
            this.startText = startText;
            this.text = text;
            this.endText = endText;
        }

        public boolean isPreserveSpace() {
            return XMLEventHelpers.hasPreserveWhitespace(this.startText);
        }

        public String getText() {
            return this.text.getData();
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(3);
            events.add(this.startText);
            events.add(this.text);
            events.add(this.endText);
            return events;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + XMLEventSerializer.serialize(this.startText) + "](" + this.text + ")";
        }
    }
}

