/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

public class RunContainer
implements Block.BlockChunk {
    private StartElement startElement;
    private EndElement endElement;
    private List<Run> runs = new ArrayList<Run>();

    RunContainer(StartElement startElement, EndElement endElement, List<Run> runs) {
        this.startElement = startElement;
        this.endElement = endElement;
        this.runs.addAll(runs);
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public StartElement getStartElement() {
        return this.startElement;
    }

    public EndElement getEndElement() {
        return this.endElement;
    }

    public boolean containsText() {
        for (Run run : this.getRuns()) {
            if (!run.containsText()) continue;
            return true;
        }
        return false;
    }

    public RunProperties getDefaultRunProperties() {
        return this.runs.get(0).getProperties();
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startElement);
        for (Run run : this.runs) {
            events.addAll(run.getEvents());
        }
        events.add(this.endElement);
        return events;
    }

    public String toString() {
        return "RunContainer(" + XMLEventSerializer.serialize(this.startElement) + ", " + this.runs.size() + ")[" + this.runs + "]";
    }

    static enum Type {
        HYPERLINK("hyperlink");

        String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

