/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEvents;

public abstract class RunProperties
implements XMLEvents {
    abstract List<RunProperty> getProperties();

    public int count() {
        return this.getProperties().size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RunProperties)) {
            return false;
        }
        return this.equalsProperties((RunProperties)o);
    }

    protected abstract boolean equalsProperties(RunProperties var1);

    public abstract int hashCode();

    @Override
    public abstract List<XMLEvent> getEvents();

    public abstract RunProperties combineDistinct(RunProperties var1, StyleDefinitions.TraversalStage var2);

    public boolean isHidden() {
        for (RunProperty property : this.getProperties()) {
            if (!property.isHidden()) continue;
            return true;
        }
        return false;
    }

    public RunProperty.RunStyleProperty getRunStyleProperty() {
        for (RunProperty property : this.getProperties()) {
            if (!(property instanceof RunProperty.RunStyleProperty)) continue;
            return (RunProperty.RunStyleProperty)property;
        }
        return null;
    }

    public List<RunProperty> getMergeableRunProperties() {
        ArrayList<RunProperty> properties = new ArrayList<RunProperty>(this.getProperties().size());
        for (RunProperty property : this.getProperties()) {
            if (!(property instanceof MergeableRunProperty)) continue;
            properties.add(property);
        }
        return properties;
    }

    public static RunProperties copiedRunProperties(RunProperties existingProperties, boolean stripVerticalAlign, boolean stripRunStyle, boolean stripToggle) {
        if (existingProperties instanceof EmptyRunProperties) {
            return existingProperties;
        }
        ArrayList<RunProperty> newRunProperties = new ArrayList<RunProperty>();
        for (RunProperty p : existingProperties.getProperties()) {
            if (stripToggle && p instanceof RunProperty.ToggleRunProperty || stripRunStyle && p instanceof RunProperty.RunStyleProperty || stripVerticalAlign && p instanceof RunProperty.GenericRunProperty && ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_VERTICAL_ALIGNMENT.getValue().equals(p.getName().getLocalPart())) continue;
            newRunProperties.add(p);
        }
        return new DefaultRunProperties(((DefaultRunProperties)existingProperties).startElement, ((DefaultRunProperties)existingProperties).endElement, newRunProperties);
    }

    public static RunProperties copiedRunProperties(RunProperties runProperties) {
        if (runProperties instanceof EmptyRunProperties) {
            return runProperties;
        }
        ArrayList<RunProperty> properties = new ArrayList<RunProperty>(runProperties.getProperties());
        return new DefaultRunProperties(((DefaultRunProperties)runProperties).startElement, ((DefaultRunProperties)runProperties).endElement, properties);
    }

    public static RunProperties copiedToggleRunProperties(RunProperties runProperties) {
        if (runProperties instanceof EmptyRunProperties) {
            return runProperties;
        }
        ArrayList<RunProperty> properties = new ArrayList<RunProperty>(runProperties.count());
        for (RunProperty property : runProperties.getProperties()) {
            if (!(property instanceof RunProperty.ToggleRunProperty)) continue;
            properties.add(property);
        }
        return new DefaultRunProperties(((DefaultRunProperties)runProperties).startElement, ((DefaultRunProperties)runProperties).endElement, properties);
    }

    public static RunProperties emptyRunProperties() {
        return new EmptyRunProperties();
    }

    static RunProperties defaultRunProperties(StartElement startElement, EndElement endElement, RunProperty ... properties) {
        return new DefaultRunProperties(startElement, endElement, new ArrayList<RunProperty>(Arrays.asList(properties)));
    }

    public boolean isSubsetOf(RunProperties other) {
        if (this.getProperties().isEmpty() && !other.getProperties().isEmpty()) {
            return false;
        }
        block0: for (RunProperty myProperty : this.getProperties()) {
            for (RunProperty otherProperty : other.getProperties()) {
                if (!otherProperty.equalsProperty(myProperty)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    static class DefaultRunProperties
    extends RunProperties {
        private StartElement startElement;
        private EndElement endElement;
        private List<RunProperty> properties = new ArrayList<RunProperty>();

        DefaultRunProperties(StartElement startElement, EndElement endElement, List<RunProperty> properties) {
            this.startElement = startElement;
            this.endElement = endElement;
            this.properties.addAll(properties);
        }

        @Override
        public List<RunProperty> getProperties() {
            return this.properties;
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.startElement);
            for (RunProperty property : this.properties) {
                events.addAll(property.getEvents());
            }
            events.add(this.endElement);
            return events;
        }

        @Override
        public RunProperties combineDistinct(RunProperties otherProperties, StyleDefinitions.TraversalStage traversalStage) {
            ListIterator<RunProperty> runPropertyIterator = this.properties.listIterator();
            while (runPropertyIterator.hasNext()) {
                RunProperty runProperty = runPropertyIterator.next();
                QName runPropertyStartElementName = runProperty.getName();
                Iterator<RunProperty> otherRunPropertyIterator = otherProperties.getProperties().iterator();
                while (otherRunPropertyIterator.hasNext()) {
                    RunProperty otherRunProperty = otherRunPropertyIterator.next();
                    if (!runPropertyStartElementName.equals(otherRunProperty.getName())) continue;
                    this.replace(runPropertyIterator, otherRunPropertyIterator, runProperty, otherRunProperty, traversalStage);
                    break;
                }
                if (!otherProperties.getProperties().isEmpty()) continue;
                break;
            }
            if (!otherProperties.getProperties().isEmpty()) {
                this.properties.addAll(otherProperties.getProperties());
            }
            return this;
        }

        private void replace(ListIterator<RunProperty> runPropertyIterator, Iterator<RunProperty> otherRunPropertyIterator, RunProperty runProperty, RunProperty otherRunProperty, StyleDefinitions.TraversalStage traversalStage) {
            if (runProperty instanceof RunProperty.ToggleRunProperty) {
                boolean otherRunPropertyValue;
                boolean runPropertyValue;
                if (StyleDefinitions.TraversalStage.VERTICAL == traversalStage) {
                    runPropertyValue = ((RunProperty.ToggleRunProperty)runProperty).getValue();
                    if (!(runPropertyValue ^ (otherRunPropertyValue = ((RunProperty.ToggleRunProperty)otherRunProperty).getValue()))) {
                        runPropertyIterator.remove();
                        otherRunPropertyIterator.remove();
                        return;
                    }
                    if (runPropertyValue) {
                        otherRunPropertyIterator.remove();
                        return;
                    }
                }
                if (StyleDefinitions.TraversalStage.DOCUMENT_DEFAULT == traversalStage) {
                    runPropertyValue = ((RunProperty.ToggleRunProperty)runProperty).getValue();
                    otherRunPropertyValue = ((RunProperty.ToggleRunProperty)otherRunProperty).getValue();
                    if (runPropertyValue && otherRunPropertyValue || runPropertyValue) {
                        otherRunPropertyIterator.remove();
                        return;
                    }
                }
            }
            runPropertyIterator.set(otherRunProperty);
            otherRunPropertyIterator.remove();
        }

        @Override
        protected boolean equalsProperties(RunProperties o) {
            if (o instanceof EmptyRunProperties) {
                return this.count() == o.count();
            }
            if (!(o instanceof DefaultRunProperties)) {
                return false;
            }
            DefaultRunProperties rp = (DefaultRunProperties)o;
            if (!XMLEventHelpers.startElementEquals(this.startElement, rp.startElement)) {
                return false;
            }
            return this.properties.equals(rp.properties);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.startElement, this.endElement, this.properties);
        }

        public String toString() {
            return "rPr(" + this.properties.size() + ")[" + this.properties + "]";
        }
    }

    static class EmptyRunProperties
    extends RunProperties {
        EmptyRunProperties() {
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        protected boolean equalsProperties(RunProperties rp) {
            if (rp instanceof DefaultRunProperties) {
                return this.count() == rp.count();
            }
            return rp instanceof EmptyRunProperties;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public List<RunProperty> getProperties() {
            return Collections.emptyList();
        }

        @Override
        public RunProperties combineDistinct(RunProperties otherProperties, StyleDefinitions.TraversalStage traversalStage) {
            return otherProperties;
        }

        public String toString() {
            return "(No properties)";
        }
    }
}

